package com.artfess.gyl.base.model;

import com.artfess.base.entity.BizDelModel;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商资质库表，（供应商修改资质库文件提交后，是新添加一条数据，版本加1），新建的资质版本默认为1，这样就可以和供应商的
 *
 * @author 系统管理员
 * @since 2025-11-08
 */
@Data
@TableName("BIZ_SUPPLIER_QUALIFICATION_DATABASE")
@ApiModel(value="BizSupplierQualificationDatabase对象", description="供应商资质库表，（供应商修改资质库文件提交后，是新添加一条数据，版本加1），新建的资质版本默认为1，这样就可以和供应商的")
public class BizSupplierQualificationDatabase extends BizDelModel<BizSupplierQualificationDatabase> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "资质所属（0：企业，1：个人，默认0）")
    @TableField("QUALIFICATION_ATTRIBUTION_")
    private String qualificationAttribution;

    @ApiModelProperty(value = "姓名（资质为个人时填写）")
    @TableField("FULL_NAME_")
    private String fullName;

    @ApiModelProperty(value = "企业ID")
    @TableField("ENTERPRISE_ID_")
    private String enterpriseId;

    @ApiModelProperty(value = "企业编码")
    @TableField("ENTERPRISE_CODE_")
    private String enterpriseCode;

    @ApiModelProperty(value = "所属行业")
    @TableField("INDUSTRY_")
    private String industry;

    @ApiModelProperty(value = "资质类型编码（关联资质类型表编码）")
    @TableField("QUALIFICATION_CATEGORY_CODE_")
    private String qualificationCategoryCode;

    @ApiModelProperty(value = "资质类型流水号（同一条资质多个版本他们的流水号一致）")
    @TableField("QUALIFICATION_CATEGORY_NUMBER_")
    private String qualificationCategoryNumber;

    @ApiModelProperty(value = "资质类型名称")
    @TableField("QUALIFICATION_CATEGORY_NAME_")
    private String qualificationCategoryName;

    @ApiModelProperty(value = "资质全称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "资质编码")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "发证机构")
    @TableField("ISSUING_AUTHORITY_")
    private String issuingAuthority;

    @ApiModelProperty(value = "发证日期")
    @TableField("ISSUE_DATE_")
    private LocalDate issueDate;

    @ApiModelProperty(value = "时间期限(0.限时 1.长期)")
    @TableField("TIME_LIMIT_")
    private Integer timeLimit;

    @ApiModelProperty(value = "有效期截止")
    @TableField("VALID_UNTIL_")
    private LocalDate validUntil;

    @ApiModelProperty(value = "状态(1：正常，:2：到期，3：异常)")
    @TableField("STATUS_")
    private String status;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version=1L;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId="-1";

    @ApiModelProperty(value = "企业名称")
    @TableField(exist = false)
    private String enterpriseName;

    @ApiModelProperty(value = "附件集")
    @TableField(exist = false)
    private List<DefaultFile> files;
}
