package com.artfess.gyl.base.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商资质类型表
 *
 * @author 系统管理员
 * @since 2025-11-08
 */
@Data
@TableName("BIZ_SUPPLIER_QUALIFICATION_CATEGORY")
@ApiModel(value="BizSupplierQualificationCategory对象", description="供应商资质类型表")
public class BizSupplierQualificationCategory extends BizDelModel<BizSupplierQualificationCategory> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "资质类型编码")
    @TableField("QUALIFICATION_CATEGORY_CODE_")
    private String qualificationCategoryCode;

    @ApiModelProperty(value = "资质类型名称")
    @TableField("QUALIFICATION_CATEGORY_NAME_")
    private String qualificationCategoryName;

    @ApiModelProperty(value = "限制文件大小(M)")
    @TableField("LIMIT_FILE_SIZE_")
    private Integer limitFileSize;

    @ApiModelProperty(value = "状态(1：启用，0：禁用)")
    @TableField("STATUS_")
    private String status;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "排序号")
    @TableField("SEQ_")
    private Integer seq;

}
