package com.artfess.gyl.base.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 物资分类表
 *
 * @author 系统管理员
 * @since 2025-11-06
 */
@Data
@TableName("biz_supplier_material_category")
@ApiModel(value="BizSupplierMaterialCategory对象", description="物资分类表")
public class BizSupplierMaterialCategory extends BizDelModel<BizSupplierMaterialCategory> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "分类编码")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "分类名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "分类描述")
    @TableField("DESC_")
    private String desc;

    @ApiModelProperty(value = "排序号")
    @TableField("SEQ_")
    private Integer seq;

    @ApiModelProperty(value = "状态(1：启用，0：禁用)")
    @TableField("STATUS_")
    private String status;

}
