package com.artfess.gyl.base.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商绩效考核分类表
 *
 * @author 系统管理员
 * @since 2025-11-07
 */
@Data
@TableName("biz_supplier_assessment_indicator_type")
@ApiModel(value="BizSupplierAssessmentIndicatorType对象", description="供应商绩效考核分类表")
public class BizSupplierAssessmentIndicatorType extends BizDelModel<BizSupplierAssessmentIndicatorType> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "分类编码")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "分类名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "描述")
    @TableField("DESC_")
    private String desc;

    @ApiModelProperty(value = "权重")
    @TableField("WEIGHT_")
    private Integer weight;

    @ApiModelProperty(value = "状态(1：启用，0：禁用)")
    @TableField("STATUS_")
    private String status;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "排序号")
    @TableField("SEQ_")
    private Integer seq;
}
