package com.artfess.gyl.base.model;

import com.artfess.base.entity.BizDelModel;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 企业营业执照
 *
 * @author huqi
 * @since 2025-11-21
 */
@Data
@TableName("biz_enterprise_business_license")
@ApiModel(value="BizEnterpriseBusinessLicense对象", description="企业营业执照")
public class BizEnterpriseBusinessLicense extends BizDelModel<BizEnterpriseBusinessLicense> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "企业id")
    @TableField("ENTERPRISE_ID_")
    private String enterpriseId;

    @ApiModelProperty(value = "企业名称")
    @TableField("ENTERPRISE_NAME_")
    private String enterpriseName;

    @ApiModelProperty(value = "企业编码")
    @TableField("ENTERPRISE_CODE_")
    private String enterpriseCode;

    @ApiModelProperty(value = "统一信用代码")
    @TableField("CREDIT_CODE_")
    private String creditCode;

    @ApiModelProperty(value = "证件编号")
    @TableField("CREDIT_NUMBER_")
    private String creditNumber;

    @ApiModelProperty(value = "公司简称")
    @TableField("ENTERPRISE_SHORT_NAME_")
    private String enterpriseShortName;

    @ApiModelProperty(value = "注册资本(万元)")
    @TableField("REGISTERED_AMOUNT_")
    private String registeredAmount;

    @ApiModelProperty(value = "注册资金类型（1.人民币，2.美元，3.英镑，4.日元，5.港币）")
    @TableField("REGISTERED_CAPITAL_TYPE_")
    private Integer registeredCapitalType;

    @ApiModelProperty(value = "类型")
    @TableField("ENTERPRISE_TYPE_")
    private String enterpriseType;

    @ApiModelProperty(value = "成立日期")
    @TableField("ESTABLISHMENT_TIME_")
    private LocalDate establishmentTime;

    @ApiModelProperty(value = "法定代表人 ")
    @TableField("LEGAL_REPRESENTATIVE_")
    private String legalRepresentative;

    @ApiModelProperty(value = "时间期限(0.限时 1.长期)")
    @TableField("TIME_LIMIT_")
    private Integer timeLimit;

    @ApiModelProperty(value = "营业期限开始时间")
    @TableField("SRART_BUSINESS_TERM_")
    private LocalDate srartBusinessTerm;

    @ApiModelProperty(value = "营业期限结束时间")
    @TableField("END_BUSINESS_TERM_")
    private LocalDate endBusinessTerm;

    @ApiModelProperty(value = "地址")
    @TableField("ADDRESS_")
    private String address;

    @ApiModelProperty(value = "经营范围")
    @TableField("BUSINESS_SCOPE_")
    private String businessScope;

    @ApiModelProperty(value = "注册机构")
    @TableField("REGISTRATION_AUTHORITY_")
    private String registrationAuthority;

    @ApiModelProperty(value = "企业网址")
    @TableField("ENTERPRISE_WEBSITE_")
    private String enterpriseWebsite;

    @ApiModelProperty(value = "附件集")
    @TableField(exist = false)
    List<DefaultFile> files;
}
