package com.artfess.gyl.base.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 通用附件表
 *
 * @author 管理员
 * @since 2025-12-10
 */
@Data
@TableName("biz_accessory")
@ApiModel(value="BizAccessory对象", description="通用附件表")
public class BizAccessory extends BizDelModel<BizAccessory> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "附件类型（使用字典，1：图片，2：文档，3：压缩文件，4：视频）")
    @TableField("TYPE_")
    private Integer type;

    @ApiModelProperty(value = "对应资源Id")
    @TableField("SOURCE_ID_")
    private String sourceId;

    @ApiModelProperty(value = "附件名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "访问下载路径")
    @TableField("URL_")
    private String url;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "后缀")
    @TableField("SUFFIX_")
    private String suffix;

    @ApiModelProperty(value = "创建人ID")
    @TableField("CREATE_BY_")
    private String createBy;

    @ApiModelProperty(value = "创建人姓名")
    @TableField("CREATE_NAME_")
    private String createName;

    @ApiModelProperty(value = "创建人组织名称")
    @TableField("CREATE_ORG_NAME_")
    private String createOrgName;

    @ApiModelProperty(value = "创建人单位ID")
    @TableField("CREATE_DEPT_ID_")
    private String createDeptId;

    @ApiModelProperty(value = "创建人单位名称")
    @TableField("CREATE_DEPT_NAME_")
    private String createDeptName;

    @ApiModelProperty(value = "创建人组织ID")
    @TableField("CREATE_ORG_ID_")
    private String createOrgId;

    @ApiModelProperty(value = "创建时间")
    @TableField("CREATE_TIME_")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "更新人ID")
    @TableField("UPDATE_BY_")
    private String updateBy;

    @ApiModelProperty(value = "更新人姓名")
    @TableField("UPDATE_NAME_")
    private String updateName;

    @ApiModelProperty(value = "更新人单位名称")
    @TableField("UPDATE_DEPT_NAME_")
    private String updateDeptName;

    @ApiModelProperty(value = "更新人单位ID")
    @TableField("UPDATE_DEPT_ID_")
    private String updateDeptId;

    @ApiModelProperty(value = "更新人组织ID")
    @TableField("UPDATE_ORG_ID_")
    private String updateOrgId;

    @ApiModelProperty(value = "更新人组织名称")
    @TableField("UPDATE_ORG_NAME_")
    private String updateOrgName;

    @ApiModelProperty(value = "更新时间")
    @TableField("UPDATE_TIME_")
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "最后更新时间戳")
    @TableField("LAST_TIME_")
    private Long lastTime;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;

    @ApiModelProperty(value = "分组标识")
    @TableField("GROUP_")
    private String group;

    @ApiModelProperty(value = "文件大小")
    @TableField("FILE_SIZE_")
    private String fileSize;

    @ApiModelProperty(value = "投标文件类型（1.电子投标，2.线下投标），默认2")
    @TableField("BID_TYPE_")
    private Integer bidType;

    @ApiModelProperty(value = "签署状态（1.未签署，2.签署中，3.已完成）")
    @TableField("BID_SIGN_STATUS_")
    private Integer bidSignStatus;

    @ApiModelProperty(value = "签署投标文件URL")
    @TableField("BID_CONTRACT_URL_")
    private String bidContractUrl;

    @ApiModelProperty(value = "签署投标文件ID（电子合同系统）")
    @TableField("BID_CONTRACT_ID_")
    private String bidContractId;

}
