package com.artfess.gyl.base.manager.impl;

import com.artfess.base.util.StringUtil;
import com.artfess.gyl.base.model.BizSupplierAssessmentIndicatorType;
import com.artfess.gyl.base.dao.BizSupplierAssessmentIndicatorTypeDao;
import com.artfess.gyl.base.manager.BizSupplierAssessmentIndicatorTypeManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * 供应商绩效考核分类表 服务实现类
 *
 * @author 系统管理员
 * @since 2025-11-07
 */
@Service
public class BizSupplierAssessmentIndicatorTypeManagerImpl extends BaseManagerImpl<BizSupplierAssessmentIndicatorTypeDao, BizSupplierAssessmentIndicatorType> implements BizSupplierAssessmentIndicatorTypeManager {

    @Resource
    private SysIdentityManager sysIdentityManager;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean save(BizSupplierAssessmentIndicatorType entity){
        String no = sysIdentityManager.nextId("gysjxkhflbm");
        entity.setCode(no);
        if(StringUtil.isEmpty(entity.getStatus())){
            entity.setStatus("1");
        }
        return super.save(entity);
    }

    @Override
    public boolean updateStatusById(String id, String status) {
        LambdaUpdateWrapper<BizSupplierAssessmentIndicatorType> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(BizSupplierAssessmentIndicatorType::getId, id);
        wrapper.set(BizSupplierAssessmentIndicatorType::getStatus, status);
        return this.update(wrapper);
    }

}
