package com.artfess.gyl.base.manager.impl;

import cn.hutool.json.JSON;
import cn.hutool.json.JSONUtil;
import com.artfess.base.constants.WebsocketConst;
import com.artfess.base.exception.BaseException;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.IPUtils;
import com.artfess.gyl.base.model.BizContractCallback;
import com.artfess.gyl.base.dao.BizContractCallbackDao;
import com.artfess.gyl.base.manager.BizContractCallbackManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.baomidou.mybatisplus.annotation.SqlParser;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;

/**
 * 电子合同回调记录表 服务实现类
 *
 * @author 管理员
 * @since 2025-12-10
 */
@Service
public class BizContractCallbackManagerImpl extends BaseManagerImpl<BizContractCallbackDao, BizContractCallback> implements BizContractCallbackManager {

    @Override
    @Transactional
    @SqlParser(filter=true)
    public void signingCompleted(String contractId, String sn, String status,
                                 String type, String contact,
                                 String operatorName, String operatorMobile,
                                 String operatorNumber,String receiverNumber,
                                 String accessKey, String secretKey,
                                 String dataSourceType) {
//        HttpServletRequest request = HttpUtil.getRequest();

        BizContractCallback contractCallBack = new BizContractCallback(contractId,sn,status,
                type,contact,operatorName,operatorMobile,operatorNumber,receiverNumber,accessKey,
                secretKey,2);

//        SsoSystem ssoSystem = ssoSystemManager.getEntityByAkAndSk(accessKey, secretKey);
//
//        if(BeanUtils.isEmpty(ssoSystem)){
//            super.save(contractCallBack);
//            throw new BaseException("用户不存在或授权过期，请联系管理员");
//        }
//        if(BeanUtils.isNotEmpty(ssoSystem.getIsIpAstrict()) && ssoSystem.getIsIpAstrict()==1){
//            if(BeanUtils.isNotEmpty(ssoSystem.getIpAddress()) && ssoSystem.getIpAddress().equals(IPUtils.getIpAddr(request))){
//                super.save(contractCallBack);
//                throw new BaseException("用户不存在或授权过期，请联系管理员");
//            }
//        }

        //根据参数的第三方合同id修改合同状态
        if(status.equalsIgnoreCase("COMPLETE")){
            if(dataSourceType.equals("1")){
                //合同
                baseMapper.updateContrStatusByThreeContrId(contractId,"3");
            }
        }
        contractCallBack.setResult(1);
        super.save(contractCallBack);
    }

}
