package com.artfess.gyl.base.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.gyl.base.model.BizSupplierGradingConfiguration;
import com.artfess.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import com.artfess.gyl.base.model.BizSupplierQualificationDatabase;
import com.artfess.gyl.base.manager.BizSupplierQualificationDatabaseManager;

/**
 * 供应商资质库表，（供应商修改资质库文件提交后，是新添加一条数据，版本加1），新建的资质版本默认为1，这样就可以和供应商的 前端控制器
 *
 * @author 系统管理员
 * @since 2025-11-08
 */
@RestController
@RequestMapping("/bizSupplierQualificationDatabase/v1/")
@Api(tags = "供应商资质库")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_GYL})
public class BizSupplierQualificationDatabaseController extends BaseController<BizSupplierQualificationDatabaseManager, BizSupplierQualificationDatabase> {

    @Override
    @PostMapping(value = "/query", produces = {"application/json; charset=utf-8"})
    @ApiOperation("分页查询结果")
    public PageList<BizSupplierQualificationDatabase> query(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizSupplierQualificationDatabase> queryFilter) {
        queryFilter.addFilter("qd.IS_DELE_","0", QueryOP.EQUAL);
        return baseService.queryByPage(queryFilter);
    }


    @PostMapping(value = "/queryByUser", produces = {"application/json; charset=utf-8"})
    @ApiOperation("分页查询结果")
    public PageList<BizSupplierQualificationDatabase> queryByUser(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizSupplierQualificationDatabase> queryFilter) {
        queryFilter.addFilter("qd.IS_DELE_","0", QueryOP.EQUAL);
        queryFilter.addFilter("qd.ENTERPRISE_ID_", ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        return baseService.queryByPage(queryFilter);
    }

    @PostMapping(value = "/queryByQuaSupplier", produces = {"application/json; charset=utf-8"})
    @ApiOperation("企业查询合格供应商资质")
    public PageList<BizSupplierQualificationDatabase> queryByQuaSupplier(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizSupplierQualificationDatabase> queryFilter) {
        queryFilter.addFilter("qd.IS_DELE_","0", QueryOP.EQUAL);
        queryFilter.addFilter("sn.ENTERPRISE_ID_", ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        queryFilter.addFilter("sn.TYPE_", 1, QueryOP.EQUAL);
        return baseService.queryByQuaSupplier(queryFilter);
    }

}
