package com.artfess.gyl.base.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.gyl.base.model.BizSupplierMaterialCategory;
import com.artfess.gyl.base.manager.BizSupplierMaterialCategoryManager;

/**
 * 物资分类表 前端控制器
 *
 * @author 系统管理员
 * @since 2025-11-06
 */
@RestController
@RequestMapping("/bizSupplierMaterialCategory/v1/")
@Api(tags = "物资基础数据分类管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_GYL})
public class BizSupplierMaterialCategoryController extends BaseController<BizSupplierMaterialCategoryManager, BizSupplierMaterialCategory> {

    @PostMapping("/updateByStatus")
    @ApiOperation(value = "根据id修改状态")
    public CommonResult<String> updateStatus(@RequestParam("id")String id,@RequestParam("status")String status) {
        boolean res = baseService.updateStatusById(id, status);
        return new CommonResult(res?"修改成功":"修改失败");
    }

}
