/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.base.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.StringUtil;
import com.artfess.gyl.base.dao.BizSupplierCategoryConfigurationDao;
import com.artfess.gyl.base.manager.BizSupplierCategoryConfigurationManager;
import com.artfess.gyl.base.manager.BizSupplierCategorySupplyScopeManager;
import com.artfess.gyl.base.model.BizSupplierCategoryConfiguration;
import com.artfess.gyl.base.model.BizSupplierCategorySupplyScope;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizSupplierCategoryConfigurationManagerImpl
extends BaseManagerImpl<BizSupplierCategoryConfigurationDao, BizSupplierCategoryConfiguration>
implements BizSupplierCategoryConfigurationManager {
    @Resource
    private SysIdentityManager sysIdentityManager;
    @Resource
    private BizSupplierCategorySupplyScopeManager scopeManager;

    @Override
    public boolean updateStatusById(String id, String status) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(BizSupplierCategoryConfiguration::getId, (Object)id);
        wrapper.set(BizSupplierCategoryConfiguration::getStatus, (Object)status);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public BizSupplierCategoryConfiguration getByCategoryId(String categoryId) {
        return ((BizSupplierCategoryConfigurationDao)this.baseMapper).getByCategoryId(categoryId);
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean save(BizSupplierCategoryConfiguration entity) {
        String no = this.sysIdentityManager.nextId("gysflbm");
        entity.setCode(no);
        if (StringUtil.isEmpty((String)entity.getStatus())) {
            entity.setStatus("1");
        }
        if (!super.save((Object)entity)) {
            return false;
        }
        List<BizSupplierCategorySupplyScope> scopes = entity.getScopes();
        String id = entity.getId();
        if (scopes != null && !scopes.isEmpty()) {
            scopes.forEach(s -> {
                s.setId(null);
                s.setSupplierCategoryConfigurationId(id);
            });
            if (!this.scopeManager.saveBatch(scopes)) {
                throw new ApplicationException("\u5206\u7c7b\u5173\u8054\u5931\u8d25");
            }
            return true;
        }
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean updateById(BizSupplierCategoryConfiguration entity) {
        boolean update = super.updateById((Object)entity);
        if (!update) {
            return false;
        }
        List<BizSupplierCategorySupplyScope> scopes = entity.getScopes();
        String id = entity.getId();
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizSupplierCategorySupplyScope::getSupplierCategoryConfigurationId, (Object)id);
        this.scopeManager.remove((Wrapper)wrapper);
        if (scopes != null && !scopes.isEmpty()) {
            scopes.forEach(s -> {
                s.setId(null);
                s.setSupplierCategoryConfigurationId(id);
            });
            if (!this.scopeManager.saveBatch(scopes)) {
                throw new ApplicationException("\u5206\u7c7b\u5173\u8054\u5931\u8d25");
            }
        }
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean removeByIds(Collection<? extends Serializable> idList) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(BizSupplierCategorySupplyScope::getSupplierMaterialCategoryId, idList);
        this.scopeManager.remove((Wrapper)wrapper);
        return super.removeByIds(idList);
    }

    public BizSupplierCategoryConfiguration getById(Serializable id) {
        BizSupplierCategoryConfiguration entity = (BizSupplierCategoryConfiguration)((Object)super.getById(id));
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizSupplierCategorySupplyScope::getSupplierCategoryConfigurationId, (Object)entity.getId());
        List scopes = this.scopeManager.list((Wrapper)wrapper);
        if (!CollectionUtils.isEmpty((Collection)scopes)) {
            entity.setScopes(scopes);
        }
        return entity;
    }
}

