/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.openApi.manager.impl;

import com.alibaba.excel.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.feign.UCFeignService;
import com.artfess.bpm.exception.BusinessException;
import com.artfess.gyl.base.manager.BizEnterpriseBusinessLicenseManager;
import com.artfess.gyl.base.manager.BizEnterprisePersonnelManager;
import com.artfess.gyl.base.model.BizEnterpriseBusinessLicense;
import com.artfess.gyl.base.model.BizEnterprisePersonnel;
import com.artfess.gyl.openApi.manager.ApiManager;
import com.artfess.gyl.openApi.vo.PersonnelVO;
import com.artfess.gyl.supplierApply3.manager.BizSupplierEnterpriseRegisterInformationManager;
import com.artfess.gyl.supplierApply3.model.BizSupplierEnterpriseRegisterInformation;
import com.artfess.gyl.thirdParty.manager.BizEnterpriseManager;
import com.artfess.gyl.thirdParty.model.BizEnterprise;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApiManagerImpl
implements ApiManager {
    @Resource
    UCFeignService ucFeignService;
    @Resource
    private BizEnterpriseBusinessLicenseManager licenseManager;
    @Resource
    private BizSupplierEnterpriseRegisterInformationManager registerInformationManager;
    @Resource
    private BizEnterprisePersonnelManager personnelManager;
    @Resource
    private BizEnterpriseManager bizEnterpriseManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveOrUpdateEnterprise(JSONObject json) {
        JSONObject enterprise;
        try {
            enterprise = this.ucFeignService.setEnterprise(json);
        }
        catch (Exception e) {
            return false;
        }
        if (enterprise == null || StringUtils.isBlank((CharSequence)enterprise.getString("orgId"))) {
            return false;
        }
        String orgId = enterprise.getString("orgId");
        boolean licenseExists = ((LambdaQueryChainWrapper)this.licenseManager.lambdaQuery().eq(BizEnterpriseBusinessLicense::getEnterpriseId, (Object)orgId)).count() > 0;
        boolean registerExists = ((LambdaQueryChainWrapper)this.registerInformationManager.lambdaQuery().eq(BizSupplierEnterpriseRegisterInformation::getEnterpriseId, (Object)orgId)).count() > 0;
        try {
            String companyRegdate;
            if (!licenseExists) {
                BizEnterpriseBusinessLicense businessLicense = new BizEnterpriseBusinessLicense();
                businessLicense.setEnterpriseId(orgId);
                businessLicense.setEnterpriseName(enterprise.getString("companyName"));
                businessLicense.setEnterpriseCode(enterprise.getString("companyCode"));
                businessLicense.setCreditCode(enterprise.getString("creditCode"));
                businessLicense.setRegisteredAmount(enterprise.getString("registeredCapital"));
                businessLicense.setRegisteredCapitalType(enterprise.getInteger("registeredCapitalType"));
                businessLicense.setLegalRepresentative(enterprise.getString("companyEbe"));
                businessLicense.setBusinessScope(enterprise.getString("businessScope"));
                companyRegdate = enterprise.getString("companyRegdate");
                if (StringUtils.isNotBlank((CharSequence)companyRegdate)) {
                    businessLicense.setSrartBusinessTerm(LocalDate.parse(companyRegdate));
                }
                this.licenseManager.save((Object)businessLicense);
            }
            if (!registerExists) {
                BizSupplierEnterpriseRegisterInformation registerInformation = new BizSupplierEnterpriseRegisterInformation();
                registerInformation.setEnterpriseId(orgId);
                registerInformation.setEnterpriseName(enterprise.getString("companyName"));
                registerInformation.setEnterpriseCode(enterprise.getString("companyCode"));
                registerInformation.setApplyDate(LocalDate.now());
                registerInformation.setCreditCode(enterprise.getString("creditCode"));
                registerInformation.setCompanyOrgcode(enterprise.getString("registeredCapital"));
                registerInformation.setCompanyEbe(enterprise.getString("companyEbe"));
                companyRegdate = enterprise.getString("companyRegdate");
                if (StringUtils.isNotBlank((CharSequence)companyRegdate)) {
                    registerInformation.setCompanyRegdate(LocalDate.parse(companyRegdate));
                }
                registerInformation.setCompanyRegdateEnd(enterprise.getString("companyRegdateEnd"));
                registerInformation.setProvince(enterprise.getString("province"));
                registerInformation.setCity(enterprise.getString("city"));
                registerInformation.setCounty(enterprise.getString("county"));
                registerInformation.setCompanyAddr(enterprise.getString("companyAddr"));
                registerInformation.setCompanyContact(enterprise.getString("companyContact"));
                registerInformation.setContactTel(enterprise.getString("contactTel"));
                registerInformation.setMail(enterprise.getString("mail"));
                registerInformation.setPostCode(enterprise.getString("postCode"));
                registerInformation.setOwnerType(enterprise.getString("ownerType"));
                registerInformation.setRegisteredCapital(enterprise.getDouble("registeredCapital"));
                registerInformation.setRegisteredCapitalType(enterprise.getInteger("registeredCapitalType"));
                registerInformation.setInterbank(enterprise.getString("interbank"));
                registerInformation.setBank(enterprise.getString("bank"));
                registerInformation.setOpeningBank(enterprise.getString("openingBank"));
                registerInformation.setMailingAddress(enterprise.getString("mailingAddress"));
                registerInformation.setTaxpayerType(enterprise.getInteger("taxpayerType"));
                registerInformation.setHistoryCompanyCode(enterprise.getString("historyCompanyCode"));
                registerInformation.setRegisType(enterprise.getInteger("regisType"));
                registerInformation.setIndustryCode(enterprise.getString("industryCode"));
                registerInformation.setIndustryName(enterprise.getString("industryName"));
                registerInformation.setEnterpriseShortName(enterprise.getString("enterpriseShortName"));
                registerInformation.setBusinessScope(enterprise.getString("businessScope"));
                this.registerInformationManager.save((Object)registerInformation);
            }
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException("\u4fdd\u5b58\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25", e);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveOrUpdateUser(JSONObject json) {
        JSONArray userDataArray = this.fetchUserDataFromRemote(json);
        if (userDataArray == null || userDataArray.isEmpty()) {
            return false;
        }
        try {
            List<PersonnelVO> personnelList = this.parsePersonnelData(userDataArray);
            if (CollectionUtils.isEmpty(personnelList)) {
                return false;
            }
            Map<String, BizEnterprise> enterpriseMap = this.getEnterpriseMapByCodes(personnelList);
            if (enterpriseMap.isEmpty()) {
                return false;
            }
            List<BizEnterprisePersonnel> personnelEntities = this.buildPersonnelEntities(personnelList, enterpriseMap);
            if (CollectionUtils.isNotEmpty(personnelEntities)) {
                this.personnelManager.saveBatch(personnelEntities);
            }
            return true;
        }
        catch (Exception e) {
            throw new BusinessException("\u4fdd\u5b58\u4f01\u4e1a\u4eba\u5458\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    private JSONArray fetchUserDataFromRemote(JSONObject json) {
        try {
            return this.ucFeignService.setUser(json);
        }
        catch (Exception e) {
            return null;
        }
    }

    private List<PersonnelVO> parsePersonnelData(JSONArray jsonArray) {
        try {
            return JSON.parseArray((String)jsonArray.toJSONString(), PersonnelVO.class);
        }
        catch (JSONException e) {
            throw new BusinessException("\u7528\u6237\u6570\u636e\u683c\u5f0f\u9519\u8bef");
        }
    }

    private Map<String, BizEnterprise> getEnterpriseMapByCodes(List<PersonnelVO> personnelList) {
        Set orgCodes = personnelList.stream().map(PersonnelVO::getOrgCode).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(orgCodes)) {
            return Collections.emptyMap();
        }
        List enterprises = this.bizEnterpriseManager.list((Wrapper)new LambdaQueryWrapper().in(BizEnterprise::getCompanyCode, orgCodes));
        return enterprises.stream().collect(Collectors.toMap(BizEnterprise::getCompanyCode, Function.identity(), (existing, replacement) -> existing));
    }

    private List<BizEnterprisePersonnel> buildPersonnelEntities(List<PersonnelVO> personnelList, Map<String, BizEnterprise> enterpriseMap) {
        return personnelList.stream().filter(vo -> enterpriseMap.containsKey(vo.getOrgCode())).map(vo -> this.convertToPersonnelEntity((PersonnelVO)vo, (BizEnterprise)((Object)((Object)enterpriseMap.get(vo.getOrgCode()))))).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private BizEnterprisePersonnel convertToPersonnelEntity(PersonnelVO vo, BizEnterprise enterprise) {
        try {
            BizEnterprisePersonnel personnel = new BizEnterprisePersonnel();
            personnel.setEnterpriseId(enterprise.getId());
            personnel.setEnterpriseName(enterprise.getCompanyName());
            personnel.setEnterpriseCode(enterprise.getCompanyCode());
            personnel.setAccount(vo.getAccount());
            personnel.setFullname(vo.getFullName());
            personnel.setSex(vo.getSex());
            personnel.setMobile(vo.getMobile());
            return personnel;
        }
        catch (Exception e) {
            return null;
        }
    }
}

