/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.supplierApply3.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.gyl.supplierApply3.dao.BizSupplierProductionProcessPerformance3Dao;
import com.artfess.gyl.supplierApply3.manager.BizSupplierProductionProcessFlow3Manager;
import com.artfess.gyl.supplierApply3.manager.BizSupplierProductionProcessPerformance3Manager;
import com.artfess.gyl.supplierApply3.model.BizSupplierProductionProcessFlow3;
import com.artfess.gyl.supplierApply3.model.BizSupplierProductionProcessPerformance3;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizSupplierProductionProcessPerformance3ManagerImpl
extends BaseManagerImpl<BizSupplierProductionProcessPerformance3Dao, BizSupplierProductionProcessPerformance3>
implements BizSupplierProductionProcessPerformance3Manager {
    @Resource
    private BizSupplierProductionProcessFlow3Manager flow3Manager;
    @Resource
    private FileManager fileManager;

    @Override
    public boolean fillModel(BizSupplierProductionProcessPerformance3 performance3, String id, Long version) {
        if (performance3 == null) {
            return true;
        }
        performance3.setId(null);
        performance3.setSupplierEnterpriseId(id);
        performance3.setVersion(version);
        if (!super.save((Object)performance3)) {
            throw new ApplicationException("\u751f\u4ea7\u5236\u9020\u8fc7\u7a0b\u7ee9\u6548\u4fdd\u5b58\u5931\u8d25");
        }
        List<DefaultFile> files = performance3.getFiles();
        if (files != null && files.size() > 0) {
            List fileIds = files.stream().map(DefaultFile::getId).collect(Collectors.toList());
            this.fileManager.removeFileByBizId(performance3.getId(), fileIds);
            this.fileManager.updateFileBizIdByIds(fileIds, performance3.getId());
        } else {
            this.fileManager.removeFileByBizId(performance3.getId(), null);
        }
        if (performance3.getFlow() != null && !performance3.getFlow().isEmpty()) {
            List flow3List = performance3.getFlow().stream().peek(flow3 -> {
                flow3.setSupplierProductionProcessPerformanceId(performance3.getId());
                flow3.setVersion(version);
                flow3.setId(null);
            }).collect(Collectors.toList());
            this.flow3Manager.saveBatch(flow3List);
        }
        return true;
    }

    @Override
    public BizSupplierProductionProcessPerformance3 getModel(String id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BizSupplierProductionProcessPerformance3::getSupplierEnterpriseId, (Object)id);
        BizSupplierProductionProcessPerformance3 performance3 = (BizSupplierProductionProcessPerformance3)((Object)this.getOne((Wrapper)queryWrapper));
        if (performance3 == null) {
            return null;
        }
        List files = this.fileManager.queryFileByBizId(performance3.getId());
        if (files != null && files.size() > 0) {
            performance3.setFiles(files);
        }
        LambdaQueryWrapper flowQuery = new LambdaQueryWrapper();
        flowQuery.eq(BizSupplierProductionProcessFlow3::getSupplierProductionProcessPerformanceId, (Object)performance3.getId());
        List flow = this.flow3Manager.list((Wrapper)flowQuery);
        performance3.setFlow(flow);
        return performance3;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteModelById(String id) {
        try {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizSupplierProductionProcessPerformance3::getSupplierEnterpriseId, (Object)id);
            BizSupplierProductionProcessPerformance3 performance3 = (BizSupplierProductionProcessPerformance3)((Object)super.getOne((Wrapper)queryWrapper));
            if (performance3 == null) {
                return true;
            }
            String mainId = performance3.getId();
            LambdaQueryWrapper flowWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizSupplierProductionProcessFlow3::getSupplierProductionProcessPerformanceId, (Object)mainId);
            this.flow3Manager.remove((Wrapper)flowWrapper);
            boolean removeMain = super.removeById((Serializable)((Object)mainId));
            if (!removeMain) {
                throw new ApplicationException("\u751f\u4ea7\u5236\u9020\u8fc7\u7a0b\u7ee9\u6548\u4e3b\u8868\u5220\u9664\u5931\u8d25");
            }
            return true;
        }
        catch (Exception e) {
            throw new ApplicationException("\u5220\u9664\u751f\u4ea7\u5236\u9020\u8fc7\u7a0b\u7ee9\u6548\u5931\u8d25: " + e.getMessage());
        }
    }
}

