/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.thirdParty.manager.impl;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.gyl.base.manager.BizSupplierMaterialCategoryManager;
import com.artfess.gyl.base.model.BizSupplierMaterialCategory;
import com.artfess.gyl.thirdParty.dao.BizCategoryDao;
import com.artfess.gyl.thirdParty.manager.BizCategoryManager;
import com.artfess.gyl.thirdParty.model.BizCategory;
import com.artfess.gyl.thirdParty.vo.CategoryNumVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class BizCategoryManagerImpl
extends BaseManagerImpl<BizCategoryDao, BizCategory>
implements BizCategoryManager {
    @Resource
    private BizSupplierMaterialCategoryManager categoryManager;

    @Override
    public List<BizCategory> tree(QueryFilter<BizCategory> queryFilter) {
        IPage<BizCategory> iPage = ((BizCategoryDao)this.baseMapper).queryByPage((IPage<BizCategory>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizCategory>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = iPage.getRecords();
        if (records != null && records.size() > 0) {
            List<BizCategory> collect = records.stream().filter(category -> category.getCatPid().equals("0")).collect(Collectors.toList());
            for (BizCategory c : collect) {
                c.setChildren(this.getchildren(c, records));
            }
            return collect;
        }
        return new ArrayList<BizCategory>();
    }

    @Override
    public List<CategoryNumVo> countByType(QueryFilter<BizCategory> queryFilter) {
        ArrayList<CategoryNumVo> dataList = new ArrayList<CategoryNumVo>();
        List categories = this.categoryManager.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizSupplierMaterialCategory::getStatus, (Object)1)).orderByAsc((Object[])new SFunction[]{BizSupplierMaterialCategory::getSeq, AutoFillModel::getCreateTime}));
        IPage<BizCategory> iPage = ((BizCategoryDao)this.baseMapper).queryByPage((IPage<BizCategory>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizCategory>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = iPage.getRecords();
        dataList.add(new CategoryNumVo("\u603b\u6570", records.size()));
        List fiterList = records.stream().filter(category -> category.getCategoryId() != null).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(fiterList) && !CollectionUtils.isEmpty((Collection)categories)) {
            Map<String, String> categoryMap = categories.stream().collect(Collectors.toMap(BizSupplierMaterialCategory::getId, BizSupplierMaterialCategory::getName));
            HashMap<String, Integer> countMap = new HashMap<String, Integer>();
            for (BizCategory item : fiterList) {
                for (String categoryId2 : categoryMap.keySet()) {
                    if (item.getCategoryId().contains(categoryId2)) {
                        countMap.put(categoryId2, countMap.getOrDefault(categoryId2, 0) + 1);
                        continue;
                    }
                    countMap.put(categoryId2, 0);
                }
            }
            countMap.forEach((categoryId, count) -> dataList.add(new CategoryNumVo((String)categoryId, (String)categoryMap.get(categoryId), (int)count)));
        }
        return dataList;
    }

    private List<BizCategory> getchildren(BizCategory root, List<BizCategory> list) {
        List<BizCategory> children = list.stream().filter(category -> category.getCatPid().equals(root.getId())).collect(Collectors.toList());
        if (BeanUtils.isNotEmpty(children) && children.size() > 0) {
            for (BizCategory c : children) {
                c.setChildren(this.getchildren(c, list));
            }
        }
        return children;
    }
}

