/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.base.manager.impl;

import com.artfess.base.conf.AdminConfig;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.gyl.base.dao.BizContractCallbackDao;
import com.artfess.gyl.base.manager.BizContractCallbackManager;
import com.artfess.gyl.base.manager.BizSupplierGradingConfigurationManager;
import com.artfess.gyl.base.model.BizContractCallback;
import com.artfess.gyl.base.model.BizSupplierGradingConfiguration;
import com.artfess.gyl.supplierApply.manager.BizSupplierEnterpriseManager;
import com.artfess.gyl.supplierApply.model.BizSupplierEnterprise;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.annotation.SqlParser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.CategoryService;
import net.qiyuesuo.sdk.api.ContractService;
import net.qiyuesuo.sdk.bean.company.TenantType;
import net.qiyuesuo.sdk.bean.contract.CreateContractRequest;
import net.qiyuesuo.sdk.bean.contract.ViewUrlRequest;
import net.qiyuesuo.sdk.bean.document.CreateDocumentRequest;
import net.qiyuesuo.sdk.bean.document.CreateDocumentResult;
import net.qiyuesuo.sdk.bean.sign.Signatory;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.common.http.FileItem;
import net.qiyuesuo.sdk.common.http.StreamFile;
import net.qiyuesuo.sdk.common.utils.TimeUtils;
import net.qiyuesuo.sdk.impl.CategoryServiceImpl;
import net.qiyuesuo.sdk.impl.ContractServiceImpl;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizContractCallbackManagerImpl
extends BaseManagerImpl<BizContractCallbackDao, BizContractCallback>
implements BizContractCallbackManager {
    private static final Logger log = LoggerFactory.getLogger(BizContractCallbackManagerImpl.class);
    @Value(value="${contractSys.serverUrl}")
    private String serverUrl;
    @Value(value="${contractSys.accessKey}")
    private String accessKey;
    @Value(value="${contractSys.accessSecret}")
    private String accessSecret;
    @Value(value="${contractSys.onePartyStreamId}")
    private Long bidDocSignStreamId;
    private ContractService contractService;
    private CategoryService categoryService;
    @Resource
    private FileManager fileManager;
    @Resource
    private BizSupplierEnterpriseManager supplierEnterpriseManager;
    @Resource
    private BizSupplierGradingConfigurationManager supplierGradingConfigurationManager;
    @Resource(name="bmpExecutorService")
    private ExecutorService executorService;

    @Override
    public String sendDocSign(String fileId, String contractUserMobile, String contractUserName) {
        DefaultFile file = (DefaultFile)this.fileManager.getById((Serializable)((Object)fileId));
        if (ObjectUtils.isEmpty((Object)file)) {
            throw new BaseException("\u672a\u627e\u5230\u6587\u4ef6,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        }
        if ("1".equals(file.getProp1())) {
            throw new BaseException("\u53d1\u8d77\u5931\u8d25\uff1a\u672a\u7b7e\u7f72\u72b6\u6001\u4e0b\u624d\u53ef\u4ee5\u53d1\u8d77\u7b7e\u7f72");
        }
        String viewUrl = null;
        try {
            this.init();
            Long contrStreamId = this.bidDocSignStreamId;
            ArrayList<Long> documentIdList = new ArrayList<Long>();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.fileManager.downloadFile(fileId, (OutputStream)out);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(out.toByteArray());
            String contrTitle = BeanUtils.isNotEmpty((Object)file.getFileName()) ? file.getFileName().substring(0, file.getFileName().lastIndexOf(".")) : ContextUtil.getCurrentOrgName() + "\u6295\u6807\u6587\u4ef6";
            CreateDocumentRequest request = new CreateDocumentRequest();
            request.setFile((FileItem)new StreamFile((InputStream)inputStream));
            request.setFileType(file.getExtensionName());
            request.setTitle(contrTitle);
            CreateDocumentResult result = this.contractService.createByFile(request);
            Long documentId = result.getDocumentId();
            documentIdList.add(documentId);
            HashMap params = new HashMap();
            CreateContractRequest createContractRequest = new CreateContractRequest();
            createContractRequest.setEndTime(TimeUtils.format((Date)TimeUtils.after((Date)new Date(), (int)7), (String)"yyyy-MM-dd HH:mm:ss"));
            createContractRequest.setSend(Boolean.valueOf(true));
            createContractRequest.setMustSign(Boolean.valueOf(true));
            createContractRequest.setExtraSign(Boolean.valueOf(true));
            createContractRequest.setAutoCreateCounterSign(Boolean.valueOf(true));
            createContractRequest.setSignAll("RECEIVER");
            createContractRequest.setMsgCode(Integer.valueOf(0));
            if (documentIdList.size() > 0) {
                createContractRequest.setDocuments(documentIdList);
            }
            createContractRequest.setSubject(contrTitle);
            createContractRequest.setTenantName(AdminConfig.getAdminCompanyName());
            ArrayList<Signatory> signatories = new ArrayList<Signatory>();
            Signatory signatory1 = new Signatory();
            signatory1.setTenantType(TenantType.COMPANY);
            signatory1.setTenantName(ContextUtil.getCurrentOrgName());
            signatory1.setSerialNo(Integer.valueOf(1));
            signatory1.setContact(contractUserMobile);
            signatory1.setReceiverName(contractUserName);
            signatories.add(signatory1);
            createContractRequest.setSignatories(signatories);
            createContractRequest.setCategoryId(contrStreamId);
            createContractRequest.setDocumentParams(params);
            Long contractId = null;
            try {
                contractId = this.contractService.createContractByCategory(createContractRequest);
            }
            catch (PrivateAppException e) {
                log.info("{}\u53d1\u8d77\u7b7e\u7f72\u5931\u8d25:{}", (Object)LocalDateTime.now(), (Object)e.getMessage());
                throw new BaseException("\u53d1\u8d77\u7b7e\u7f72\u5931\u8d25:" + e.getMessage());
            }
            log.info("\u521b\u5efa\u5408\u540c\u6210\u529f:{}", (Object)contractId);
            file.setProp1("2");
            file.setProp2(String.valueOf(contractId));
            ViewUrlRequest viewRequest = new ViewUrlRequest();
            viewRequest.setContractId(contractId);
            viewRequest.setPageType(ViewUrlRequest.PageType.CONTENT);
            try {
                viewUrl = this.contractService.viewUrl(viewRequest);
            }
            catch (PrivateAppException e) {
                log.info("\u5408\u540c\u67e5\u770b\u94fe\u63a5:{}", (Object)viewUrl);
                throw new BaseException("\u7b7e\u7f72\u9884\u89c8\u5931\u8d25:" + e.getMessage());
            }
            file.setProp3(viewUrl);
            this.fileManager.updateById((Object)file);
        }
        catch (Exception e) {
            throw new BaseException("\u7b7e\u7f72\u5931\u8d25:" + e.getMessage());
        }
        return viewUrl;
    }

    @Override
    @Transactional
    @SqlParser(filter=true)
    public void signingCompleted(String contractId, String sn, String status, String type, String contact, String operatorName, String operatorMobile, String operatorNumber, String receiverNumber, String accessKey, String secretKey, String dataSourceType) {
        BizContractCallback contractCallBack = new BizContractCallback(contractId, sn, status, type, contact, operatorName, operatorMobile, operatorNumber, receiverNumber, accessKey, secretKey, 2);
        if (status.equalsIgnoreCase("COMPLETE")) {
            if (dataSourceType.equals("1")) {
                ((BizContractCallbackDao)this.baseMapper).updateContrStatusByThreeContrId(contractId, "3");
                this.executorService.execute(() -> this.setSupplierStatus(contractId, "3"));
            } else {
                this.executorService.execute(() -> this.setSupplierStatus(contractId, "4"));
            }
        }
        contractCallBack.setResult(1);
        super.save((Object)contractCallBack);
    }

    public void init() {
        SDKClient sdkClient = new SDKClient(this.serverUrl, this.accessKey, this.accessSecret);
        this.contractService = new ContractServiceImpl(sdkClient);
        this.categoryService = new CategoryServiceImpl(sdkClient);
    }

    private void setSupplierStatus(String contractId, String status) {
        BizSupplierEnterprise supplierEnterprise;
        boolean isOver = true;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DefaultFile::getProp2, (Object)contractId);
        queryWrapper.eq(DefaultFile::getIsDel, (Object)"0");
        List callBackFiles = this.fileManager.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)callBackFiles)) {
            for (DefaultFile defaultFile : callBackFiles) {
                defaultFile.setProp1(status);
            }
        }
        String supplierId = ((DefaultFile)callBackFiles.get(0)).getBizId();
        String callBackFileId = ((DefaultFile)callBackFiles.get(0)).getId();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(DefaultFile::getBizId, (Object)supplierId);
        wrapper.eq(DefaultFile::getIsDel, (Object)"0");
        List files = this.fileManager.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)files)) {
            for (DefaultFile file : files) {
                if ("3".equals(file.getProp1()) || callBackFileId.equals(file.getId())) continue;
                isOver = false;
                break;
            }
        }
        if (isOver && !Objects.isNull((Object)(supplierEnterprise = (BizSupplierEnterprise)((Object)this.supplierEnterpriseManager.getById((Serializable)((Object)supplierId)))))) {
            BizSupplierGradingConfiguration supplierGradingConfiguration = (BizSupplierGradingConfiguration)((Object)this.supplierGradingConfigurationManager.getById((Serializable)((Object)"1")));
            supplierEnterprise.setCatId(supplierGradingConfiguration.getId());
            supplierEnterprise.setCatNo(supplierGradingConfiguration.getCode());
            supplierEnterprise.setCatName(supplierGradingConfiguration.getName());
            supplierEnterprise.setContractSignStatus(2);
            this.supplierEnterpriseManager.updateById((Object)supplierEnterprise);
        }
        if ("4".equals(status) && !Objects.isNull((Object)(supplierEnterprise = (BizSupplierEnterprise)((Object)this.supplierEnterpriseManager.getById((Serializable)((Object)supplierId)))))) {
            supplierEnterprise.setContractSignStatus(3);
            this.supplierEnterpriseManager.updateById((Object)supplierEnterprise);
        }
    }
}

