/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.supplierEva.manager.impl;

import com.alibaba.fastjson.JSON;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.gyl.supplierEva.dao.BizSupplierPerformanceEvaluationNotificationTemplateDao;
import com.artfess.gyl.supplierEva.dto.OrgExpandDTO;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationNotificationManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationNotificationTemplateManager;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationNotification;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationNotificationTemplate;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizSupplierPerformanceEvaluationNotificationTemplateManagerImpl
extends BaseManagerImpl<BizSupplierPerformanceEvaluationNotificationTemplateDao, BizSupplierPerformanceEvaluationNotificationTemplate>
implements BizSupplierPerformanceEvaluationNotificationTemplateManager {
    @Resource
    private BizSupplierPerformanceEvaluationNotificationManager notificationManager;

    @Transactional(rollbackFor={Exception.class})
    public boolean save(BizSupplierPerformanceEvaluationNotificationTemplate entity) {
        entity.setStatus("0");
        return super.save((Object)entity);
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean updateById(BizSupplierPerformanceEvaluationNotificationTemplate entity) {
        return super.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateStatusById(String id, String status) {
        BizSupplierPerformanceEvaluationNotificationTemplate entity = (BizSupplierPerformanceEvaluationNotificationTemplate)super.get((Serializable)((Object)id));
        if (entity == null) {
            throw new ApplicationException("\u672a\u627e\u5230\u5bf9\u5e94\u6a21\u7248,\u8bf7\u5237\u65b0\u540e\u5c1d\u8bd5");
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(BizSupplierPerformanceEvaluationNotificationTemplate::getId, (Object)id);
        wrapper.set(BizSupplierPerformanceEvaluationNotificationTemplate::getStatus, (Object)status);
        boolean update = super.update((Wrapper)wrapper);
        if (!update) {
            return false;
        }
        if (status.equals("1")) {
            List orgList;
            int distributeType = 2;
            String processType = entity.getProcessType();
            String notificationTitle = entity.getNotificationTitle();
            String notificationContent = entity.getNotificationContent();
            String enterpriseContact = entity.getEnterpriseContact();
            String enterpriseTel = entity.getEnterpriseTel();
            String enterpriseAddress = entity.getEnterpriseAddress();
            LocalDateTime notifyDate = entity.getNotifyDate();
            LocalDateTime replyDeadline = entity.getReplyDeadline();
            LocalDateTime finishDeadline = entity.getFinishDeadline();
            String assessmentType = entity.getAssessmentType();
            Integer assessmentYear = entity.getAssessmentYear();
            Integer assessmentMonth = entity.getAssessmentMonth();
            Integer assessmentQuater = entity.getAssessmentQuater();
            String currentOrgId = ContextUtil.getCurrentOrgId();
            String currentOrgName = ContextUtil.getCurrentOrgName();
            String currentOrgCode = ContextUtil.getCurrentOrgCode();
            String level = entity.getLevel();
            String valuationConfigurationName = entity.getValuationConfigurationName();
            String assessmentResult = entity.getAssessmentResult();
            IUser user = ContextUtil.getCurrentUser();
            HashSet<String> noticeIds = new HashSet<String>();
            try {
                String orgExpand = entity.getOrgExpand();
                orgList = JSON.parseArray((String)orgExpand, OrgExpandDTO.class);
            }
            catch (Exception e) {
                throw new RuntimeException("\u89e3\u6790 orgExpand JSON \u5931\u8d25: ", e);
            }
            if (orgList == null || orgList.isEmpty()) {
                throw new ApplicationException("\u65e0\u4e0b\u53d1\u7684\u4f9b\u5e94\u5546");
            }
            ArrayList<BizSupplierPerformanceEvaluationNotification> notifications = new ArrayList<BizSupplierPerformanceEvaluationNotification>();
            for (OrgExpandDTO org : orgList) {
                BizSupplierPerformanceEvaluationNotification notification = new BizSupplierPerformanceEvaluationNotification();
                notification.setPerformanceEvaluationId(id);
                notification.setValuationConfigurationName(valuationConfigurationName);
                notification.setAssessmentType(assessmentType);
                notification.setAssessmentYear(assessmentYear);
                notification.setAssessmentMonth(assessmentMonth);
                notification.setAssessmentQuater(assessmentQuater);
                notification.setInitiatorId(user.getUserId());
                notification.setInitiatorAccount(user.getAccount());
                notification.setDistributeType(distributeType);
                notification.setInitiatorName(user.getFullname());
                notification.setEnterpriseId(currentOrgId);
                notification.setEnterpriseName(currentOrgName);
                notification.setEnterpriseCode(currentOrgCode);
                notification.setSupplierId(org.getSupplierId());
                notification.setSupplierName(org.getSupplierName());
                notification.setSupplierCode(org.getSupplierCode());
                notification.setProcessType(processType);
                notification.setNotificationTitle(notificationTitle);
                notification.setNotificationContent(notificationContent);
                notification.setEnterpriseContact(enterpriseContact);
                notification.setEnterpriseTel(enterpriseTel);
                notification.setEnterpriseAddress(enterpriseAddress);
                notification.setNotifyDate(notifyDate);
                notification.setReplyDeadline(replyDeadline);
                notification.setLevel(level);
                notification.setAssessmentResult(assessmentResult);
                notification.setFinishDeadline(finishDeadline);
                if (StringUtils.isNotBlank((String)notification.getId())) {
                    noticeIds.add(notification.getId());
                }
                notifications.add(notification);
            }
            return this.notificationManager.saveOrUpdateBatch(notifications);
        }
        return true;
    }

    @Override
    public boolean remove(List<String> ids) {
        LambdaQueryWrapper notificationLambdaQueryWrapper = new LambdaQueryWrapper();
        notificationLambdaQueryWrapper.in(BizSupplierPerformanceEvaluationNotification::getPerformanceEvaluationId, ids);
        notificationLambdaQueryWrapper.eq(BizSupplierPerformanceEvaluationNotification::getDistributeType, (Object)2);
        this.notificationManager.remove((Wrapper)notificationLambdaQueryWrapper);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(BizSupplierPerformanceEvaluationNotificationTemplate::getId, ids);
        return super.remove((Wrapper)wrapper);
    }

    @Transactional(readOnly=true)
    public BizSupplierPerformanceEvaluationNotificationTemplate getById(Serializable id) {
        BizSupplierPerformanceEvaluationNotificationTemplate entity = (BizSupplierPerformanceEvaluationNotificationTemplate)((Object)super.getById(id));
        if (entity == null) {
            return null;
        }
        return entity;
    }
}

