/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.supplierEva.manager.impl;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.gyl.supplierEva.dao.BizSupplierPerformanceEvaluationDao;
import com.artfess.gyl.supplierEva.dto.EvaluationDTO;
import com.artfess.gyl.supplierEva.dto.ResultEvaDTO;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationApprovalRecordManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationConfigurationUserManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationIntervalManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationNotificationManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationRatingManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationRatingUserManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationResultManager;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluation;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationApprovalRecord;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationConfigurationUser;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationCorrectionReport;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationInterval;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationNotification;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationRating;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationRatingUser;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationResult;
import com.artfess.gyl.supplierEva.vo.CorePerformanceVo;
import com.artfess.gyl.supplierEva.vo.EvaluationOptVo;
import com.artfess.gyl.supplierEva.vo.EvaluationResultVo;
import com.artfess.gyl.supplierEva.vo.EvaluationVo;
import com.artfess.gyl.supplierEva.vo.SupplierScore;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.util.Asserts;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizSupplierPerformanceEvaluationManagerImpl
extends BaseManagerImpl<BizSupplierPerformanceEvaluationDao, BizSupplierPerformanceEvaluation>
implements BizSupplierPerformanceEvaluationManager {
    @Resource
    private BizSupplierPerformanceEvaluationRatingManager ratingManager;
    @Resource
    private BizSupplierPerformanceEvaluationResultManager resultManager;
    @Resource
    private BizSupplierPerformanceEvaluationRatingUserManager ratingUserManager;
    @Resource
    private BizSupplierPerformanceEvaluationIntervalManager intervalManager;
    @Resource
    private BizSupplierPerformanceEvaluationNotificationManager notificationManager;
    @Resource
    private BizSupplierPerformanceEvaluationApprovalRecordManager recordManager;
    @Resource
    private BizSupplierPerformanceEvaluationConfigurationUserManager supplierManager;
    @Resource
    private FileManager fileManager;
    private static final List<String> COMPLETED_LEVELS = Arrays.asList("1", "2", "3");
    private static final String STATUS_INIT = "0";
    private static final String STATUS_COMPLETED = "1";
    private static final String STATUS_SUBMITTED = "2";
    private static final String STATUS_PARTIAL_COMPLETED = "3";
    private static final String STATUS_ALL_COMPLETED = "4";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean batchCreateEvaluationFromTemplate(EvaluationDTO dto) {
        IUser user = this.getCurrentUser();
        this.validateEvaluationData(dto);
        List<BizSupplierPerformanceEvaluationConfigurationUser> supplierList = this.getSupplierList(dto);
        if (CollectionUtils.isEmpty(supplierList)) {
            throw new ApplicationException("\u65e0\u5408\u683c\u4f9b\u5e94\u5546\u8fdb\u884c\u5206\u53d1");
        }
        this.initEvaluationData(dto, user);
        boolean saveResult = super.save((Object)dto);
        if (!saveResult) {
            return false;
        }
        this.saveEvaluationResults(dto, supplierList);
        return true;
    }

    private List<BizSupplierPerformanceEvaluationConfigurationUser> getSupplierList(EvaluationDTO dto) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(BizSupplierPerformanceEvaluationConfigurationUser::getValuationConfigurationId, (Object)dto.getValuationConfigurationId())).select(new SFunction[]{BizSupplierPerformanceEvaluationConfigurationUser::getSupplierId, BizSupplierPerformanceEvaluationConfigurationUser::getSupplierName, BizSupplierPerformanceEvaluationConfigurationUser::getSupplierCode});
        return this.supplierManager.list((Wrapper)wrapper);
    }

    private void saveEvaluationResults(EvaluationDTO dto, List<BizSupplierPerformanceEvaluationConfigurationUser> supplierList) {
        int totalScore = this.calculateTotalScore(dto.getDetails());
        List<BizSupplierPerformanceEvaluationResult> results = this.createEvaluationResults(dto, supplierList, totalScore);
        this.resultManager.saveBatch(results);
        results.forEach(result -> this.saveRatingDetailsAndUsers(dto.getId(), result.getId(), dto.getDetails()));
    }

    private int calculateTotalScore(List<BizSupplierPerformanceEvaluationRating> details) {
        AtomicReference<Integer> total = new AtomicReference<Integer>(0);
        details.forEach(detail -> {
            if (detail.getScore() != null) {
                total.updateAndGet(v -> v + detail.getScore());
            }
        });
        return total.get();
    }

    private List<BizSupplierPerformanceEvaluationResult> createEvaluationResults(EvaluationDTO dto, List<BizSupplierPerformanceEvaluationConfigurationUser> supplierList, int totalScore) {
        return supplierList.stream().map(item -> this.createEvaluationResult(dto, (BizSupplierPerformanceEvaluationConfigurationUser)((Object)item), totalScore)).collect(Collectors.toList());
    }

    private BizSupplierPerformanceEvaluationResult createEvaluationResult(EvaluationDTO dto, BizSupplierPerformanceEvaluationConfigurationUser item, int totalScore) {
        BizSupplierPerformanceEvaluationResult result = new BizSupplierPerformanceEvaluationResult();
        result.setValuationConfigurationId(dto.getValuationConfigurationId());
        result.setEvaluationId(dto.getId());
        result.setSupplierId(item.getSupplierId());
        result.setSupplierName(item.getSupplierName());
        result.setSupplierCode(item.getSupplierCode());
        result.setTotalScore(totalScore);
        result.setStatus(STATUS_SUBMITTED);
        return result;
    }

    private IUser getCurrentUser() {
        IUser user = ContextUtil.getCurrentUser();
        if (user == null) {
            throw new ApplicationException("\u672a\u627e\u5230\u7528\u6237\u4fe1\u606f");
        }
        return user;
    }

    private void validateEvaluationData(EvaluationDTO dto) {
        Asserts.notNull((Object)((Object)dto), (String)"\u8003\u6838\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Asserts.notNull(dto.getDetails(), (String)"\u8003\u6838\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private void initEvaluationData(EvaluationDTO dto, IUser user) {
        dto.setInitiatorId(user.getUserId());
        dto.setInitiatorAccount(user.getAccount());
        dto.setInitiatorName(user.getFullname());
        dto.setStatus(STATUS_SUBMITTED);
    }

    private void saveRatingDetailsAndUsers(String evaluationId, String resultId, List<BizSupplierPerformanceEvaluationRating> details) {
        List<BizSupplierPerformanceEvaluationRating> savedDetails = this.saveRatingDetails(evaluationId, resultId, details);
        this.saveRatingUsers(evaluationId, savedDetails);
    }

    private List<BizSupplierPerformanceEvaluationRating> saveRatingDetails(String evaluationId, String resultId, List<BizSupplierPerformanceEvaluationRating> details) {
        details.forEach(item -> {
            item.setId(null);
            item.setPerformanceEvaluationId(evaluationId);
            item.setPerformanceEvaluationResultId(resultId);
            item.setStatus(STATUS_INIT);
        });
        if (!this.ratingManager.saveBatch(details)) {
            throw new ApplicationException("\u8bc4\u5206\u660e\u7ec6\u4fdd\u5b58\u5931\u8d25");
        }
        return details;
    }

    private void saveRatingUsers(String evaluationId, List<BizSupplierPerformanceEvaluationRating> savedDetails) {
        List userList = savedDetails.stream().filter(item -> CollectionUtils.isNotEmpty(item.getUsers())).flatMap(item -> this.createRatingUsers(evaluationId, (BizSupplierPerformanceEvaluationRating)((Object)item))).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(userList) && !this.ratingUserManager.saveBatch(userList)) {
            throw new ApplicationException("\u8bc4\u5206\u7528\u6237\u4fdd\u5b58\u5931\u8d25");
        }
    }

    private Stream<BizSupplierPerformanceEvaluationRatingUser> createRatingUsers(String evaluationId, BizSupplierPerformanceEvaluationRating item) {
        return item.getUsers().stream().map(sourceUser -> this.createRatingUser(evaluationId, item, (BizSupplierPerformanceEvaluationRatingUser)((Object)sourceUser)));
    }

    private BizSupplierPerformanceEvaluationRatingUser createRatingUser(String evaluationId, BizSupplierPerformanceEvaluationRating item, BizSupplierPerformanceEvaluationRatingUser sourceUser) {
        BizSupplierPerformanceEvaluationRatingUser user = new BizSupplierPerformanceEvaluationRatingUser();
        user.setEvaluationRatingId(item.getId());
        user.setPerformanceEvaluationId(evaluationId);
        user.setRatingId(sourceUser.getRatingId());
        user.setRatingAccount(sourceUser.getRatingAccount());
        user.setRatingName(sourceUser.getRatingName());
        user.setScore(item.getScore());
        user.setStatus(STATUS_INIT);
        return user;
    }

    @Override
    @Transactional(readOnly=true)
    public EvaluationResultVo getModelById(String id) {
        EvaluationResultVo vo = this.resultManager.getModel(id);
        if (vo == null) {
            return null;
        }
        this.loadRelatedData(id, vo);
        return vo;
    }

    private void loadRelatedData(String resultId, EvaluationResultVo vo) {
        List<BizSupplierPerformanceEvaluationRating> ratings = this.loadRatingDetails(resultId);
        List<BizSupplierPerformanceEvaluationNotification> notifications = this.loadNotifications(resultId);
        List<BizSupplierPerformanceEvaluationApprovalRecord> records = this.getRecords(resultId);
        this.setRatingDetails(vo, ratings);
        this.setNotificationInfo(vo, notifications);
        this.setApprovalRecords(vo, records);
    }

    private void setRatingDetails(EvaluationResultVo vo, List<BizSupplierPerformanceEvaluationRating> ratings) {
        if (CollectionUtils.isNotEmpty(ratings)) {
            this.loadRatingUsers(ratings);
            vo.setDetails(ratings);
        }
    }

    private void setNotificationInfo(EvaluationResultVo vo, List<BizSupplierPerformanceEvaluationNotification> notifications) {
        if (CollectionUtils.isNotEmpty(notifications)) {
            vo.setNotification(notifications.get(0));
            this.loadCorrectionReportIfNeeded(vo, notifications.get(0));
        }
    }

    private void setApprovalRecords(EvaluationResultVo vo, List<BizSupplierPerformanceEvaluationApprovalRecord> records) {
        if (CollectionUtils.isNotEmpty(records)) {
            vo.setRecords(records);
        }
    }

    private List<BizSupplierPerformanceEvaluationRating> loadRatingDetails(String resultId) {
        return this.ratingManager.list((Wrapper)new LambdaQueryWrapper().eq(BizSupplierPerformanceEvaluationRating::getPerformanceEvaluationResultId, (Object)resultId));
    }

    private void loadRatingUsers(List<BizSupplierPerformanceEvaluationRating> ratings) {
        List ratingIds = ratings.stream().map(BizSupplierPerformanceEvaluationRating::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ratingIds)) {
            return;
        }
        List ratingUsers = this.ratingUserManager.list((Wrapper)new LambdaQueryWrapper().in(BizSupplierPerformanceEvaluationRatingUser::getEvaluationRatingId, ratingIds));
        if (CollectionUtils.isNotEmpty((Collection)ratingUsers)) {
            Map<String, List<BizSupplierPerformanceEvaluationRatingUser>> userMap = ratingUsers.stream().collect(Collectors.groupingBy(BizSupplierPerformanceEvaluationRatingUser::getEvaluationRatingId));
            ratings.forEach(rating -> rating.setUsers((List)userMap.get(rating.getId())));
        }
    }

    private List<BizSupplierPerformanceEvaluationNotification> loadNotifications(String performanceEvaluationId) {
        return this.notificationManager.list((Wrapper)new LambdaQueryWrapper().eq(BizSupplierPerformanceEvaluationNotification::getPerformanceEvaluationId, (Object)performanceEvaluationId));
    }

    private void loadCorrectionReportIfNeeded(EvaluationResultVo vo, BizSupplierPerformanceEvaluationNotification notification) {
        BizSupplierPerformanceEvaluationCorrectionReport report;
        if (vo.getProcessType() != null && STATUS_SUBMITTED.equals(vo.getProcessType()) && (report = this.notificationManager.getReport(notification.getId())) != null) {
            vo.setReport(report);
            this.loadReportFiles(report);
        }
    }

    private void loadReportFiles(BizSupplierPerformanceEvaluationCorrectionReport report) {
        List files = this.fileManager.queryFileByBizId(report.getId());
        report.setFiles(files);
    }

    @Override
    @Transactional(readOnly=true)
    public EvaluationOptVo getModelByUser(String id) {
        BizSupplierPerformanceEvaluation evaluation = (BizSupplierPerformanceEvaluation)this.get((Serializable)((Object)id));
        if (evaluation == null) {
            return null;
        }
        EvaluationOptVo vo = new EvaluationOptVo(evaluation);
        IUser user = this.getCurrentUser();
        List<BizSupplierPerformanceEvaluationRating> ratings = this.ratingManager.getByUser(user.getAccount(), id);
        vo.setDetails(ratings);
        return vo;
    }

    @Override
    @Transactional(readOnly=true)
    public List<SupplierScore> getUserRatings(String evaluationId, String detailsId) {
        IUser user = ContextUtil.getCurrentUser();
        return ((BizSupplierPerformanceEvaluationDao)this.baseMapper).getSupplierScores(user.getAccount(), evaluationId, detailsId);
    }

    @Override
    @Transactional(readOnly=true)
    public List<SupplierScore> getUserEvaluations(String ratingId) {
        return ((BizSupplierPerformanceEvaluationDao)this.baseMapper).getUserEvaluations(ratingId);
    }

    @Override
    @Transactional(readOnly=true)
    public PageList<EvaluationVo> queryEvaluationList(QueryFilter<BizSupplierPerformanceEvaluation> queryFilter) {
        IPage<EvaluationVo> iPage = ((BizSupplierPerformanceEvaluationDao)this.baseMapper).queryByEva((IPage<BizSupplierPerformanceEvaluation>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizSupplierPerformanceEvaluation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(iPage);
    }

    @Override
    @Transactional(readOnly=true)
    public PageList<EvaluationVo> queryEvaluationListByUser(QueryFilter<BizSupplierPerformanceEvaluation> queryFilter, String account) {
        IPage<EvaluationVo> iPage = ((BizSupplierPerformanceEvaluationDao)this.baseMapper).queryByUser((IPage<BizSupplierPerformanceEvaluation>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizSupplierPerformanceEvaluation>)this.convert2Wrapper(queryFilter, this.currentModelClass()), account);
        return new PageList(iPage);
    }

    @Override
    @Transactional(readOnly=true)
    public PageList<EvaluationVo> queryByPersonalSum(QueryFilter<BizSupplierPerformanceEvaluation> queryFilter) {
        IPage<EvaluationVo> iPage = ((BizSupplierPerformanceEvaluationDao)this.baseMapper).queryByPersonalSum((IPage<BizSupplierPerformanceEvaluation>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizSupplierPerformanceEvaluation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(iPage);
    }

    @Override
    @Transactional(readOnly=true)
    public PageList<CorePerformanceVo> queryBySupplierLevel(QueryFilter<BizSupplierPerformanceEvaluation> queryFilter) {
        IPage<CorePerformanceVo> iPage = ((BizSupplierPerformanceEvaluationDao)this.baseMapper).countSupplierLevel((IPage<BizSupplierPerformanceEvaluation>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizSupplierPerformanceEvaluation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(iPage);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveUserRating(List<BizSupplierPerformanceEvaluationRatingUser> ratingList) {
        if (CollectionUtils.isEmpty(ratingList)) {
            throw new ApplicationException("\u8bc4\u5206\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BizSupplierPerformanceEvaluationRatingUser firstRating = ratingList.get(0);
        String id = firstRating.getId();
        BizSupplierPerformanceEvaluationRatingUser user = (BizSupplierPerformanceEvaluationRatingUser)((Object)this.ratingUserManager.getById((Serializable)((Object)id)));
        if (user == null) {
            throw new ApplicationException("\u672a\u627e\u5230\u8bc4\u5206\u9879");
        }
        if (STATUS_SUBMITTED.equals(user.getStatus())) {
            throw new ApplicationException("\u5df2\u63d0\u4ea4\u8bc4\u5206\uff0c\u65e0\u6cd5\u518d\u8fdb\u884c\u4fee\u6539");
        }
        LocalDateTime now = LocalDateTime.now();
        ArrayList ratingIds = new ArrayList(ratingList.size());
        ratingList.forEach(item -> {
            item.setStatus(STATUS_COMPLETED);
            item.setRatingTime(now);
            ratingIds.add(item.getEvaluationRatingId());
        });
        if (!this.ratingUserManager.updateBatchById(ratingList)) {
            throw new ApplicationException("\u8bc4\u5206\u7528\u6237\u66f4\u65b0\u5931\u8d25");
        }
        List ratings = this.ratingManager.list((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{BizSupplierPerformanceEvaluationRating::getPerformanceEvaluationResultId}).in(BizSupplierPerformanceEvaluationRating::getId, ratingIds));
        List resultIds = ratings.stream().map(BizSupplierPerformanceEvaluationRating::getPerformanceEvaluationResultId).distinct().collect(Collectors.toList());
        if (!resultIds.isEmpty()) {
            boolean updateResult = this.resultManager.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(BizSupplierPerformanceEvaluationResult::getStatus, (Object)STATUS_PARTIAL_COMPLETED)).in(BizSupplierPerformanceEvaluationResult::getId, resultIds));
            if (!updateResult) {
                throw new ApplicationException("\u4fee\u6539\u8bc4\u5206\u7ed3\u679c\u5931\u8d25");
            }
            boolean updateEvaluation = ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(BizSupplierPerformanceEvaluation::getStatus, (Object)STATUS_PARTIAL_COMPLETED)).eq(BizSupplierPerformanceEvaluation::getId, (Object)user.getPerformanceEvaluationId())).update();
            if (!updateEvaluation) {
                throw new ApplicationException("\u66f4\u65b0\u8bc4\u5206\u914d\u7f6e\u5931\u8d25");
            }
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean submitUserRating(String evaId) {
        IUser user = ContextUtil.getCurrentUser();
        List<BizSupplierPerformanceEvaluationRatingUser> supplierUser = this.ratingUserManager.getSupplierByEvaId(evaId, null, user.getAccount());
        if (CollectionUtils.isEmpty(supplierUser)) {
            throw new ApplicationException("\u5f53\u524d\u7528\u6237\u65e0\u53ef\u63d0\u4ea4\u7684\u8bc4\u5206\u4fe1\u606f");
        }
        boolean hasUnratedItem = supplierUser.stream().anyMatch(s -> STATUS_INIT.equals(s.getStatus()));
        if (hasUnratedItem) {
            throw new ApplicationException("\u5f53\u524d\u7528\u6237\u5b58\u5728\u672a\u8bc4\u5ba1\u7684\u5f97\u5206\u9879\u65e0\u6cd5\u63d0\u4ea4");
        }
        boolean allSubmitted = supplierUser.stream().allMatch(s -> STATUS_SUBMITTED.equals(s.getStatus()));
        if (allSubmitted) {
            throw new ApplicationException("\u5f53\u524d\u7528\u6237\u5df2\u63d0\u4ea4,\u8bf7\u52ff\u4e8c\u6b21\u63d0\u4ea4");
        }
        List userIds = supplierUser.stream().map(BizSupplierPerformanceEvaluationRatingUser::getId).collect(Collectors.toList());
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.in(BizSupplierPerformanceEvaluationRatingUser::getId, userIds)).set(BizSupplierPerformanceEvaluationRatingUser::getStatus, (Object)STATUS_SUBMITTED);
        if (!this.ratingUserManager.update((Wrapper)updateWrapper)) {
            return false;
        }
        List ratingUsers = this.ratingUserManager.list((Wrapper)new LambdaQueryWrapper().eq(BizSupplierPerformanceEvaluationRatingUser::getPerformanceEvaluationId, (Object)evaId));
        boolean subMatch = ratingUsers.stream().allMatch(p -> STATUS_SUBMITTED.equals(p.getStatus()));
        if (subMatch) {
            Map<String, BigDecimal> ratingIdToAverageScore = this.calculateAverageScores(ratingUsers);
            this.updateRatingItems(ratingIdToAverageScore);
        }
        return true;
    }

    private Map<String, BigDecimal> calculateAverageScores(List<BizSupplierPerformanceEvaluationRatingUser> ratingUsers) {
        return ratingUsers.stream().filter(r -> STATUS_SUBMITTED.equals(r.getStatus())).filter(r -> r.getEvaluationRatingId() != null).collect(Collectors.groupingBy(BizSupplierPerformanceEvaluationRatingUser::getEvaluationRatingId, Collectors.collectingAndThen(Collectors.toList(), list -> {
            if (list.isEmpty()) {
                return BigDecimal.ZERO;
            }
            BigDecimal sum = list.stream().map(r -> r.getOperationScore() != null ? r.getOperationScore() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
            return sum.divide(BigDecimal.valueOf(list.size()), 2, RoundingMode.HALF_UP);
        })));
    }

    private void updateRatingItems(Map<String, BigDecimal> ratingIdToAverageScore) {
        HashSet<String> resultIds = new HashSet<String>();
        LocalDateTime now = LocalDateTime.now();
        for (Map.Entry<String, BigDecimal> entry : ratingIdToAverageScore.entrySet()) {
            String ratingId = entry.getKey();
            BigDecimal averageScore = entry.getValue();
            LambdaUpdateWrapper ratingUpdateWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)ratingUpdateWrapper.eq(BizSupplierPerformanceEvaluationRating::getId, (Object)ratingId)).set(BizSupplierPerformanceEvaluationRating::getStatus, (Object)STATUS_COMPLETED)).set(BizSupplierPerformanceEvaluationRating::getRatingTime, (Object)now)).set(BizSupplierPerformanceEvaluationRating::getOperationScore, (Object)averageScore);
            if (!this.ratingManager.update((Wrapper)ratingUpdateWrapper)) {
                throw new ApplicationException("\u4fee\u6539\u8bc4\u5206\u5931\u8d25");
            }
            BizSupplierPerformanceEvaluationRating rating = (BizSupplierPerformanceEvaluationRating)((Object)this.ratingManager.getById((Serializable)((Object)ratingId)));
            if (rating == null || !StringUtils.isNotBlank((String)rating.getPerformanceEvaluationResultId())) continue;
            resultIds.add(rating.getPerformanceEvaluationResultId());
        }
        resultIds.forEach(this::updatePerformanceEvaluations);
    }

    private void updatePerformanceEvaluations(String resultId) {
        BizSupplierPerformanceEvaluationResult result = (BizSupplierPerformanceEvaluationResult)((Object)this.resultManager.getById((Serializable)((Object)resultId)));
        if (result == null) {
            return;
        }
        String currentStatus = result.getStatus();
        if (!STATUS_SUBMITTED.equals(currentStatus) && !STATUS_PARTIAL_COMPLETED.equals(currentStatus)) {
            throw new ApplicationException("\u5df2\u5b8c\u6210\u8bc4\u5206\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u8fdb\u884c\u67e5\u770b");
        }
        String finalStatus = this.determineFinalStatus(resultId);
        result.setStatus(STATUS_PARTIAL_COMPLETED);
        if (STATUS_ALL_COMPLETED.equals(finalStatus)) {
            this.updateCompletedEvaluation(result);
        }
        this.resultManager.updateById((Object)result);
    }

    private String determineFinalStatus(String resultId) {
        List<BizSupplierPerformanceEvaluationRating> unfinishedRatings = this.getUnfinishedRatings(resultId);
        return unfinishedRatings.isEmpty() ? STATUS_ALL_COMPLETED : STATUS_PARTIAL_COMPLETED;
    }

    private void updateCompletedEvaluation(BizSupplierPerformanceEvaluationResult evaluation) {
        List allRatings = this.ratingManager.list((Wrapper)new LambdaQueryWrapper().eq(BizSupplierPerformanceEvaluationRating::getPerformanceEvaluationResultId, (Object)evaluation.getId()));
        if (CollectionUtils.isEmpty((Collection)allRatings)) {
            return;
        }
        BigDecimal totalScore = this.calculateTotalOperationScore(allRatings);
        String level = this.calculateLevel(evaluation.getValuationConfigurationId(), totalScore);
        if (COMPLETED_LEVELS.contains(level)) {
            evaluation.setStatus(STATUS_COMPLETED);
        } else {
            evaluation.setStatus(STATUS_ALL_COMPLETED);
        }
        evaluation.setOperationScore(totalScore);
        evaluation.setLevel(level);
    }

    private BigDecimal calculateTotalOperationScore(List<BizSupplierPerformanceEvaluationRating> allRatings) {
        if (CollectionUtils.isEmpty(allRatings)) {
            return BigDecimal.ZERO;
        }
        return allRatings.stream().map(BizSupplierPerformanceEvaluationRating::getOperationScore).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private List<BizSupplierPerformanceEvaluationRating> getUnfinishedRatings(String resultId) {
        return this.ratingManager.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizSupplierPerformanceEvaluationRating::getPerformanceEvaluationResultId, (Object)resultId)).ne(BizSupplierPerformanceEvaluationRating::getStatus, (Object)STATUS_COMPLETED));
    }

    private String calculateLevel(String configurationId, BigDecimal totalScore) {
        double scoreValue;
        String scoreKey;
        if (StringUtils.isBlank((String)configurationId) || totalScore == null) {
            return STATUS_COMPLETED;
        }
        String cacheKey = "level_config_" + configurationId;
        Map<String, String> levelCache = this.getLevelCache(cacheKey);
        if (levelCache.containsKey(scoreKey = String.format("%.2f", scoreValue = totalScore.doubleValue()))) {
            return levelCache.get(scoreKey);
        }
        List intervals = this.intervalManager.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizSupplierPerformanceEvaluationInterval::getPerformanceEvaluationConfigurationId, (Object)configurationId)).le(BizSupplierPerformanceEvaluationInterval::getMinScore, (Object)scoreValue)).ge(BizSupplierPerformanceEvaluationInterval::getMaxScore, (Object)scoreValue));
        String level = intervals.stream().findFirst().map(BizSupplierPerformanceEvaluationInterval::getLevel).orElse(STATUS_COMPLETED);
        levelCache.put(scoreKey, level);
        return level;
    }

    private Map<String, String> getLevelCache(String cacheKey) {
        return new ConcurrentHashMap<String, String>();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean submitUserEvaluation(ResultEvaDTO dto) {
        String resultId = dto.getPerformanceEvaluationId();
        BizSupplierPerformanceEvaluationResult result = (BizSupplierPerformanceEvaluationResult)this.resultManager.get((Serializable)((Object)resultId));
        if (result == null) {
            throw new ApplicationException("\u672a\u627e\u5230\u8bc4\u5206\u7ed3\u679c");
        }
        BizSupplierPerformanceEvaluation evaluation = (BizSupplierPerformanceEvaluation)super.get((Serializable)((Object)result.getEvaluationId()));
        if (evaluation == null) {
            throw new ApplicationException("\u672a\u627e\u5230\u8003\u6838\u6a21\u7248");
        }
        dto.setLevel(result.getLevel());
        dto.setOperationScore(result.getOperationScore());
        dto.setAssessmentType(evaluation.getAssessmentType());
        dto.setAssessmentYear(evaluation.getAssessmentYear());
        dto.setAssessmentQuarter(evaluation.getAssessmentQuater());
        dto.setAssessmentMonth(evaluation.getAssessmentMonth());
        dto.setValuationConfigurationName(evaluation.getValuationConfigurationName());
        this.notificationManager.saveEva(dto);
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(BizSupplierPerformanceEvaluationResult::getId, (Object)resultId)).set(BizSupplierPerformanceEvaluationResult::getAssessmentResult, (Object)dto.getAssessmentResult())).set(BizSupplierPerformanceEvaluationResult::getStatus, (Object)STATUS_COMPLETED)).set(BizSupplierPerformanceEvaluationResult::getProcessType, (Object)dto.getProcessType());
        return this.resultManager.update((Wrapper)wrapper);
    }

    private List<BizSupplierPerformanceEvaluationApprovalRecord> getRecords(String performanceEvaluationId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BizSupplierPerformanceEvaluationApprovalRecord::getPerformanceEvaluationId, (Object)performanceEvaluationId)).groupBy((Object[])new SFunction[]{BizSupplierPerformanceEvaluationApprovalRecord::getApprovalAccount, BizSupplierPerformanceEvaluationApprovalRecord::getStatus})).orderByAsc(AutoFillModel::getCreateTime);
        return this.recordManager.list((Wrapper)wrapper);
    }

    @Override
    @Transactional
    public boolean remove(List<String> idList) {
        List results = this.resultManager.listByIds(idList);
        if (CollectionUtils.isEmpty((Collection)results)) {
            return false;
        }
        boolean anyMatch = results.stream().anyMatch(result -> !result.getStatus().equals(STATUS_SUBMITTED));
        if (anyMatch) {
            throw new ApplicationException("\u5b58\u5728\u5df2\u8bc4\u5206\u7684\u6570\u636e,\u65e0\u6cd5\u5220\u9664\u3002");
        }
        return this.resultManager.removeByIds(idList);
    }

    @Override
    @Transactional
    public boolean updateByIds(List<String> idList, Integer status) {
        LambdaUpdateWrapper evaWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)evaWrapper.in(BizSupplierPerformanceEvaluation::getId, idList)).set(BizSupplierPerformanceEvaluation::getStatus, (Object)status);
        boolean update = super.update((Wrapper)evaWrapper);
        if (!update) {
            return false;
        }
        LambdaUpdateWrapper resultWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)resultWrapper.in(BizSupplierPerformanceEvaluationResult::getEvaluationId, idList)).set(BizSupplierPerformanceEvaluationResult::getStatus, (Object)status);
        return this.resultManager.update((Wrapper)resultWrapper);
    }
}

