/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.supplierEva.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.gyl.supplierEva.dao.BizSupplierPerformanceEvaluationDao;
import com.artfess.gyl.supplierEva.dto.EvaluationDTO;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationIntervalManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationRatingManager;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluation;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationInterval;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationRating;
import com.artfess.gyl.supplierEva.vo.EvaluationVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import org.apache.http.util.Asserts;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizSupplierPerformanceEvaluationManagerImpl
extends BaseManagerImpl<BizSupplierPerformanceEvaluationDao, BizSupplierPerformanceEvaluation>
implements BizSupplierPerformanceEvaluationManager {
    @Resource
    private BizSupplierPerformanceEvaluationRatingManager ratingManager;
    @Resource
    private BizSupplierPerformanceEvaluationIntervalManager intervalManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveModel(EvaluationDTO dto) {
        IUser user = ContextUtil.getCurrentUser();
        if (user == null) {
            throw new ApplicationException("\u672a\u627e\u5230\u7528\u6237\u4fe1\u606f");
        }
        dto.setInitiatorId(user.getUserId());
        dto.setInitiatorAccount(user.getAccount());
        dto.setInitiatorName(user.getFullname());
        dto.setStatus("2");
        dto.setAssessmentStartDate(LocalDate.now());
        List<BizSupplierPerformanceEvaluationRating> details = dto.getDetails();
        Asserts.notNull(details, (String)"\u8003\u6838\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
        boolean save = super.save((Object)dto);
        if (!save) {
            return false;
        }
        details.forEach(item -> {
            item.setId(null);
            item.setPerformanceEvaluationId(dto.getId());
            item.setStatus("0");
        });
        boolean saveBatch = this.ratingManager.saveBatch(details);
        if (!saveBatch) {
            throw new ApplicationException("\u8be6\u60c5\u66f4\u65b0\u5931\u8d25");
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateModel(EvaluationDTO dto) {
        List<BizSupplierPerformanceEvaluationRating> details = dto.getDetails();
        Asserts.notNull(details, (String)"\u8003\u6838\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
        boolean update = super.updateById((Object)dto);
        if (!update) {
            return false;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BizSupplierPerformanceEvaluationRating::getPerformanceEvaluationId, (Object)dto.getId());
        this.ratingManager.remove((Wrapper)wrapper);
        details.forEach(item -> {
            item.setId(null);
            item.setPerformanceEvaluationId(dto.getId());
            item.setStatus("0");
        });
        boolean saveBatch = this.ratingManager.saveBatch(details);
        if (!saveBatch) {
            throw new ApplicationException("\u8be6\u60c5\u66f4\u65b0\u5931\u8d25");
        }
        return true;
    }

    @Override
    @Transactional(readOnly=true)
    public EvaluationVo getModelById(String id) {
        BizSupplierPerformanceEvaluation evaluation = (BizSupplierPerformanceEvaluation)this.get((Serializable)((Object)id));
        if (evaluation == null) {
            return null;
        }
        EvaluationVo vo = new EvaluationVo(evaluation);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BizSupplierPerformanceEvaluationRating::getPerformanceEvaluationId, (Object)id);
        List ratings = this.ratingManager.list((Wrapper)wrapper);
        vo.setDetails(ratings);
        return vo;
    }

    @Override
    @Transactional(readOnly=true)
    public EvaluationVo getModelByUser(String id) {
        BizSupplierPerformanceEvaluation evaluation = (BizSupplierPerformanceEvaluation)this.get((Serializable)((Object)id));
        if (evaluation == null) {
            return null;
        }
        EvaluationVo vo = new EvaluationVo(evaluation);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BizSupplierPerformanceEvaluationRating::getPerformanceEvaluationId, (Object)id);
        IUser user = ContextUtil.getCurrentUser();
        if (user == null) {
            throw new ApplicationException("\u672a\u627e\u5230\u7528\u6237\u4fe1\u606f");
        }
        if (!user.isAdmin()) {
            wrapper.eq(BizSupplierPerformanceEvaluationRating::getOperationRatingAccount, (Object)user.getAccount());
        }
        List ratings = this.ratingManager.list((Wrapper)wrapper);
        vo.setDetails(ratings);
        return vo;
    }

    @Override
    public PageList<BizSupplierPerformanceEvaluation> queryByUser(QueryFilter<BizSupplierPerformanceEvaluation> queryFilter, String account) {
        IPage<BizSupplierPerformanceEvaluation> iPage = ((BizSupplierPerformanceEvaluationDao)this.baseMapper).queryByUser((IPage<BizSupplierPerformanceEvaluation>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizSupplierPerformanceEvaluation>)this.convert2Wrapper(queryFilter, this.currentModelClass()), account);
        return new PageList(iPage);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean userRating(List<BizSupplierPerformanceEvaluationRating> ratingList) {
        LocalDateTime now = LocalDateTime.now();
        IUser user = ContextUtil.getCurrentUser();
        if (user == null) {
            throw new ApplicationException("\u5f53\u524d\u7528\u6237\u672a\u627e\u5230");
        }
        ratingList.forEach(item -> {
            item.setStatus("1");
            item.setRatingTime(now);
            item.setOperationRatingId(user.getUserId());
            item.setOperationRatingAccount(user.getAccount());
            item.setOperationRatingName(user.getFullname());
        });
        if (!this.ratingManager.updateBatchById(ratingList)) {
            return false;
        }
        BizSupplierPerformanceEvaluationRating firstRating = ratingList.get(0);
        String performanceEvaluationId = firstRating.getPerformanceEvaluationId();
        List<BizSupplierPerformanceEvaluationRating> unfinishedRatings = this.getUnfinishedRatings(performanceEvaluationId);
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(BizSupplierPerformanceEvaluation::getId, (Object)performanceEvaluationId);
        if (!unfinishedRatings.isEmpty()) {
            updateWrapper.set(BizSupplierPerformanceEvaluation::getStatus, (Object)"3");
        } else {
            this.updateEvaluationWithScore(firstRating, (LambdaUpdateWrapper<BizSupplierPerformanceEvaluation>)updateWrapper);
        }
        return super.update((Wrapper)updateWrapper);
    }

    private List<BizSupplierPerformanceEvaluationRating> getUnfinishedRatings(String performanceEvaluationId) {
        return this.ratingManager.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizSupplierPerformanceEvaluationRating::getPerformanceEvaluationId, (Object)performanceEvaluationId)).eq(BizSupplierPerformanceEvaluationRating::getStatus, (Object)"0"));
    }

    private void updateEvaluationWithScore(BizSupplierPerformanceEvaluationRating rating, LambdaUpdateWrapper<BizSupplierPerformanceEvaluation> wrapper) {
        List allRatings = this.ratingManager.list((Wrapper)new LambdaQueryWrapper().eq(BizSupplierPerformanceEvaluationRating::getPerformanceEvaluationId, (Object)rating.getPerformanceEvaluationId()));
        int totalScore = allRatings.stream().mapToInt(BizSupplierPerformanceEvaluationRating::getScore).sum();
        String level = this.calculateLevel(rating.getPerformanceEvaluationConfigurationId(), totalScore);
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.set(BizSupplierPerformanceEvaluation::getStatus, (Object)"4")).set(BizSupplierPerformanceEvaluation::getTotalScore, (Object)totalScore)).set(BizSupplierPerformanceEvaluation::getLevel, (Object)level);
    }

    private String calculateLevel(String configurationId, int totalScore) {
        List intervals = this.intervalManager.list((Wrapper)new LambdaQueryWrapper().eq(BizSupplierPerformanceEvaluationInterval::getPerformanceEvaluationConfigurationId, (Object)configurationId));
        return intervals.stream().filter(interval -> totalScore >= interval.getMinScore() && totalScore <= interval.getMaxScore()).findFirst().map(BizSupplierPerformanceEvaluationInterval::getLevel).orElse("1");
    }
}

