/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.base.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.gyl.base.dao.BizContractDao;
import com.artfess.gyl.base.manager.BizContractManager;
import com.artfess.gyl.base.model.BizContract;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.ContractService;
import net.qiyuesuo.sdk.bean.contract.ViewUrlRequest;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.impl.ContractServiceImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BizContractManagerImpl
extends BaseManagerImpl<BizContractDao, BizContract>
implements BizContractManager {
    private static final Logger log = LogManager.getLogger(BizContractManagerImpl.class);
    @Value(value="${contractSys.serverUrl}")
    private String serverUrl;
    @Value(value="${contractSys.accessKey}")
    private String accessKey;
    @Value(value="${contractSys.accessSecret}")
    private String accessSecret;
    private ContractService contractService;

    public void init() {
        SDKClient sdkClient = new SDKClient(this.serverUrl, this.accessKey, this.accessSecret);
        this.contractService = new ContractServiceImpl(sdkClient);
    }

    @Override
    public String viewContract(String threeContrId) {
        if (BeanUtils.isEmpty((Object)threeContrId)) {
            throw new ApplicationException("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5408\u540cid");
        }
        this.init();
        ViewUrlRequest request = new ViewUrlRequest();
        request.setContractId(Long.valueOf(threeContrId));
        request.setPageType(ViewUrlRequest.PageType.CONTENT);
        String viewUrl = null;
        try {
            viewUrl = this.contractService.viewUrl(request);
        }
        catch (PrivateAppException e) {
            System.out.println(LocalDateTime.now() + "\u9884\u89c8\u5408\u540c\u5931\u8d25\uff1a" + e.getMessage());
            throw new BaseException("\u9884\u89c8\u5408\u540c\u5931\u8d25\uff1a" + e.getMessage());
        }
        log.info("=====\u9884\u89c8\u5730\u5740:" + viewUrl);
        return viewUrl;
    }

    @Override
    public void downContract(HttpServletResponse response, List<Long> threeContrIds) {
        if (BeanUtils.isEmpty(threeContrIds) || threeContrIds.size() <= 0) {
            throw new ApplicationException("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5408\u540cid");
        }
        this.init();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ServletOutputStream os = response.getOutputStream();){
            String fileName = URLEncoder.encode("\u5408\u540c\u6587\u4ef6.zip", "UTF-8");
            response.setContentType("APPLICATION/OCTET-STREAM");
            response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.addHeader("filename", fileName);
            this.contractService.batchDownload(threeContrIds, (OutputStream)baos);
            response.setHeader("Content-Length", String.valueOf(baos.size()));
            os.write(baos.toByteArray());
            os.flush();
        }
        catch (Exception e) {
            throw new BaseException("\u4e0b\u8f7d\u5408\u540c\u5931\u8d25\uff1a" + e.getMessage());
        }
    }
}

