/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.supplierEva.manager.impl;

import cn.hutool.core.lang.Assert;
import com.artfess.base.entity.BizDelModel;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.gyl.supplierEva.dao.BizSupplierPerformanceEvaluationConfigurationDao;
import com.artfess.gyl.supplierEva.dto.BindUserDTO;
import com.artfess.gyl.supplierEva.dto.ConfigurationDTO;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationConfigurationManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationConfigurationUserManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationDetailsManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationIntervalManager;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationConfiguration;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationConfigurationUser;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationDetails;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationInterval;
import com.artfess.gyl.supplierEva.vo.ConfigurationVo;
import com.artfess.gyl.supplierEva.vo.SupplierBaseVo;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizSupplierPerformanceEvaluationConfigurationManagerImpl
extends BaseManagerImpl<BizSupplierPerformanceEvaluationConfigurationDao, BizSupplierPerformanceEvaluationConfiguration>
implements BizSupplierPerformanceEvaluationConfigurationManager {
    @Resource
    private SysIdentityManager sysIdentityManager;
    @Resource
    private BizSupplierPerformanceEvaluationDetailsManager detailsManager;
    @Resource
    private BizSupplierPerformanceEvaluationIntervalManager intervalManager;
    @Resource
    private BizSupplierPerformanceEvaluationConfigurationUserManager configurationUserManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean savaModel(ConfigurationDTO dto) {
        Assert.notNull(dto.getDetails(), (String)"\u914d\u7f6e\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull(dto.getIntervals(), (String)"\u5f97\u5206\u9879\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String code = this.sysIdentityManager.nextId("gyszrpzbm");
        dto.setCode(code);
        boolean save = super.save((Object)dto);
        if (!save) {
            return false;
        }
        List<BizSupplierPerformanceEvaluationDetails> details = dto.getDetails();
        details.forEach(detail -> {
            detail.setPerformanceEvaluationConfigurationId(dto.getId());
            detail.setStatus("1");
            detail.setCode(UUID.randomUUID().toString().replace("-", "").substring(0, 8));
        });
        this.detailsManager.saveBatch(details);
        List<BizSupplierPerformanceEvaluationInterval> intervals = dto.getIntervals();
        intervals.forEach(detail -> detail.setPerformanceEvaluationConfigurationId(dto.getId()));
        this.intervalManager.saveBatch(intervals);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateModel(ConfigurationDTO dto) {
        Assert.notNull(dto.getDetails(), (String)"\u914d\u7f6e\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull(dto.getIntervals(), (String)"\u5f97\u5206\u9879\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        boolean update = super.updateById((Object)dto);
        if (!update) {
            return false;
        }
        this.detailsManager.remove((Wrapper)new LambdaQueryWrapper().eq(BizSupplierPerformanceEvaluationDetails::getPerformanceEvaluationConfigurationId, (Object)dto.getId()));
        List<BizSupplierPerformanceEvaluationDetails> details = dto.getDetails();
        details.forEach(detail -> {
            detail.setId(null);
            detail.setPerformanceEvaluationConfigurationId(dto.getId());
            detail.setCode(UUID.randomUUID().toString().replace("-", "").substring(0, 8));
            detail.setStatus("1");
        });
        this.detailsManager.saveBatch(details);
        this.intervalManager.remove((Wrapper)new LambdaQueryWrapper().eq(BizSupplierPerformanceEvaluationInterval::getPerformanceEvaluationConfigurationId, (Object)dto.getId()));
        List<BizSupplierPerformanceEvaluationInterval> intervals = dto.getIntervals();
        intervals.forEach(detail -> {
            detail.setId(null);
            detail.setPerformanceEvaluationConfigurationId(dto.getId());
        });
        this.intervalManager.saveBatch(intervals);
        return true;
    }

    @Override
    @Transactional(readOnly=true)
    public ConfigurationVo getModel(String id) {
        BizSupplierPerformanceEvaluationConfiguration configuration = (BizSupplierPerformanceEvaluationConfiguration)((Object)super.getById((Serializable)((Object)id)));
        ConfigurationVo vo = new ConfigurationVo(configuration);
        if (configuration != null) {
            List details = this.detailsManager.list((Wrapper)new LambdaQueryWrapper().eq(BizSupplierPerformanceEvaluationDetails::getPerformanceEvaluationConfigurationId, (Object)id));
            vo.setDetails(details);
            List intervals = this.intervalManager.list((Wrapper)new LambdaQueryWrapper().eq(BizSupplierPerformanceEvaluationInterval::getPerformanceEvaluationConfigurationId, (Object)id));
            vo.setIntervals(intervals);
        }
        return vo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateStatusById(String id, String status) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(BizSupplierPerformanceEvaluationConfiguration::getId, (Object)id);
        wrapper.set(BizSupplierPerformanceEvaluationConfiguration::getStatus, (Object)status);
        if (!this.update((Wrapper)wrapper)) {
            return false;
        }
        if ("0".equals(status)) {
            LambdaQueryWrapper rmWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizSupplierPerformanceEvaluationConfigurationUser::getValuationConfigurationId, (Object)id);
            this.configurationUserManager.remove((Wrapper)rmWrapper);
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean bindUser(BindUserDTO dto) {
        BizSupplierPerformanceEvaluationConfiguration configuration = (BizSupplierPerformanceEvaluationConfiguration)super.get((Serializable)((Object)dto.getId()));
        if (configuration == null) {
            throw new ApplicationException("\u672a\u627e\u5230\u76f8\u5173\u914d\u7f6e");
        }
        List supplierIds = dto.getConfigurationUsers().stream().map(BizSupplierPerformanceEvaluationConfigurationUser::getSupplierId).collect(Collectors.toList());
        LambdaQueryWrapper rmWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizDelModel::getCreateOrgId, (Object)ContextUtil.getCurrentOrgId())).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.or(subWrapper1 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)subWrapper1.ne(BizSupplierPerformanceEvaluationConfigurationUser::getValuationConfigurationId, (Object)dto.getId())).in(BizSupplierPerformanceEvaluationConfigurationUser::getSupplierId, (Collection)supplierIds);
            })).or(subWrapper2 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)subWrapper2.eq(BizSupplierPerformanceEvaluationConfigurationUser::getValuationConfigurationId, (Object)dto.getId());
            });
        });
        this.configurationUserManager.remove((Wrapper)rmWrapper);
        List<BizSupplierPerformanceEvaluationConfigurationUser> configurationUsers = dto.getConfigurationUsers();
        configurationUsers.forEach(user -> {
            user.setValuationConfigurationId(dto.getId());
            user.setId(null);
        });
        this.configurationUserManager.saveOrUpdateBatch(configurationUsers);
        return true;
    }

    @Override
    public List<SupplierBaseVo> getSuppliers(String enterpriseId, String configId, String categoryId) {
        return ((BizSupplierPerformanceEvaluationConfigurationDao)this.baseMapper).getSupplierEnterprise(enterpriseId, configId, categoryId);
    }
}

