/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.supplierApply4.tool;

import com.artfess.gyl.supplierApply3.dto.SupplierRegisterDTO;
import com.artfess.gyl.supplierApply3.model.BizSupplierAccessBasicInformation3;
import com.artfess.gyl.supplierApply3.model.BizSupplierEnterpriseCategory3;
import com.artfess.gyl.supplierApply3.model.BizSupplierEnterpriseGrading3;
import com.artfess.gyl.supplierApply3.model.BizSupplierEnterpriseQualification3;
import com.artfess.gyl.supplierApply3.model.BizSupplierMainProductsPerformance3;
import com.artfess.gyl.supplierApply3.model.BizSupplierMainRawMaterialsSuppliers3;
import com.artfess.gyl.supplierApply3.model.BizSupplierMainSupplyMaterialCategory3;
import com.artfess.gyl.supplierApply3.model.BizSupplierOtherSpecialNotes3;
import com.artfess.gyl.supplierApply3.model.BizSupplierProductionInspectionEquipment3;
import com.artfess.gyl.supplierApply3.model.BizSupplierProductionProcessFlow3;
import com.artfess.gyl.supplierApply3.model.BizSupplierProductionProcessPerformance3;
import com.artfess.gyl.supplierApply4.dto.SupplierRegister4DTO;
import com.artfess.gyl.supplierApply4.model.BizSupplierAccessBasicInformation4;
import com.artfess.gyl.supplierApply4.model.BizSupplierEnterpriseCategory4;
import com.artfess.gyl.supplierApply4.model.BizSupplierEnterpriseGrading4;
import com.artfess.gyl.supplierApply4.model.BizSupplierEnterpriseQualification4;
import com.artfess.gyl.supplierApply4.model.BizSupplierMainProductsPerformance4;
import com.artfess.gyl.supplierApply4.model.BizSupplierMainRawMaterialsSuppliers4;
import com.artfess.gyl.supplierApply4.model.BizSupplierMainSupplyMaterialCategory4;
import com.artfess.gyl.supplierApply4.model.BizSupplierOtherSpecialNotes4;
import com.artfess.gyl.supplierApply4.model.BizSupplierProductionInspectionEquipment4;
import com.artfess.gyl.supplierApply4.model.BizSupplierProductionProcessFlow4;
import com.artfess.gyl.supplierApply4.model.BizSupplierProductionProcessPerformance4;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SupplierDtoConverter {
    private static final Logger log = LoggerFactory.getLogger(SupplierDtoConverter.class);

    public SupplierRegisterDTO convertToSupplierRegisterDTO(SupplierRegister4DTO source) {
        if (source == null) {
            return null;
        }
        SupplierRegisterDTO target = new SupplierRegisterDTO();
        try {
            this.copyBaseFields(source, target);
            this.copyComponentFields(source, target);
            log.debug("DTO\u8f6c\u6362\u6210\u529f: SupplierRegister4DTO -> SupplierRegisterDTO");
            return target;
        }
        catch (Exception e) {
            log.error("DTO\u8f6c\u6362\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("DTO\u8f6c\u6362\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private void copyBaseFields(SupplierRegister4DTO source, SupplierRegisterDTO target) {
        target.setSupplierEnterpriseAccessId(source.getSupplierEnterpriseAccessId());
        target.setSupplierAccessNumber(source.getSupplierAccessNumber());
        target.setEnterpriseId(source.getEnterpriseId());
        target.setEnterpriseCode(source.getEnterpriseCode());
        target.setEnterpriseName(source.getEnterpriseName());
        target.setApplyDate(source.getApplyDate());
        target.setSelectionDate(source.getSelectionDate());
        target.setRecommendedDepartment(source.getRecommendedDepartment());
        target.setReferrer(source.getReferrer());
        target.setLastAssessmentDate(source.getLastAssessmentDate());
        target.setLastAssessmentType(source.getLastAssessmentType());
        target.setLastAssessmentScore(source.getLastAssessmentScore());
        target.setLastTransactionTime(source.getLastTransactionTime());
        target.setTransactionStatus(source.getTransactionStatus());
        target.setType(source.getType());
        target.setCreateMethod(source.getCreateMethod());
        target.setRemarks(source.getRemarks());
        target.setOverallRating(source.getOverallRating());
        target.setVersion(source.getVersion());
        target.setComprehensiveEvaluation(source.getComprehensiveEvaluation());
        target.setCompanyOrgcode(source.getCompanyOrgcode());
        target.setCompanyEbe(source.getCompanyEbe());
        target.setCompanyRegdate(source.getCompanyRegdate());
        target.setCompanyRegdateEnd(source.getCompanyRegdateEnd());
        target.setProvince(source.getProvince());
        target.setCity(source.getCity());
        target.setCounty(source.getCounty());
        target.setCompanyAddr(source.getCompanyAddr());
        target.setCompanyContact(source.getCompanyContact());
        target.setContactTel(source.getContactTel());
        target.setOwnerType(source.getOwnerType());
        target.setRegisteredCapital(source.getRegisteredCapital());
        target.setRegisteredCapitalType(source.getRegisteredCapitalType());
        target.setMail(source.getMail());
        target.setPostCode(source.getPostCode());
        target.setCreditCode(source.getCreditCode());
        target.setInterbank(source.getInterbank());
        target.setBank(source.getBank());
        target.setOpeningBank(source.getOpeningBank());
        target.setMailingAddress(source.getMailingAddress());
        target.setTaxpayerType(source.getTaxpayerType());
        target.setHistoryCompanyCode(source.getHistoryCompanyCode());
        target.setRegisType(source.getRegisType());
        target.setIndustryCode(source.getIndustryCode());
        target.setIndustryName(source.getIndustryName());
    }

    private void copyComponentFields(SupplierRegister4DTO source, SupplierRegisterDTO target) {
        List<BizSupplierEnterpriseCategory3> categoryList;
        if (source.getBasicInformation() != null) {
            target.setBasicInformation(this.convertToBizSupplierAccessBasicInformation3(source.getBasicInformation()));
        }
        if (!CollectionUtils.isEmpty(source.getEnterpriseCategory())) {
            categoryList = source.getEnterpriseCategory().stream().map(this::convertToBizSupplierEnterpriseCategory3).collect(Collectors.toList());
            target.setEnterpriseCategory(categoryList);
        }
        if (!CollectionUtils.isEmpty(source.getEnterpriseGrading())) {
            List<BizSupplierEnterpriseGrading3> gradingList = source.getEnterpriseGrading().stream().map(this::convertToBizSupplierEnterpriseGrading3).collect(Collectors.toList());
            target.setEnterpriseGrading(gradingList);
        }
        if (!CollectionUtils.isEmpty(source.getQualification())) {
            List<BizSupplierEnterpriseQualification3> qualificationList = source.getQualification().stream().map(this::convertToBizSupplierEnterpriseQualification3).collect(Collectors.toList());
            target.setQualification(qualificationList);
        }
        if (source.getPerformance() != null) {
            target.setPerformance(this.convertToBizSupplierMainProductsPerformance3(source.getPerformance()));
        }
        if (!CollectionUtils.isEmpty(source.getSuppliers())) {
            List<BizSupplierMainRawMaterialsSuppliers3> suppliersList = source.getSuppliers().stream().map(this::convertToBizSupplierMainRawMaterialsSuppliers3).collect(Collectors.toList());
            target.setSuppliers(suppliersList);
        }
        if (!CollectionUtils.isEmpty(source.getCategory())) {
            categoryList = source.getCategory().stream().map(this::convertToBizSupplierMainSupplyMaterialCategory3).collect(Collectors.toList());
            target.setCategory(categoryList);
        }
        if (source.getOtherSpecialNotes() != null) {
            target.setOtherSpecialNotes(this.convertToBizSupplierOtherSpecialNotes3(source.getOtherSpecialNotes()));
        }
        if (!CollectionUtils.isEmpty(source.getProdEquipment())) {
            List<BizSupplierProductionInspectionEquipment3> prodEquipmentList = source.getProdEquipment().stream().map(this::convertToBizSupplierProductionInspectionEquipment3).collect(Collectors.toList());
            target.setProdEquipment(prodEquipmentList);
        }
        if (!CollectionUtils.isEmpty(source.getMonitEquipment())) {
            List<BizSupplierProductionInspectionEquipment3> monitEquipmentList = source.getMonitEquipment().stream().map(this::convertToBizSupplierProductionInspectionEquipment3).collect(Collectors.toList());
            target.setMonitEquipment(monitEquipmentList);
        }
        if (source.getProcessPerformance() != null) {
            target.setProcessPerformance(this.convertToBizSupplierProductionProcessPerformance3(source.getProcessPerformance()));
        }
    }

    private BizSupplierAccessBasicInformation3 convertToBizSupplierAccessBasicInformation3(BizSupplierAccessBasicInformation4 source) {
        if (source == null) {
            return null;
        }
        BizSupplierAccessBasicInformation3 target = new BizSupplierAccessBasicInformation3();
        target.setId(source.getId());
        target.setSupplierEnterpriseId(source.getSupplierEnterpriseId());
        target.setEnterpriseId(source.getEnterpriseId());
        target.setQualityContactPerson(source.getQualityContactPerson());
        target.setQualityContactPersonPhone(source.getQualityContactPersonPhone());
        target.setCompanyWebsite(source.getCompanyWebsite());
        target.setProductionAddress(source.getProductionAddress());
        target.setFixedAssets(source.getFixedAssets());
        target.setLastYearSales(source.getLastYearSales());
        target.setMainProductsLastYearSales(source.getMainProductsLastYearSales());
        target.setMainProductsLastYearSalesRevenue(source.getMainProductsLastYearSalesRevenue());
        target.setTechnicalEngineer(source.getTechnicalEngineer());
        target.setQualityManagementPersonnel(source.getQualityManagementPersonnel());
        target.setEmployeesNumber(source.getEmployeesNumber());
        target.setProductionOperators(source.getProductionOperators());
        target.setVersion(source.getVersion());
        return target;
    }

    private BizSupplierEnterpriseCategory3 convertToBizSupplierEnterpriseCategory3(BizSupplierEnterpriseCategory4 source) {
        if (source == null) {
            return null;
        }
        BizSupplierEnterpriseCategory3 target = new BizSupplierEnterpriseCategory3();
        target.setId(source.getId());
        target.setSupplierEnterpriseId(source.getSupplierEnterpriseId());
        target.setSupplierCategoryConfigurationId(source.getSupplierCategoryConfigurationId());
        target.setVersion(source.getVersion());
        return target;
    }

    private BizSupplierEnterpriseGrading3 convertToBizSupplierEnterpriseGrading3(BizSupplierEnterpriseGrading4 source) {
        if (source == null) {
            return null;
        }
        BizSupplierEnterpriseGrading3 target = new BizSupplierEnterpriseGrading3();
        target.setId(source.getId());
        target.setSupplierEnterpriseId(source.getSupplierEnterpriseId());
        target.setSupplierGradingConfigurationId(source.getSupplierGradingConfigurationId());
        target.setSeq(source.getSeq());
        target.setVersion(source.getVersion());
        return target;
    }

    private BizSupplierEnterpriseQualification3 convertToBizSupplierEnterpriseQualification3(BizSupplierEnterpriseQualification4 source) {
        if (source == null) {
            return null;
        }
        BizSupplierEnterpriseQualification3 target = new BizSupplierEnterpriseQualification3();
        target.setId(source.getId());
        target.setQualificationAttribution(source.getQualificationAttribution());
        target.setFullName(source.getFullName());
        target.setEnterpriseId(source.getEnterpriseId());
        target.setEnterpriseCode(source.getEnterpriseCode());
        target.setIndustry(source.getIndustry());
        target.setQualificationCategoryCode(source.getQualificationCategoryCode());
        target.setQualificationCategoryName(source.getQualificationCategoryName());
        target.setName(source.getName());
        target.setCode(source.getCode());
        target.setIssuingAuthority(source.getIssuingAuthority());
        target.setIssueDate(source.getIssueDate());
        target.setValidUntil(source.getValidUntil());
        target.setStatus(source.getStatus());
        target.setRemarks(source.getRemarks());
        target.setVersion(source.getVersion());
        return target;
    }

    private BizSupplierMainProductsPerformance3 convertToBizSupplierMainProductsPerformance3(BizSupplierMainProductsPerformance4 source) {
        if (source == null) {
            return null;
        }
        BizSupplierMainProductsPerformance3 target = new BizSupplierMainProductsPerformance3();
        target.setId(source.getId());
        target.setSupplierEnterpriseId(source.getSupplierEnterpriseId());
        target.setProposedProductOffering(source.getProposedProductOffering());
        target.setBusinessPerformance(source.getBusinessPerformance());
        target.setVersion(source.getVersion());
        return target;
    }

    private BizSupplierMainRawMaterialsSuppliers3 convertToBizSupplierMainRawMaterialsSuppliers3(BizSupplierMainRawMaterialsSuppliers4 source) {
        if (source == null) {
            return null;
        }
        BizSupplierMainRawMaterialsSuppliers3 target = new BizSupplierMainRawMaterialsSuppliers3();
        target.setId(source.getId());
        target.setSupplierEnterpriseId(source.getSupplierEnterpriseId());
        target.setMainRawMaterialName(source.getMainRawMaterialName());
        target.setSupplier(source.getSupplier());
        target.setPreviousYearPerformance(source.getPreviousYearPerformance());
        target.setVersion(source.getVersion());
        return target;
    }

    private BizSupplierMainSupplyMaterialCategory3 convertToBizSupplierMainSupplyMaterialCategory3(BizSupplierMainSupplyMaterialCategory4 source) {
        if (source == null) {
            return null;
        }
        BizSupplierMainSupplyMaterialCategory3 target = new BizSupplierMainSupplyMaterialCategory3();
        target.setId(source.getId());
        target.setSupplierEnterpriseId(source.getSupplierEnterpriseId());
        target.setCategoryId(source.getCategoryId());
        target.setCategoryPlatcode(source.getCategoryPlatcode());
        target.setSeq(source.getSeq());
        target.setVersion(source.getVersion());
        return target;
    }

    private BizSupplierOtherSpecialNotes3 convertToBizSupplierOtherSpecialNotes3(BizSupplierOtherSpecialNotes4 source) {
        if (source == null) {
            return null;
        }
        BizSupplierOtherSpecialNotes3 target = new BizSupplierOtherSpecialNotes3();
        target.setId(source.getId());
        target.setSupplierEnterpriseId(source.getSupplierEnterpriseId());
        target.setNotes(source.getNotes());
        target.setVersion(source.getVersion());
        return target;
    }

    private BizSupplierProductionInspectionEquipment3 convertToBizSupplierProductionInspectionEquipment3(BizSupplierProductionInspectionEquipment4 source) {
        if (source == null) {
            return null;
        }
        BizSupplierProductionInspectionEquipment3 target = new BizSupplierProductionInspectionEquipment3();
        target.setId(source.getId());
        target.setSupplierEnterpriseId(source.getSupplierEnterpriseId());
        target.setDeviceType(source.getDeviceType());
        target.setName(source.getName());
        target.setCapacity(source.getCapacity());
        target.setNum(source.getNum());
        target.setManufacturer(source.getManufacturer());
        target.setServiceLife(source.getServiceLife());
        target.setVersion(source.getVersion());
        return target;
    }

    private BizSupplierProductionProcessPerformance3 convertToBizSupplierProductionProcessPerformance3(BizSupplierProductionProcessPerformance4 source) {
        if (source == null) {
            return null;
        }
        BizSupplierProductionProcessPerformance3 target = new BizSupplierProductionProcessPerformance3();
        target.setId(source.getId());
        target.setSupplierEnterpriseId(source.getSupplierEnterpriseId());
        target.setSuproductionProcess(source.getSuproductionProcess());
        target.setVersion(source.getVersion());
        if (!CollectionUtils.isEmpty(source.getFlow())) {
            target.setFlow(this.convertToBizSupplierProductionProcessFlow3List(source.getFlow()));
        }
        return target;
    }

    private List<BizSupplierProductionProcessFlow3> convertToBizSupplierProductionProcessFlow3List(List<BizSupplierProductionProcessFlow4> sourceList) {
        if (CollectionUtils.isEmpty(sourceList)) {
            return null;
        }
        return sourceList.stream().map(this::convertToBizSupplierProductionProcessFlow3).collect(Collectors.toList());
    }

    private BizSupplierProductionProcessFlow3 convertToBizSupplierProductionProcessFlow3(BizSupplierProductionProcessFlow4 source) {
        if (source == null) {
            return null;
        }
        BizSupplierProductionProcessFlow3 target = new BizSupplierProductionProcessFlow3();
        target.setId(source.getId());
        target.setSupplierProductionProcessPerformanceId(source.getSupplierProductionProcessPerformanceId());
        target.setKeyImportantProcess(source.getKeyImportantProcess());
        target.setControlParametersCharacteristics(source.getControlParametersCharacteristics());
        target.setProcessCapabilityIndex(source.getProcessCapabilityIndex());
        target.setVersion(source.getVersion());
        return target;
    }

    public List<SupplierRegisterDTO> convertToSupplierRegisterDTOList(List<SupplierRegister4DTO> sourceList) {
        if (CollectionUtils.isEmpty(sourceList)) {
            return Collections.emptyList();
        }
        return sourceList.stream().map(this::convertToSupplierRegisterDTO).collect(Collectors.toList());
    }
}

