/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.supplierApply4.tool;

import com.artfess.gyl.supplierApply.manager.BizSupplierEnterpriseManager;
import com.artfess.gyl.supplierApply.model.BizSupplierEnterprise;
import com.artfess.gyl.supplierApply3.dto.SupplierRegisterDTO;
import com.artfess.gyl.supplierApply3.manager.BizSupplierEnterpriseRegisterInformationManager;
import com.artfess.gyl.supplierApply4.dto.ReviewDTO;
import com.artfess.gyl.supplierApply4.dto.SupplierRegister4DTO;
import com.artfess.gyl.supplierApply4.manager.BizSupplierEnterpriseAccessApprovalRecord3Manager;
import com.artfess.gyl.supplierApply4.manager.BizSupplierEnterpriseChangeLogManager;
import com.artfess.gyl.supplierApply4.model.BizSupplierEnterpriseAccessApprovalRecord3;
import com.artfess.gyl.supplierApply4.model.BizSupplierEnterpriseChangeLog;
import com.artfess.gyl.supplierApply4.tool.SupplierDtoConverter;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class SupplierAsyncProcessor {
    private static final Logger log = LoggerFactory.getLogger(SupplierAsyncProcessor.class);
    @Resource
    private BizSupplierEnterpriseManager enterpriseManager;
    @Resource
    private BizSupplierEnterpriseAccessApprovalRecord3Manager record3Manager;
    @Resource
    private BizSupplierEnterpriseRegisterInformationManager registerInformationManager;
    @Resource
    private BizSupplierEnterpriseChangeLogManager manager;
    @Resource
    private SupplierDtoConverter supplierDtoConverter;

    @Async(value="taskExecutor")
    public void processApprovalResultAsync(ReviewDTO dto) {
        String changeLogId = dto.getId();
        try {
            BizSupplierEnterpriseChangeLog changeLog = (BizSupplierEnterpriseChangeLog)((Object)this.manager.getById((Serializable)((Object)dto.getId())));
            if (changeLog != null) {
                changeLog.setStatus("2");
                changeLog.setChangeEnterpriseReviewAmount(changeLog.getChangeEnterpriseReviewAmount() + 1);
                changeLog.setChangeEnterpriseUnreviewAmount(changeLog.getChangeEnterpriseUnreviewAmount() - 1);
                if (this.isAllEnterpriseProcessed(dto)) {
                    this.processApprovalResult(dto);
                    changeLog.setChangeInitiatorEndDate(LocalDateTime.now());
                    changeLog.setStatus("3");
                }
                this.manager.updateById((Object)changeLog);
            }
        }
        catch (Exception e) {
            log.error("\u5f02\u6b65\u5904\u7406\u5ba1\u6279\u7ed3\u679c\u5931\u8d25, changeLogId: {}", (Object)changeLogId, (Object)e);
        }
    }

    private boolean isAllEnterpriseProcessed(ReviewDTO dto) {
        List enterprises = this.enterpriseManager.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizSupplierEnterprise::getSupplierId, (Object)dto.getSupplierId())).groupBy(BizSupplierEnterprise::getEnterpriseId));
        if (CollectionUtils.isEmpty((Collection)enterprises)) {
            return false;
        }
        List approvalRecords = this.record3Manager.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizSupplierEnterpriseAccessApprovalRecord3::getSupplierEnterpriseChangeLogId, (Object)dto.getId())).in(BizSupplierEnterpriseAccessApprovalRecord3::getStatus, Arrays.asList("0", "1")));
        return enterprises.size() - 1 == approvalRecords.size();
    }

    private void processApprovalResult(ReviewDTO dto) {
        List approvalRecords = this.record3Manager.list((Wrapper)new LambdaQueryWrapper().eq(BizSupplierEnterpriseAccessApprovalRecord3::getSupplierEnterpriseChangeLogId, (Object)dto.getId()));
        long approvedCount = approvalRecords.stream().filter(record -> "1".equals(record.getApprovalResult())).count();
        if (approvedCount > 0L) {
            this.updateSupplierRegistration(dto);
        }
    }

    private void updateSupplierRegistration(ReviewDTO dto) {
        SupplierRegister4DTO information = dto.getInformation();
        information.setId(null);
        information.setVersion(information.getVersion() + 1L);
        SupplierRegisterDTO dto3 = this.supplierDtoConverter.convertToSupplierRegisterDTO(information);
        this.registerInformationManager.saveOrUpdateModel(dto3);
    }
}

