/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.supplierEva.manager.impl;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.gyl.supplierEva.dao.BizSupplierPerformanceEvaluationDao;
import com.artfess.gyl.supplierEva.dto.EvaluationDTO;
import com.artfess.gyl.supplierEva.dto.ResultEvaDTO;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationApprovalRecordManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationIntervalManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationNotificationManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationRatingManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationRatingUserManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationSupplierManager;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluation;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationApprovalRecord;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationCorrectionReport;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationInterval;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationNotification;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationRating;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationRatingUser;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationSupplier;
import com.artfess.gyl.supplierEva.vo.EvaluationOptVo;
import com.artfess.gyl.supplierEva.vo.EvaluationVo;
import com.artfess.gyl.supplierEva.vo.SupplierBaseVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.util.Asserts;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizSupplierPerformanceEvaluationManagerImpl
extends BaseManagerImpl<BizSupplierPerformanceEvaluationDao, BizSupplierPerformanceEvaluation>
implements BizSupplierPerformanceEvaluationManager {
    @Resource
    private BizSupplierPerformanceEvaluationRatingManager ratingManager;
    @Resource
    private BizSupplierPerformanceEvaluationRatingUserManager ratingUserManager;
    @Resource
    private BizSupplierPerformanceEvaluationIntervalManager intervalManager;
    @Resource
    private BizSupplierPerformanceEvaluationNotificationManager notificationManager;
    @Resource
    private BizSupplierPerformanceEvaluationApprovalRecordManager recordManager;
    @Resource
    private BizSupplierPerformanceEvaluationSupplierManager supplierManager;
    @Resource
    private FileManager fileManager;
    private static final String STATUS_INIT = "0";
    private static final String STATUS_COMPLETED = "1";
    private static final String STATUS_SUBMITTED = "2";
    private static final String STATUS_PARTIAL_COMPLETED = "3";
    private static final String STATUS_ALL_COMPLETED = "4";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveModel(EvaluationDTO dto) {
        IUser user = this.getCurrentUser();
        this.validateEvaluationData(dto);
        this.initEvaluationData(dto, user);
        if (!super.save((Object)dto)) {
            return false;
        }
        this.saveRatingDetailsAndUsers(dto);
        this.saveApprovalRecord(dto, user, STATUS_SUBMITTED);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean groupSaveModel(EvaluationDTO dto) {
        IUser user = this.getCurrentUser();
        this.validateEvaluationData(dto);
        String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        List<BizSupplierPerformanceEvaluationSupplier> supplierEnterprise = dto.getSuppliers();
        if (supplierEnterprise == null || supplierEnterprise.isEmpty()) {
            throw new ApplicationException("\u65e0\u5408\u683c\u4f9b\u5e94\u5546\u8fdb\u884c\u5206\u53d1");
        }
        supplierEnterprise.forEach(supplier -> {
            supplier.setId(null);
            supplier.setEvaluationNumber(timestamp);
            supplier.setValuationConfigurationId(dto.getValuationConfigurationId());
            supplier.setValuationConfigurationCode(dto.getValuationConfigurationCode());
            supplier.setValuationConfigurationName(dto.getValuationConfigurationName());
        });
        this.supplierManager.saveBatch(supplierEnterprise);
        this.initEvaluationData(dto, user);
        ArrayList<BizSupplierPerformanceEvaluation> entities = new ArrayList<BizSupplierPerformanceEvaluation>();
        ArrayList<EvaluationDTO> savedDtos = new ArrayList<EvaluationDTO>();
        for (BizSupplierPerformanceEvaluationSupplier vo : supplierEnterprise) {
            EvaluationDTO dto1 = new EvaluationDTO();
            try {
                BeanUtils.copyProperties((Object)((Object)dto1), (Object)((Object)dto));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            dto1.setSupplierId(vo.getSupplierId());
            dto1.setSupplierName(vo.getSupplierName());
            dto1.setSupplierCode(vo.getSupplierCode());
            BizSupplierPerformanceEvaluation entity = new BizSupplierPerformanceEvaluation();
            try {
                BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)dto1));
                entity.setEvaluationNumber(timestamp);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            entities.add(entity);
            savedDtos.add(dto1);
        }
        if (!super.saveBatch(entities)) {
            return false;
        }
        for (int i = 0; i < entities.size(); ++i) {
            BizSupplierPerformanceEvaluation entity = (BizSupplierPerformanceEvaluation)((Object)entities.get(i));
            EvaluationDTO fillDto = (EvaluationDTO)((Object)savedDtos.get(i));
            fillDto.setId(entity.getId());
            this.saveRatingDetailsAndUsers(fillDto);
            this.saveApprovalRecord(fillDto, user, STATUS_SUBMITTED);
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateModel(EvaluationDTO dto) {
        IUser user = this.getCurrentUser();
        this.validateEvaluationData(dto);
        this.initEvaluationData(dto, user);
        if (!super.updateById((Object)dto)) {
            return false;
        }
        this.removeRelatedData(dto.getId());
        this.saveRatingDetailsAndUsers(dto);
        return true;
    }

    private IUser getCurrentUser() {
        IUser user = ContextUtil.getCurrentUser();
        if (user == null) {
            throw new ApplicationException("\u672a\u627e\u5230\u7528\u6237\u4fe1\u606f");
        }
        return user;
    }

    private void validateEvaluationData(EvaluationDTO dto) {
        Asserts.notNull((Object)((Object)dto), (String)"\u8003\u6838\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Asserts.notNull(dto.getDetails(), (String)"\u8003\u6838\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private void initEvaluationData(EvaluationDTO dto, IUser user) {
        dto.setInitiatorId(user.getUserId());
        dto.setInitiatorAccount(user.getAccount());
        dto.setInitiatorName(user.getFullname());
        dto.setStatus(STATUS_SUBMITTED);
        dto.setAssessmentStartDate(LocalDate.now());
        int totalScore = dto.getDetails().stream().mapToInt(BizSupplierPerformanceEvaluationRating::getScore).sum();
        dto.setTotalScore(totalScore);
    }

    private void saveRatingDetailsAndUsers(EvaluationDTO dto) {
        List<BizSupplierPerformanceEvaluationRating> savedDetails = this.saveRatingDetails(dto);
        this.saveRatingUsers(dto, savedDetails);
    }

    private List<BizSupplierPerformanceEvaluationRating> saveRatingDetails(EvaluationDTO dto) {
        List<BizSupplierPerformanceEvaluationRating> details = dto.getDetails();
        details.forEach(item -> {
            item.setId(null);
            item.setPerformanceEvaluationId(dto.getId());
            item.setStatus(STATUS_INIT);
        });
        if (!this.ratingManager.saveBatch(details)) {
            throw new ApplicationException("\u8bc4\u5206\u660e\u7ec6\u4fdd\u5b58\u5931\u8d25");
        }
        return details;
    }

    private void saveRatingUsers(EvaluationDTO dto, List<BizSupplierPerformanceEvaluationRating> savedDetails) {
        HashMap<Integer, String> detailIdMap = new HashMap<Integer, String>();
        for (int i = 0; i < dto.getDetails().size() && i < savedDetails.size(); ++i) {
            detailIdMap.put(i, savedDetails.get(i).getId());
        }
        List userList = dto.getDetails().stream().filter(item -> CollectionUtils.isNotEmpty(item.getUsers())).flatMap(item -> {
            int index = dto.getDetails().indexOf(item);
            String detailId = (String)detailIdMap.get(index);
            return item.getUsers().stream().map(sourceUser -> {
                BizSupplierPerformanceEvaluationRatingUser user = new BizSupplierPerformanceEvaluationRatingUser();
                user.setEvaluationRatingId(detailId);
                user.setPerformanceEvaluationId(dto.getId());
                user.setRatingId(sourceUser.getRatingId());
                user.setRatingAccount(sourceUser.getRatingAccount());
                user.setRatingName(sourceUser.getRatingName());
                user.setScore(item.getScore());
                user.setStatus(STATUS_INIT);
                return user;
            });
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(userList) && !this.ratingUserManager.saveBatch(userList)) {
            throw new ApplicationException("\u8bc4\u5206\u7528\u6237\u4fdd\u5b58\u5931\u8d25");
        }
    }

    private void removeRelatedData(String performanceEvaluationId) {
        this.ratingManager.remove((Wrapper)new LambdaQueryWrapper().eq(BizSupplierPerformanceEvaluationRating::getPerformanceEvaluationId, (Object)performanceEvaluationId));
        this.ratingUserManager.remove((Wrapper)new LambdaQueryWrapper().eq(BizSupplierPerformanceEvaluationRatingUser::getPerformanceEvaluationId, (Object)performanceEvaluationId));
    }

    private void saveApprovalRecord(EvaluationDTO dto, IUser user, String status) {
        this.createApprovalRecord(dto.getId(), user, status, STATUS_COMPLETED);
    }

    private BizSupplierPerformanceEvaluationApprovalRecord createApprovalRecord(String performanceEvaluationId, IUser user, String status, String approvalResult) {
        BizSupplierPerformanceEvaluationApprovalRecord record = new BizSupplierPerformanceEvaluationApprovalRecord();
        record.setStatus(status);
        record.setPerformanceEvaluationId(performanceEvaluationId);
        record.setApprovalId(user.getUserId());
        record.setApprovalAccount(user.getAccount());
        record.setApprovalName(user.getFullname());
        record.setApprovalOrgId(ContextUtil.getCurrentOrgId());
        record.setApprovalOrgName(ContextUtil.getCurrentOrgName());
        record.setApprovalOrgCode(ContextUtil.getCurrentOrgCode());
        record.setApprovalResult(approvalResult);
        this.recordManager.fillModel(record);
        return record;
    }

    @Override
    @Transactional(readOnly=true)
    public EvaluationVo getModelById(String id) {
        BizSupplierPerformanceEvaluation evaluation = (BizSupplierPerformanceEvaluation)this.get((Serializable)((Object)id));
        if (evaluation == null) {
            return null;
        }
        EvaluationVo vo = new EvaluationVo(evaluation);
        this.loadRelatedData(id, vo);
        return vo;
    }

    private void loadRelatedData(String performanceEvaluationId, EvaluationVo vo) {
        CompletableFuture<List> ratingsFuture = CompletableFuture.supplyAsync(() -> this.loadRatingDetails(performanceEvaluationId));
        CompletableFuture<List> notificationsFuture = CompletableFuture.supplyAsync(() -> this.loadNotifications(performanceEvaluationId));
        CompletableFuture<List> recordsFuture = CompletableFuture.supplyAsync(() -> this.getRecords(performanceEvaluationId));
        try {
            List records;
            List notifications;
            List ratings = ratingsFuture.get();
            if (CollectionUtils.isNotEmpty((Collection)ratings)) {
                this.loadRatingUsers(ratings, performanceEvaluationId);
                vo.setDetails(ratings);
            }
            if (CollectionUtils.isNotEmpty((Collection)(notifications = notificationsFuture.get()))) {
                vo.setNotification((BizSupplierPerformanceEvaluationNotification)((Object)notifications.get(0)));
                this.loadCorrectionReportIfNeeded(vo, (BizSupplierPerformanceEvaluationNotification)((Object)notifications.get(0)));
            }
            if (CollectionUtils.isNotEmpty((Collection)(records = recordsFuture.get()))) {
                vo.setRecords(records);
            }
        }
        catch (Exception e) {
            throw new ApplicationException("\u52a0\u8f7d\u8bc4\u4f30\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    private List<BizSupplierPerformanceEvaluationRating> loadRatingDetails(String performanceEvaluationId) {
        return this.ratingManager.list((Wrapper)new LambdaQueryWrapper().eq(BizSupplierPerformanceEvaluationRating::getPerformanceEvaluationId, (Object)performanceEvaluationId));
    }

    private void loadRatingUsers(List<BizSupplierPerformanceEvaluationRating> ratings, String performanceEvaluationId) {
        List ratingIds = ratings.stream().map(BizSupplierPerformanceEvaluationRating::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ratingIds)) {
            return;
        }
        List ratingUsers = this.ratingUserManager.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(BizSupplierPerformanceEvaluationRatingUser::getEvaluationRatingId, ratingIds)).eq(BizSupplierPerformanceEvaluationRatingUser::getPerformanceEvaluationId, (Object)performanceEvaluationId));
        if (CollectionUtils.isNotEmpty((Collection)ratingUsers)) {
            Map<String, List<BizSupplierPerformanceEvaluationRatingUser>> userMap = ratingUsers.stream().collect(Collectors.groupingBy(BizSupplierPerformanceEvaluationRatingUser::getEvaluationRatingId));
            ratings.forEach(rating -> rating.setUsers((List)userMap.get(rating.getId())));
        }
    }

    private List<BizSupplierPerformanceEvaluationNotification> loadNotifications(String performanceEvaluationId) {
        return this.notificationManager.list((Wrapper)new LambdaQueryWrapper().eq(BizSupplierPerformanceEvaluationNotification::getPerformanceEvaluationId, (Object)performanceEvaluationId));
    }

    private void loadCorrectionReportIfNeeded(EvaluationVo vo, BizSupplierPerformanceEvaluationNotification notification) {
        BizSupplierPerformanceEvaluationCorrectionReport report;
        if (vo.getProcessType() != null && STATUS_SUBMITTED.equals(vo.getProcessType()) && (report = this.notificationManager.getReport(notification.getId())) != null) {
            vo.setReport(report);
            List files = this.fileManager.queryFileByBizId(report.getId());
            report.setFiles(files);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public EvaluationOptVo getModelByUser(String id) {
        BizSupplierPerformanceEvaluation evaluation = (BizSupplierPerformanceEvaluation)this.get((Serializable)((Object)id));
        if (evaluation == null) {
            return null;
        }
        EvaluationOptVo vo = new EvaluationOptVo(evaluation);
        IUser user = this.getCurrentUser();
        List<BizSupplierPerformanceEvaluationRatingUser> ratings = this.ratingManager.getByUser(user.getAccount(), id);
        vo.setDetails(ratings);
        return vo;
    }

    @Override
    @Transactional(readOnly=true)
    public List<BizSupplierPerformanceEvaluationRatingUser> getUserRatings(String configId) {
        List<BizSupplierPerformanceEvaluationRatingUser> ratings = this.ratingManager.getByUser(null, configId);
        if (CollectionUtils.isNotEmpty(ratings)) {
            HashSet seen = new HashSet();
            return ratings.stream().filter(rating -> {
                String key = (rating.getRatingAccount() != null ? rating.getRatingAccount() : "") + "|" + (rating.getStatus() != null ? rating.getStatus() : "");
                return seen.add(key);
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public PageList<EvaluationVo> queryByUser(QueryFilter<BizSupplierPerformanceEvaluation> queryFilter, String account) {
        IPage<EvaluationVo> iPage = ((BizSupplierPerformanceEvaluationDao)this.baseMapper).queryByUser((IPage<BizSupplierPerformanceEvaluation>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizSupplierPerformanceEvaluation>)this.convert2Wrapper(queryFilter, this.currentModelClass()), account);
        return new PageList(iPage);
    }

    @Override
    public PageList<EvaluationVo> queryByEarly(QueryFilter<BizSupplierPerformanceEvaluation> queryFilter) {
        IPage<EvaluationVo> iPage = ((BizSupplierPerformanceEvaluationDao)this.baseMapper).queryByEarly((IPage<BizSupplierPerformanceEvaluation>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizSupplierPerformanceEvaluation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(iPage);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean userRating(List<BizSupplierPerformanceEvaluationRatingUser> ratingList) {
        if (CollectionUtils.isEmpty(ratingList)) {
            return false;
        }
        LocalDateTime now = LocalDateTime.now();
        IUser user = this.getCurrentUser();
        this.updateRatingUsers(ratingList, now);
        this.processCompletedRatings(ratingList, now, user);
        return true;
    }

    private void updateRatingUsers(List<BizSupplierPerformanceEvaluationRatingUser> ratingList, LocalDateTime now) {
        ratingList.forEach(item -> {
            item.setStatus(STATUS_COMPLETED);
            item.setRatingTime(now);
        });
        if (!this.ratingUserManager.updateBatchById(ratingList)) {
            throw new ApplicationException("\u8bc4\u5206\u7528\u6237\u66f4\u65b0\u5931\u8d25");
        }
    }

    private void processCompletedRatings(List<BizSupplierPerformanceEvaluationRatingUser> ratingList, LocalDateTime now, IUser user) {
        List<String> evaluationRatingIds = ratingList.stream().map(BizSupplierPerformanceEvaluationRatingUser::getEvaluationRatingId).distinct().collect(Collectors.toList());
        Map<String, List<BizSupplierPerformanceEvaluationRatingUser>> allRatingsMap = this.getRatingUsersMap(evaluationRatingIds);
        Map<String, BizSupplierPerformanceEvaluationRating> ratingItemMap = this.getRatingItemsMap(evaluationRatingIds);
        ArrayList<BizSupplierPerformanceEvaluationRating> ratingsToUpdate = new ArrayList<BizSupplierPerformanceEvaluationRating>();
        for (String evaluationRatingId : evaluationRatingIds) {
            List<BizSupplierPerformanceEvaluationRatingUser> ratings = allRatingsMap.get(evaluationRatingId);
            BizSupplierPerformanceEvaluationRating ratingItem = ratingItemMap.get(evaluationRatingId);
            if (ratings == null || ratingItem == null || !this.isRatingGroupCompleted(ratings)) continue;
            this.updateRatingItem(ratingItem, ratings, now);
            ratingsToUpdate.add(ratingItem);
        }
        BizSupplierPerformanceEvaluationRatingUser ratingUser = ratingList.get(0);
        String performanceEvaluationId = ratingUser.getPerformanceEvaluationId();
        BizSupplierPerformanceEvaluationApprovalRecord record = this.createApprovalRecord(performanceEvaluationId, user, this.determineFinalStatus(performanceEvaluationId), STATUS_COMPLETED);
        this.batchSaveUpdates(ratingsToUpdate, record);
    }

    private Map<String, List<BizSupplierPerformanceEvaluationRatingUser>> getRatingUsersMap(List<String> evaluationRatingIds) {
        return this.ratingUserManager.list((Wrapper)new LambdaQueryWrapper().in(BizSupplierPerformanceEvaluationRatingUser::getEvaluationRatingId, evaluationRatingIds)).stream().collect(Collectors.groupingBy(BizSupplierPerformanceEvaluationRatingUser::getEvaluationRatingId));
    }

    private Map<String, BizSupplierPerformanceEvaluationRating> getRatingItemsMap(List<String> evaluationRatingIds) {
        return this.ratingManager.listByIds(evaluationRatingIds).stream().collect(Collectors.toMap(BizSupplierPerformanceEvaluationRating::getId, Function.identity()));
    }

    private boolean isRatingGroupCompleted(List<BizSupplierPerformanceEvaluationRatingUser> ratings) {
        return ratings.stream().allMatch(rating -> STATUS_COMPLETED.equals(rating.getStatus()));
    }

    private void updateRatingItem(BizSupplierPerformanceEvaluationRating ratingItem, List<BizSupplierPerformanceEvaluationRatingUser> ratings, LocalDateTime now) {
        BigDecimal averageScore = this.calculateAverageScore(ratings);
        ratingItem.setStatus(STATUS_COMPLETED);
        ratingItem.setRatingTime(now);
        ratingItem.setOperationScore(averageScore);
    }

    private void batchSaveUpdates(List<BizSupplierPerformanceEvaluationRating> ratingsToUpdate, BizSupplierPerformanceEvaluationApprovalRecord record) {
        if (CollectionUtils.isNotEmpty(ratingsToUpdate)) {
            this.ratingManager.updateBatchById(ratingsToUpdate);
        }
        this.updatePerformanceEvaluationsStatus(record.getPerformanceEvaluationId());
    }

    private void updatePerformanceEvaluationsStatus(String id) {
        if (StringUtils.isNotEmpty((String)id)) {
            this.updatePerformanceEvaluations(id);
        }
    }

    private void updatePerformanceEvaluations(String performanceEvaluationId) {
        BizSupplierPerformanceEvaluation evaluation = (BizSupplierPerformanceEvaluation)((Object)super.getById((Serializable)((Object)performanceEvaluationId)));
        if (!Objects.equals(evaluation.getStatus(), STATUS_SUBMITTED) && !Objects.equals(evaluation.getStatus(), STATUS_PARTIAL_COMPLETED)) {
            throw new ApplicationException("\u5df2\u5b8c\u6210\u8bc4\u5206\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u8fdb\u884c\u67e5\u770b");
        }
        String finalStatus = this.determineFinalStatus(evaluation.getId());
        evaluation.setStatus(STATUS_PARTIAL_COMPLETED);
        if (STATUS_ALL_COMPLETED.equals(finalStatus)) {
            this.updateCompletedEvaluation(evaluation);
        }
        super.updateById((Object)evaluation);
    }

    private String determineFinalStatus(String performanceEvaluationId) {
        List<BizSupplierPerformanceEvaluationRating> unfinishedRatings = this.getUnfinishedRatings(performanceEvaluationId);
        return unfinishedRatings.isEmpty() ? STATUS_ALL_COMPLETED : STATUS_PARTIAL_COMPLETED;
    }

    private void updateCompletedEvaluation(BizSupplierPerformanceEvaluation evaluation) {
        List allRatings = this.ratingManager.list((Wrapper)new LambdaQueryWrapper().eq(BizSupplierPerformanceEvaluationRating::getPerformanceEvaluationId, (Object)evaluation.getId()));
        BigDecimal totalScore = allRatings.stream().map(BizSupplierPerformanceEvaluationRating::getOperationScore).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        String level = this.calculateLevel(evaluation.getValuationConfigurationId(), totalScore);
        evaluation.setStatus(STATUS_ALL_COMPLETED);
        evaluation.setOperationScore(totalScore);
        evaluation.setLevel(level);
    }

    private List<BizSupplierPerformanceEvaluationRating> getUnfinishedRatings(String performanceEvaluationId) {
        return this.ratingManager.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizSupplierPerformanceEvaluationRating::getPerformanceEvaluationId, (Object)performanceEvaluationId)).ne(BizSupplierPerformanceEvaluationRating::getStatus, (Object)STATUS_COMPLETED));
    }

    private BigDecimal calculateAverageScore(List<BizSupplierPerformanceEvaluationRatingUser> ratings) {
        if (CollectionUtils.isEmpty(ratings)) {
            return BigDecimal.ZERO;
        }
        List validScores = ratings.stream().map(BizSupplierPerformanceEvaluationRatingUser::getOperationScore).filter(Objects::nonNull).collect(Collectors.toList());
        if (validScores.isEmpty()) {
            return BigDecimal.ZERO;
        }
        BigDecimal sum = validScores.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        return sum.divide(BigDecimal.valueOf(validScores.size()), 2, RoundingMode.HALF_UP);
    }

    private String calculateLevel(String configurationId, BigDecimal totalScore) {
        if (StringUtils.isBlank((String)configurationId) || totalScore == null) {
            return STATUS_COMPLETED;
        }
        List intervals = this.intervalManager.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizSupplierPerformanceEvaluationInterval::getPerformanceEvaluationConfigurationId, (Object)configurationId)).le(BizSupplierPerformanceEvaluationInterval::getMinScore, (Object)totalScore.doubleValue())).ge(BizSupplierPerformanceEvaluationInterval::getMaxScore, (Object)totalScore.doubleValue()));
        return intervals.stream().findFirst().map(BizSupplierPerformanceEvaluationInterval::getLevel).orElse(STATUS_COMPLETED);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean userEva(ResultEvaDTO dto) {
        IUser user = this.getCurrentUser();
        this.notificationManager.saveEva(dto);
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(BizSupplierPerformanceEvaluation::getId, (Object)dto.getPerformanceEvaluationId())).set(BizSupplierPerformanceEvaluation::getAssessmentResult, (Object)dto.getAssessmentResult())).set(BizSupplierPerformanceEvaluation::getStatus, (Object)STATUS_COMPLETED)).set(BizSupplierPerformanceEvaluation::getProcessType, (Object)dto.getProcessType());
        this.createApprovalRecord(dto.getPerformanceEvaluationId(), user, STATUS_COMPLETED, STATUS_COMPLETED);
        return super.update((Wrapper)wrapper);
    }

    @Override
    public List<SupplierBaseVo> getSuppliers(String enterpriseId, String gradeId, String categoryId) {
        return ((BizSupplierPerformanceEvaluationDao)this.baseMapper).getSupplierEnterprise(enterpriseId, gradeId, categoryId);
    }

    private List<BizSupplierPerformanceEvaluationApprovalRecord> getRecords(String performanceEvaluationId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BizSupplierPerformanceEvaluationApprovalRecord::getPerformanceEvaluationId, (Object)performanceEvaluationId)).groupBy((Object[])new SFunction[]{BizSupplierPerformanceEvaluationApprovalRecord::getApprovalAccount, BizSupplierPerformanceEvaluationApprovalRecord::getStatus})).orderByAsc(AutoFillModel::getCreateTime);
        return this.recordManager.list((Wrapper)wrapper);
    }
}

