/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.supplierApply4.manager.impl;

import com.artfess.base.entity.BizDelModel;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.gyl.supplierApply4.dao.BizSupplierEnterpriseTemporaryChangeDao;
import com.artfess.gyl.supplierApply4.dto.SupplierRegister4DTO;
import com.artfess.gyl.supplierApply4.manager.BizSupplierAccessBasicInformation4Manager;
import com.artfess.gyl.supplierApply4.manager.BizSupplierEnterpriseCategory4Manager;
import com.artfess.gyl.supplierApply4.manager.BizSupplierEnterpriseGrading4Manager;
import com.artfess.gyl.supplierApply4.manager.BizSupplierEnterpriseQualification4Manager;
import com.artfess.gyl.supplierApply4.manager.BizSupplierEnterpriseTemporaryChangeManager;
import com.artfess.gyl.supplierApply4.manager.BizSupplierMainProductsPerformance4Manager;
import com.artfess.gyl.supplierApply4.manager.BizSupplierMainRawMaterialsSuppliers4Manager;
import com.artfess.gyl.supplierApply4.manager.BizSupplierMainSupplyMaterialCategory4Manager;
import com.artfess.gyl.supplierApply4.manager.BizSupplierOtherSpecialNotes4Manager;
import com.artfess.gyl.supplierApply4.manager.BizSupplierProductionInspectionEquipment4Manager;
import com.artfess.gyl.supplierApply4.manager.BizSupplierProductionProcessPerformance4Manager;
import com.artfess.gyl.supplierApply4.model.BizSupplierAccessBasicInformation4;
import com.artfess.gyl.supplierApply4.model.BizSupplierEnterpriseCategory4;
import com.artfess.gyl.supplierApply4.model.BizSupplierEnterpriseGrading4;
import com.artfess.gyl.supplierApply4.model.BizSupplierEnterpriseQualification4;
import com.artfess.gyl.supplierApply4.model.BizSupplierEnterpriseTemporaryChange;
import com.artfess.gyl.supplierApply4.model.BizSupplierMainProductsPerformance4;
import com.artfess.gyl.supplierApply4.model.BizSupplierMainRawMaterialsSuppliers4;
import com.artfess.gyl.supplierApply4.model.BizSupplierMainSupplyMaterialCategory4;
import com.artfess.gyl.supplierApply4.model.BizSupplierOtherSpecialNotes4;
import com.artfess.gyl.supplierApply4.model.BizSupplierProductionInspectionEquipment4;
import com.artfess.gyl.supplierApply4.model.BizSupplierProductionProcessPerformance4;
import com.artfess.gyl.supplierApply4.vo.SupplierRegister4Vo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizSupplierEnterpriseTemporaryChangeManagerImpl
extends BaseManagerImpl<BizSupplierEnterpriseTemporaryChangeDao, BizSupplierEnterpriseTemporaryChange>
implements BizSupplierEnterpriseTemporaryChangeManager {
    @Resource
    private BizSupplierAccessBasicInformation4Manager information4Manager;
    @Resource
    private BizSupplierEnterpriseCategory4Manager category4Manager;
    @Resource
    private BizSupplierEnterpriseGrading4Manager grading4Manager;
    @Resource
    private BizSupplierEnterpriseQualification4Manager qualification4Manager;
    @Resource
    private BizSupplierMainProductsPerformance4Manager productsPerformance4Manager;
    @Resource
    private BizSupplierMainRawMaterialsSuppliers4Manager suppliers4Manager;
    @Resource
    private BizSupplierMainSupplyMaterialCategory4Manager materialCategory4Manager;
    @Resource
    private BizSupplierOtherSpecialNotes4Manager notes4Manager;
    @Resource
    private BizSupplierProductionInspectionEquipment4Manager equipment4Manager;
    @Resource
    private BizSupplierProductionProcessPerformance4Manager processPerformance4Manager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveOrUpdateModel(SupplierRegister4DTO dto) {
        if (dto.getSupplierId() == null) {
            throw new ApplicationException("\u8bf7\u5148\u4fdd\u5b58\u4f9b\u5e94\u5546\u57fa\u672c\u4fe1\u606f");
        }
        boolean save = super.saveOrUpdate((Object)dto);
        if (!save) {
            return false;
        }
        String id = dto.getId();
        Long version = dto.getVersion();
        String code = dto.getCode();
        if (code != null) {
            this.saveAllRelatedData(dto, id, version, code);
        }
        return true;
    }

    @Override
    @Transactional(readOnly=true)
    public SupplierRegister4Vo getById(String id) {
        BizSupplierEnterpriseTemporaryChange information = (BizSupplierEnterpriseTemporaryChange)super.get((Serializable)((Object)id));
        if (information == null) {
            return null;
        }
        SupplierRegister4Vo vo = new SupplierRegister4Vo(information);
        this.getAllRelatedData(vo, id, information.getVersion());
        return vo;
    }

    @Override
    @Transactional(readOnly=true)
    public SupplierRegister4Vo getBySupplierId(String supplierId) {
        BizSupplierEnterpriseTemporaryChange information = (BizSupplierEnterpriseTemporaryChange)((Object)super.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizSupplierEnterpriseTemporaryChange::getSupplierId, (Object)supplierId)).orderByDesc(BizDelModel::getVersion)).last("limit 1")));
        if (information == null) {
            return null;
        }
        SupplierRegister4Vo vo = new SupplierRegister4Vo(information);
        this.getAllRelatedData(vo, information.getId(), information.getVersion());
        return vo;
    }

    private void saveAllRelatedData(SupplierRegister4DTO dto, String id, Long version, String code) {
        this.deleteRelatedDataByCode(id, code, version);
        if ("-1".equals(code)) {
            this.processAllModules(dto, id, version);
        } else {
            this.processSingleModule(dto, id, version, code);
        }
    }

    private void processAllModules(SupplierRegister4DTO dto, String id, Long version) {
        this.processBasicInformation(dto.getBasicInformation(), id, version);
        this.processCategoryData(dto.getEnterpriseCategory(), id, version);
        this.processGradingData(dto.getEnterpriseGrading(), id, version);
        this.processSuppliersData(dto.getSuppliers(), id, version);
        this.processMaterialCategoryData(dto.getCategory(), id, version);
        this.processOtherSpecialNotesData(dto.getOtherSpecialNotes(), id, version);
        this.processEquipmentData(dto, id, version);
        this.processQualificationData(dto.getQualification(), version);
        this.processProductsPerformanceData(dto.getPerformance(), id, version);
        this.processProcessPerformanceData(dto.getProcessPerformance(), id, version);
    }

    private void processSingleModule(SupplierRegister4DTO dto, String id, Long version, String code) {
        switch (code) {
            case "1": {
                this.processBasicInformation(dto.getBasicInformation(), id, version);
                break;
            }
            case "2": {
                this.processCategoryData(dto.getEnterpriseCategory(), id, version);
                break;
            }
            case "3": {
                this.processGradingData(dto.getEnterpriseGrading(), id, version);
                break;
            }
            case "4": {
                this.processSuppliersData(dto.getSuppliers(), id, version);
                break;
            }
            case "5": {
                this.processMaterialCategoryData(dto.getCategory(), id, version);
                break;
            }
            case "6": {
                this.processOtherSpecialNotesData(dto.getOtherSpecialNotes(), id, version);
                break;
            }
            case "7": {
                this.processEquipmentData(dto, id, version);
                break;
            }
            case "8": {
                this.processQualificationData(dto.getQualification(), version);
                break;
            }
            case "9": {
                this.processProductsPerformanceData(dto.getPerformance(), id, version);
                break;
            }
            case "10": {
                this.processProcessPerformanceData(dto.getProcessPerformance(), id, version);
            }
        }
    }

    private void processBasicInformation(BizSupplierAccessBasicInformation4 entity, String id, Long version) {
        if (entity != null) {
            entity.setSupplierEnterpriseId(id);
            entity.setVersion(version);
            entity.setId(null);
            this.information4Manager.save((Object)entity);
        }
    }

    private void processCategoryData(List<BizSupplierEnterpriseCategory4> list, String id, Long version) {
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(entity -> {
                entity.setSupplierEnterpriseId(id);
                entity.setVersion(version);
                entity.setId(null);
            });
            this.category4Manager.saveBatch(list);
        }
    }

    private void processGradingData(List<BizSupplierEnterpriseGrading4> list, String id, Long version) {
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(entity -> {
                entity.setSupplierEnterpriseId(id);
                entity.setVersion(version);
                entity.setId(null);
            });
            this.grading4Manager.saveBatch(list);
        }
    }

    private void processSuppliersData(List<BizSupplierMainRawMaterialsSuppliers4> list, String id, Long version) {
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(entity -> {
                entity.setSupplierEnterpriseId(id);
                entity.setVersion(version);
                entity.setId(null);
            });
            this.suppliers4Manager.saveBatch(list);
        }
    }

    private void processMaterialCategoryData(List<BizSupplierMainSupplyMaterialCategory4> list, String id, Long version) {
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(entity -> {
                entity.setSupplierEnterpriseId(id);
                entity.setVersion(version);
                entity.setId(null);
            });
            this.materialCategory4Manager.saveBatch(list);
        }
    }

    private void processOtherSpecialNotesData(BizSupplierOtherSpecialNotes4 entity, String id, Long version) {
        if (BeanUtils.isNotEmpty((Object)((Object)entity))) {
            entity.setSupplierEnterpriseId(id);
            entity.setVersion(version);
            entity.setId(null);
            this.notes4Manager.save((Object)entity);
        }
    }

    private void processEquipmentData(SupplierRegister4DTO dto, String id, Long version) {
        ArrayList<BizSupplierProductionInspectionEquipment4> equipmentList = new ArrayList<BizSupplierProductionInspectionEquipment4>();
        if (CollectionUtils.isNotEmpty(dto.getProdEquipment())) {
            equipmentList.addAll(dto.getProdEquipment());
        }
        if (CollectionUtils.isNotEmpty(dto.getMonitEquipment())) {
            equipmentList.addAll(dto.getMonitEquipment());
        }
        if (CollectionUtils.isNotEmpty(equipmentList)) {
            equipmentList.forEach(entity -> {
                entity.setSupplierEnterpriseId(id);
                entity.setVersion(version);
                entity.setId(null);
            });
            this.equipment4Manager.saveBatch(equipmentList);
        }
    }

    private void processQualificationData(List<BizSupplierEnterpriseQualification4> list, Long version) {
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(entity -> {
                entity.setVersion(version);
                entity.setId(null);
            });
            this.qualification4Manager.saveBatch(list);
        }
    }

    private void processProductsPerformanceData(BizSupplierMainProductsPerformance4 entity, String id, Long version) {
        if (entity != null) {
            this.productsPerformance4Manager.fillModel(entity, id, version);
        }
    }

    private void processProcessPerformanceData(BizSupplierProductionProcessPerformance4 entity, String id, Long version) {
        if (entity != null) {
            this.processPerformance4Manager.fillModel(entity, id, version);
        }
    }

    private void getAllRelatedData(SupplierRegister4Vo vo, String id, Long version) {
        vo.setBasicInformation(this.getBasicInformation(id));
        vo.setEnterpriseCategory(this.getCategoryData(id));
        vo.setEnterpriseGrading(this.getGradingData(id));
        vo.setSuppliers(this.getSuppliersData(id));
        vo.setCategory(this.getMaterialCategoryData(id));
        vo.setOtherSpecialNotes(this.getOtherSpecialNotesData(id));
        Map<String, List<BizSupplierProductionInspectionEquipment4>> equipmentMap = this.getEquipmentData(id);
        vo.setProdEquipment(equipmentMap.getOrDefault("1", Collections.emptyList()));
        vo.setMonitEquipment(equipmentMap.getOrDefault("2", Collections.emptyList()));
        vo.setQualification(this.getQualificationData(version));
        vo.setPerformance(this.getProductsPerformanceData(id));
        vo.setProcessPerformance(this.getProcessPerformanceData(id));
    }

    private BizSupplierAccessBasicInformation4 getBasicInformation(String id) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BizSupplierAccessBasicInformation4::getSupplierEnterpriseId, (Object)id);
        return (BizSupplierAccessBasicInformation4)((Object)this.information4Manager.getOne((Wrapper)query));
    }

    private List<BizSupplierEnterpriseCategory4> getCategoryData(String id) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BizSupplierEnterpriseCategory4::getSupplierEnterpriseId, (Object)id);
        return this.category4Manager.list((Wrapper)query);
    }

    private List<BizSupplierEnterpriseGrading4> getGradingData(String id) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BizSupplierEnterpriseGrading4::getSupplierEnterpriseId, (Object)id);
        return this.grading4Manager.list((Wrapper)query);
    }

    private List<BizSupplierMainRawMaterialsSuppliers4> getSuppliersData(String id) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BizSupplierMainRawMaterialsSuppliers4::getSupplierEnterpriseId, (Object)id);
        return this.suppliers4Manager.list((Wrapper)query);
    }

    private List<BizSupplierMainSupplyMaterialCategory4> getMaterialCategoryData(String id) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BizSupplierMainSupplyMaterialCategory4::getSupplierEnterpriseId, (Object)id);
        return this.materialCategory4Manager.list((Wrapper)query);
    }

    private BizSupplierOtherSpecialNotes4 getOtherSpecialNotesData(String id) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BizSupplierOtherSpecialNotes4::getSupplierEnterpriseId, (Object)id);
        return (BizSupplierOtherSpecialNotes4)((Object)this.notes4Manager.getOne((Wrapper)query));
    }

    private Map<String, List<BizSupplierProductionInspectionEquipment4>> getEquipmentData(String id) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BizSupplierProductionInspectionEquipment4::getSupplierEnterpriseId, (Object)id);
        return this.equipment4Manager.list((Wrapper)query).stream().collect(Collectors.groupingBy(BizSupplierProductionInspectionEquipment4::getDeviceType));
    }

    private List<BizSupplierEnterpriseQualification4> getQualificationData(Long version) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BizDelModel::getVersion, (Object)version);
        return this.qualification4Manager.list((Wrapper)query);
    }

    private BizSupplierMainProductsPerformance4 getProductsPerformanceData(String id) {
        return this.productsPerformance4Manager.getModel(id);
    }

    private BizSupplierProductionProcessPerformance4 getProcessPerformanceData(String id) {
        return this.processPerformance4Manager.getModel(id);
    }

    private void deleteRelatedDataByCode(String id, String code, Long version) {
        if ("-1".equals(code)) {
            this.deleteAllModules(id, version);
        } else {
            this.deleteSingleModule(id, code, version);
        }
    }

    private void deleteAllModules(String id, Long version) {
        this.deleteBasicInformation(id);
        this.deleteCategoryData(id);
        this.deleteGradingData(id);
        this.deleteSuppliersData(id);
        this.deleteMaterialCategoryData(id);
        this.deleteOtherSpecialNotesData(id);
        this.deleteEquipmentData(id);
        this.deleteQualificationData(version);
        this.deleteProductsPerformanceData(id);
        this.deleteProcessPerformanceData(id);
    }

    private void deleteSingleModule(String id, String code, Long version) {
        switch (code) {
            case "1": {
                this.deleteBasicInformation(id);
                break;
            }
            case "2": {
                this.deleteCategoryData(id);
                break;
            }
            case "3": {
                this.deleteGradingData(id);
                break;
            }
            case "4": {
                this.deleteSuppliersData(id);
                break;
            }
            case "5": {
                this.deleteMaterialCategoryData(id);
                break;
            }
            case "6": {
                this.deleteOtherSpecialNotesData(id);
                break;
            }
            case "7": {
                this.deleteEquipmentData(id);
                break;
            }
            case "8": {
                this.deleteQualificationData(version);
                break;
            }
            case "9": {
                this.deleteProductsPerformanceData(id);
                break;
            }
            case "10": {
                this.deleteProcessPerformanceData(id);
            }
        }
    }

    private void deleteBasicInformation(String id) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BizSupplierAccessBasicInformation4::getSupplierEnterpriseId, (Object)id);
        this.information4Manager.remove((Wrapper)query);
    }

    private void deleteCategoryData(String id) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BizSupplierEnterpriseCategory4::getSupplierEnterpriseId, (Object)id);
        this.category4Manager.remove((Wrapper)query);
    }

    private void deleteGradingData(String id) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BizSupplierEnterpriseGrading4::getSupplierEnterpriseId, (Object)id);
        this.grading4Manager.remove((Wrapper)query);
    }

    private void deleteSuppliersData(String id) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BizSupplierMainRawMaterialsSuppliers4::getSupplierEnterpriseId, (Object)id);
        this.suppliers4Manager.remove((Wrapper)query);
    }

    private void deleteMaterialCategoryData(String id) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BizSupplierMainSupplyMaterialCategory4::getSupplierEnterpriseId, (Object)id);
        this.materialCategory4Manager.remove((Wrapper)query);
    }

    private void deleteOtherSpecialNotesData(String id) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BizSupplierOtherSpecialNotes4::getSupplierEnterpriseId, (Object)id);
        this.notes4Manager.remove((Wrapper)query);
    }

    private void deleteEquipmentData(String id) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BizSupplierProductionInspectionEquipment4::getSupplierEnterpriseId, (Object)id);
        this.equipment4Manager.remove((Wrapper)query);
    }

    private void deleteQualificationData(Long version) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BizDelModel::getVersion, (Object)version);
        this.qualification4Manager.remove((Wrapper)query);
    }

    private void deleteProductsPerformanceData(String id) {
    }

    private void deleteProcessPerformanceData(String id) {
    }
}

