/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.base.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.gyl.base.dao.BizSupplierQualificationDatabaseDao;
import com.artfess.gyl.base.manager.BizSupplierQualificationDatabaseManager;
import com.artfess.gyl.base.model.BizSupplierQualificationDatabase;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.http.util.Asserts;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizSupplierQualificationDatabaseManagerImpl
extends BaseManagerImpl<BizSupplierQualificationDatabaseDao, BizSupplierQualificationDatabase>
implements BizSupplierQualificationDatabaseManager {
    @Resource
    private FileManager fileManager;

    @Transactional(rollbackFor={Exception.class})
    public boolean save(BizSupplierQualificationDatabase entity) {
        boolean save;
        List<DefaultFile> files = entity.getFiles();
        Asserts.notNull(files, (String)"\u9700\u4e0a\u4f20\u7684\u8d44\u8d28\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        if (entity.getTimeLimit() == null) {
            entity.setTimeLimit(1);
        }
        if (!(save = super.save((Object)entity))) {
            return false;
        }
        List fileIds = files.stream().map(DefaultFile::getId).collect(Collectors.toList());
        this.fileManager.updateFileBizIdByIds(fileIds, entity.getId());
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean updateById(BizSupplierQualificationDatabase entity) {
        List<DefaultFile> files = entity.getFiles();
        Asserts.notNull(files, (String)"\u9700\u4e0a\u4f20\u7684\u8d44\u8d28\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        if (entity.getTimeLimit() == 1) {
            entity.setValidUntil(null);
        } else if (entity.getValidUntil() == null) {
            throw new ApplicationException("\u8bf7\u8f93\u5165\u6709\u6548\u622a\u6b62\u671f");
        }
        boolean update = super.updateById((Object)entity);
        if (!update) {
            return false;
        }
        List fileIds = files.stream().map(DefaultFile::getId).collect(Collectors.toList());
        this.fileManager.removeFileByBizId(entity.getId(), fileIds);
        this.fileManager.updateFileBizIdByIds(fileIds, entity.getId());
        return true;
    }

    @Transactional(readOnly=true)
    public BizSupplierQualificationDatabase getById(Serializable id) {
        List defaultFiles;
        BizSupplierQualificationDatabase entity = (BizSupplierQualificationDatabase)((Object)super.getById(id));
        if (entity != null && CollectionUtils.isNotEmpty((Collection)(defaultFiles = this.fileManager.queryFileByBizId(entity.getId())))) {
            entity.setFiles(defaultFiles);
        }
        return entity;
    }

    @Override
    public PageList<BizSupplierQualificationDatabase> queryByPage(QueryFilter<BizSupplierQualificationDatabase> queryFilter) {
        IPage<BizSupplierQualificationDatabase> iPage = ((BizSupplierQualificationDatabaseDao)this.baseMapper).queryByPage((IPage<BizSupplierQualificationDatabase>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizSupplierQualificationDatabase>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(iPage);
    }
}

