/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.form.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.feign.WorkflowFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.Base64;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.JAXBUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadMsgUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.ZipUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.bo.model.BoData;
import com.artfess.bo.model.BoDef;
import com.artfess.bo.model.BoEnt;
import com.artfess.bo.persistence.manager.BoDefManager;
import com.artfess.form.enums.FormType;
import com.artfess.form.model.Form;
import com.artfess.form.model.FormHistory;
import com.artfess.form.model.FormHistoryRecord;
import com.artfess.form.model.FormImportXml;
import com.artfess.form.model.FormMeta;
import com.artfess.form.model.FormXml;
import com.artfess.form.param.CopyFormVo;
import com.artfess.form.param.FormPreviewDataParam;
import com.artfess.form.param.GenerateExpandParam;
import com.artfess.form.persistence.manager.FormDataTemplateManager;
import com.artfess.form.persistence.manager.FormHistoryManager;
import com.artfess.form.persistence.manager.FormHistoryRecordManager;
import com.artfess.form.persistence.manager.FormManager;
import com.artfess.form.persistence.manager.FormMetaManager;
import com.artfess.form.util.JsoupUtil;
import com.artfess.form.vo.BpmFormVo;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/form/form/v1"})
@Api(tags={"\u8868\u5355\u7ba1\u7406"})
@ApiGroup(group={"group_form"})
public class FormController
extends BaseController<FormManager, Form> {
    @Resource
    FormHistoryManager bpmFormHistoryManager;
    @Resource
    WorkflowFeignService workflowFeignService;
    @Resource
    BoDefManager bODefManager;
    @Resource
    FormMetaManager formMetaManager;
    @Resource
    FormDataTemplateManager bpmDataTemplateManager;
    @Resource
    FormHistoryRecordManager formHistoryRecordManager;

    @PostMapping(value={"exportFormSub"})
    @ApiOperation(value="\u5bfc\u51fa", httpMethod="POST", notes="\u5bfc\u51fa")
    public void exportFormSub(@ApiParam(name="subDesc", value="\u5b50\u8868\u540d\u79f0") @RequestParam String subDesc, @RequestBody List<Map<String, String>> list, HttpServletResponse response) throws Exception {
        if (list.size() > 0) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            ArrayList maps = new ArrayList();
            LinkedHashMap<String, String> mapObj = new LinkedHashMap<String, String>();
            for (int i = 0; i < list.size(); ++i) {
                map.put(list.get(i).get("name"), list.get(i).get("desc"));
                mapObj.put(list.get(i).get("name"), "");
            }
            maps.add(mapObj);
            HSSFWorkbook book = ExcelUtil.exportExcel((String)subDesc, (int)24, map, maps);
            ExcelUtil.downloadExcel((HSSFWorkbook)book, (String)subDesc, (HttpServletResponse)response);
        }
    }

    @RequestMapping(value={"list"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u4efb\u52a1\u8868\u5355\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e \u4e3b\u7248\u672c", httpMethod="POST", notes="\u6d41\u7a0b\u4efb\u52a1\u8868\u5355\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<Form> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter, @ApiParam(name="formType", value="\u8868\u5355\u7c7b\u578b") @RequestParam Optional<String> formType, @ApiParam(name="status", value="\u662f\u5426\u53d1\u5e03") @RequestParam Optional<String> status, @ApiParam(name="pcFormKey", value="pc\u7aef\u8868\u5355key\uff0c\u67e5\u8be2\u624b\u673a\u8868\u5355\u65f6\u7528\u5230\uff0c\u4f1a\u67e5\u8be2\u548cpc\u8868\u5355bo\u5339\u914d\u7684\u8868\u5355") @RequestParam Optional<String> pcFormKey) throws Exception {
        if (StringUtil.isNotEmpty((String)formType.orElse(null))) {
            queryFilter.addFilter("formType", (Object)formType.get(), QueryOP.EQUAL, FieldRelation.AND, "isMain");
            queryFilter.addFilter("status", (Object)status.get(), QueryOP.EQUAL, FieldRelation.AND, "isMain");
            if ("mobile".equals(formType.get()) && StringUtil.isNotEmpty((String)pcFormKey.orElse(""))) {
                List<Map<String, Object>> forms = this.formMetaManager.getBoBindFormsByFormKey(pcFormKey.get());
                HashSet mbFormIds = new HashSet();
                if (BeanUtils.isNotEmpty(forms)) {
                    HashSet<String> pcFormBindBoIds = new HashSet<String>();
                    HashMap<String, HashSet<String>> formBoMap = new HashMap<String, HashSet<String>>();
                    for (Map<String, Object> form : forms) {
                        if (pcFormKey.get().equals(form.get("formKey"))) {
                            pcFormBindBoIds.add((String)form.get("boDefId"));
                        }
                        if (!"mobile".equals(form.get("formType"))) continue;
                        HashSet<String> formBos = (HashSet<String>)formBoMap.get(form.get("formKey"));
                        if (BeanUtils.isEmpty((Object)formBos)) {
                            formBos = new HashSet<String>();
                        }
                        formBos.add((String)form.get("boDefId"));
                        formBoMap.put((String)form.get("formKey"), formBos);
                    }
                    for (Map.Entry next : formBoMap.entrySet()) {
                        if (!pcFormBindBoIds.containsAll((Collection)next.getValue())) continue;
                        mbFormIds.add(next.getKey());
                    }
                }
                queryFilter.addFilter("form_key_", (Object)StringUtil.join(mbFormIds), QueryOP.IN, FieldRelation.AND, "isMain");
            }
        }
        queryFilter.addFilter("is_print_", (Object)"Y", QueryOP.NOT_EQUAL, FieldRelation.AND, "isMain");
        queryFilter.addFilter("is_main_", (Object)"Y", QueryOP.EQUAL, FieldRelation.AND, "isMain");
        IPage<Form> list = ((FormManager)this.baseService).getFormQueryList((QueryFilter<Form>)queryFilter);
        PageList pageList = new PageList(list);
        if (BeanUtils.isNotEmpty((Object)pageList.getRows())) {
            Set<String> allFormKeys = this.bpmDataTemplateManager.getAllFormKeys();
            for (Form bpmForm : pageList.getRows()) {
                if (!allFormKeys.contains(bpmForm.getFormKey())) continue;
                bpmForm.setBusDataTemplateCount((short)1);
            }
        }
        return pageList;
    }

    @RequestMapping(value={"formEdit"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u751f\u6210\u8868\u5355HTML", httpMethod="POST", notes="\u751f\u6210\u8868\u5355HTML")
    public Form edit(@ApiParam(name="defId", value="\u8868\u5355\u5143\u6570\u636eid") @RequestBody String defId, @ApiParam(name="formType", value="\u8868\u5355\u7c7b\u578b") @RequestBody String formType, @ApiParam(name="id", value="\u6d41\u7a0b\u4efb\u52a1\u8868\u5355Id") @RequestBody String id, @ApiParam(name="tableNames", value="\u4e3b\u6a21\u677f") @RequestBody String tableNames, @ApiParam(name="templateAlias", value="\u590d\u5408\u5b57\u6bb5\u6a21\u677f") @RequestBody String templateAlias) throws Exception {
        if (StringUtil.isEmpty((String)formType)) {
            formType = FormType.PC.value();
        }
        Form form = null;
        if (StringUtil.isNotEmpty((String)id)) {
            form = (Form)((FormManager)this.baseService).get((Serializable)((Object)id));
        } else {
            FormMeta formDef = (FormMeta)this.formMetaManager.get((Serializable)((Object)defId));
            form = new Form();
            form.setDefId(defId);
            form.setName(formDef.getName());
            form.setFormType(formType);
            form.setTypeName(formDef.getType());
            form.setTypeId(formDef.getTypeId());
            form.setIsMain('Y');
            form.setVersion(1);
            form.setStatus("draft");
            String html = ((FormManager)this.baseService).getHtml(defId, tableNames, templateAlias);
            html = JsoupUtil.prettyHtml(html);
            form.setFormHtml(html);
        }
        if (StringUtil.isNotEmpty((String)formType) && formType.equals(FormType.MOBILE.value())) {
            StringBuffer outHtml = new StringBuffer();
            outHtml.append("<div style=\"height: 100%;overflow: auto;\">");
            outHtml.append(form.getFormHtml());
            outHtml.append("</div>");
            form.setFormHtml(outHtml.toString());
        }
        return form;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u8868\u5355html\u5185\u5bb9", httpMethod="POST", notes="\u4fdd\u5b58\u8868\u5355html\u5185\u5bb9")
    public CommonResult save(@ApiParam(name="form", value="\u6d41\u7a0b\u4efb\u52a1\u8868\u5355 entity\u5bf9\u8c61") @RequestBody Form form) throws Exception {
        if (StringUtil.isEmpty((String)form.getId())) {
            List<Form> bpmForm = ((FormManager)this.baseService).getByFormKey(form.getFormKey());
            if (BeanUtils.isNotEmpty(bpmForm)) {
                throw new RuntimeException("KEY\u3010" + form.getFormKey() + "\u3011\u5bf9\u5e94\u7684\u8868\u5355\u5df2\u5b58\u5728");
            }
            form.setId(UniqueIdUtil.getSuid());
            ((FormManager)this.baseService).create((Model)form);
        } else {
            ((FormManager)this.baseService).update((Model)form);
        }
        FormHistory bpmFormDefHi = new FormHistory(form);
        this.bpmFormHistoryManager.create((Model)bpmFormDefHi);
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f", null);
    }

    @RequestMapping(value={"saveDesign"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u8868\u5355html\u5185\u5bb9", httpMethod="POST", notes="\u4fdd\u5b58\u8868\u5355html\u5185\u5bb9")
    public CommonResult saveDesign(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String formData = FileUtil.inputStream2String((InputStream)request.getInputStream());
        ((FormManager)this.baseService).saveDesign(formData);
        String msg = "\u4fdd\u5b58\u6210\u529f";
        return new CommonResult(true, msg, null);
    }

    @RequestMapping(value={"saveFormDesign"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u8868\u5355html\u5185\u5bb9", httpMethod="POST", notes="\u4fdd\u5b58\u8868\u5355html\u5185\u5bb9")
    public CommonResult saveFormDesign(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String formData = FileUtil.inputStream2String((InputStream)request.getInputStream());
        ((FormManager)this.baseService).saveDesign(formData);
        String msg = "\u4fdd\u5b58\u6210\u529f";
        return new CommonResult(true, msg, null);
    }

    @RequestMapping(value={"saveForm"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u8868\u5355\u5185\u5bb9", httpMethod="POST", notes="\u4fdd\u5b58\u8868\u5355\u5185\u5bb9")
    public CommonResult saveForm(@ApiParam(name="bpmFormVo", value="\u8868\u5355\u8bbe\u8ba1\u6570\u636e") @RequestBody BpmFormVo bpmFormVo) throws Exception {
        ((FormManager)this.baseService).saveFormDef(bpmFormVo);
        String msg = "\u751f\u6210\u8868\u5355\u6210\u529f";
        if ("newForm".equals(bpmFormVo.getNewForm())) {
            msg = "\u53d1\u5e03\u65b0\u7248\u672c\u6210\u529f";
        }
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put("rev", bpmFormVo.getBpmFormDef().getRev());
        value.put("formData", (Object)bpmFormVo.getBpmForm());
        return new CommonResult(true, msg, value);
    }

    @RequestMapping(value={"pcForm2MobileForm"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="pc\u8868\u5355\u8f6c\u6362\u4e3a\u624b\u673a\u8868\u5355", httpMethod="POST", notes="pc\u8868\u5355\u8f6c\u6362\u4e3a\u624b\u673a\u8868\u5355")
    public CommonResult pcForm2MobileForm(@ApiParam(name="formId", value="\u8868\u5355\u8bbe\u8ba1\u6570\u636e") @RequestParam String formId) throws Exception {
        ((FormManager)this.baseService).pcForm2MobileForm(formId);
        String msg = "\u751f\u6210\u624b\u673a\u8868\u5355\u6210\u529f,\u8bf7\u5728\u624b\u673a\u8868\u5355\u4e2d\u67e5\u770b";
        return new CommonResult(true, msg, null);
    }

    @RequestMapping(value={"generateFrom"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u91cd\u65b0\u751f\u6210\u8868\u5355", httpMethod="POST", notes="\u91cd\u65b0\u751f\u6210\u8868\u5355")
    public CommonResult generateFrom(@ApiParam(name="bpmFormVo", value="\u8868\u5355\u8bbe\u8ba1\u6570\u636e") @RequestBody BpmFormVo bpmFormVo) throws Exception {
        ((FormManager)this.baseService).generateFrom(bpmFormVo);
        String msg = "\u4fdd\u5b58\u6210\u529f";
        return new CommonResult(true, msg, null);
    }

    @RequestMapping(value={"getBpmFormById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u83b7\u53d6form\u6570\u636e", httpMethod="GET", notes="\u6839\u636e\u83b7\u53d6form\u6570\u636e")
    public BpmFormVo generateFrom(@ApiParam(name="bpmForm", value="\u8868\u5355\u6570\u636e") @RequestParam String id, @ApiParam(name="bpmFormDef", value="\u8868\u5355\u8bbe\u8ba1\u6570\u636e") @RequestParam String defId) throws Exception {
        Form bpmForm = (Form)((FormManager)this.baseService).get((Serializable)((Object)id));
        FormMeta bpmFormDef = (FormMeta)this.formMetaManager.get((Serializable)((Object)defId));
        BpmFormVo bpmFormVo = new BpmFormVo();
        bpmFormVo.setBpmForm(bpmForm);
        bpmFormVo.setBpmFormDef(bpmFormDef);
        return bpmFormVo;
    }

    @RequestMapping(value={"saveFormJs"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u66f4\u65b0\u8868\u5355\u7684\u81ea\u5b9a\u4e49\u811a\u672c", httpMethod="POST", notes="\u66f4\u65b0\u8868\u5355\u7684\u81ea\u5b9a\u4e49\u811a\u672c")
    public CommonResult<String> saveFormJs(@ApiParam(name="map", value="\u66f4\u65b0\u6570\u636e") @RequestBody Map<String, Object> map) throws Exception {
        String diyJs = "";
        String formHtml = "";
        String formExpand = "";
        if (BeanUtils.isNotEmpty((Object)map.get("diyJs"))) {
            diyJs = map.get("diyJs").toString();
        }
        if (BeanUtils.isNotEmpty((Object)map.get("formHtml"))) {
            formHtml = Base64.getFromBase64((String)map.get("formHtml").toString());
        }
        if (BeanUtils.isNotEmpty((Object)map.get("formExpand"))) {
            formExpand = Base64.getFromBase64((String)map.get("formExpand").toString());
        }
        CommonResult<String> str = ((FormManager)this.baseService).saveFormJs(map.get("formId").toString(), diyJs, formHtml, formExpand);
        return str;
    }

    @RequestMapping(value={"saveCopy"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u590d\u5236\u8868\u5355\u4fe1\u606f", httpMethod="POST", notes="\u590d\u5236\u8868\u5355\u4fe1\u606f")
    public CommonResult saveCopy(@ApiParam(name="form", value="\u8868\u5355\u5143\u6570\u636e\u5bf9\u8c61") @RequestBody Form form) throws Exception {
        Form newForm = (Form)((FormManager)this.baseService).get((Serializable)((Object)form.getId()));
        String formDefId = newForm.getDefId();
        String formKey = form.getFormKey();
        String formName = form.getName();
        String typeId = form.getTypeId();
        String typeName = form.getTypeName();
        String userId = ContextUtil.getCurrentUserId();
        String groupId = ContextUtil.getCurrentGroupId();
        Date data = new Date();
        if (((FormManager)this.baseService).getByFormKey(formKey) == null) {
            throw new RuntimeException("\u8868\u5355\u5df2\u7ecf\u5b58\u5728\uff01key:" + formKey);
        }
        FormMeta bpmFormDef = (FormMeta)this.formMetaManager.get((Serializable)((Object)formDefId));
        String formNewDefId = UniqueIdUtil.getSuid();
        bpmFormDef.setId(formNewDefId);
        bpmFormDef.setKey(formKey);
        bpmFormDef.setName(formName);
        bpmFormDef.setTypeId(typeId);
        bpmFormDef.setType(typeName);
        bpmFormDef.setCreateBy(userId);
        bpmFormDef.setCreateOrgId(groupId);
        bpmFormDef.setRev(1);
        bpmFormDef.setUpdateBy(null);
        bpmFormDef.setUpdateTime(LocalDateTime.now());
        this.formMetaManager.create((Model)bpmFormDef);
        newForm.setId(UniqueIdUtil.getSuid());
        newForm.setDefId(formNewDefId);
        newForm.setFormKey(formKey);
        newForm.setName(formName);
        newForm.setTypeId(typeId);
        newForm.setTypeName(typeName);
        newForm.setStatus("draft");
        newForm.setVersion(1);
        newForm.setCreateBy(userId);
        newForm.setCreateOrgId(groupId);
        newForm.setUpdateTime(LocalDateTime.now());
        newForm.setUpdateBy(null);
        ((FormManager)this.baseService).create((Model)newForm);
        return new CommonResult(true, "\u590d\u5236\u8868\u5355\u6210\u529f", null);
    }

    @RequestMapping(value={"savePrintTemplate"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u8868\u5355\u6253\u5370\u6a21\u677f", httpMethod="POST", notes="\u6dfb\u52a0\u8868\u5355\u6253\u5370\u6a21\u677f")
    public CommonResult<String> savePrintTemplate(@ApiParam(name="form", value="\u8868\u5355\u5143\u6570\u636e\u5bf9\u8c61") @RequestBody Form form) throws Exception {
        return ((FormManager)this.baseService).savePrintTemplate(form);
    }

    @RequestMapping(value={"checkKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u68c0\u67e5\u522b\u540d\u662f\u5426\u5b58\u5728", httpMethod="GET", notes="\u68c0\u67e5\u522b\u540d\u662f\u5426\u5b58\u5728")
    public boolean checkKey(@ApiParam(name="key", value="\u8868\u5355key") @RequestParam String key) throws Exception {
        List<Form> bpmForm = ((FormManager)this.baseService).getByFormKey(key);
        return bpmForm.size() > 0;
    }

    @RequestMapping(value={"checkPrintKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u68c0\u67e5\u8868\u5355\u6253\u5370\u6a21\u677f\u522b\u540d\u662f\u5426\u5b58\u5728", httpMethod="GET", notes="\u68c0\u67e5\u522b\u540d\u662f\u5426\u5b58\u5728")
    public boolean checkPrintKey(@ApiParam(name="key", value="\u8868\u5355key") @RequestParam String key) throws Exception {
        List<Form> bpmForm = ((FormManager)this.baseService).getPrintByFormKey(key);
        return bpmForm.size() > 0;
    }

    @GetMapping(value={"getFormHistoryRecord"})
    @ApiOperation(value="\u6839\u636e\u4e3b\u952eID\u67e5\u8be2\u8868\u5355HTML\u5185\u5bb9", httpMethod="GET", notes="\u6839\u636e\u4e3b\u952eID\u67e5\u8be2\u8868\u5355HTML\u5185\u5bb9")
    public FormHistoryRecord getFormHistoryRecord(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        return (FormHistoryRecord)this.formHistoryRecordManager.get((Serializable)((Object)id));
    }

    @RequestMapping(value={"updateFormHistoryRecord"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6062\u590d\u5230\u8868\u5355\u5386\u53f2\u6570\u636e", httpMethod="GET", notes="\u6062\u590d\u5230\u8868\u5355\u5386\u53f2\u6570\u636e")
    public CommonResult<String> updateFormHistoryRecord(@ApiParam(name="id", value="\u4e3b\u952eID") @RequestParam String id) throws Exception {
        FormHistoryRecord formHistoryRecord = (FormHistoryRecord)this.formHistoryRecordManager.get((Serializable)((Object)id));
        CommonResult<String> stringCommonResult = ((FormManager)this.baseService).updateFormHistoryRecord(formHistoryRecord.getFormId(), formHistoryRecord.getFormHtml(), formHistoryRecord.getFormExpand());
        return stringCommonResult;
    }

    @RequestMapping(value={"getFormHtmlByFormId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355ID\u67e5\u8be2\u8868\u5355HTML\u5185\u5bb9\uff08\u8868\u5355HTML\u6570\u636e\u5386\u53f2\u8bb0\u5f55\uff09", httpMethod="GET", notes="\u6839\u636e\u8868\u5355ID\u67e5\u8be2\u8868\u5355HTML\u5185\u5bb9\uff08\u8868\u5355HTML\u6570\u636e\u5386\u53f2\u8bb0\u5f55\uff09")
    public FormHistoryRecord getFormHtmlByFormId(@ApiParam(name="formId", value="\u8868\u5355ID") @RequestParam String formId) throws Exception {
        List<FormHistoryRecord> formHistoryRecord = this.formHistoryRecordManager.getFormHtmlByFormId(formId);
        return formHistoryRecord.get(0);
    }

    @RequestMapping(value={"formHistoryRecordlistJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355ID\u67e5\u8be2\u8868\u5355HTML\u5185\u5bb9(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)", httpMethod="POST", notes="\u6839\u636e\u8868\u5355ID\u67e5\u8be2\u8868\u5355HTML\u5185\u5bb9(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)")
    public PageList<FormHistoryRecord> formHistoryRecordlistJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.formHistoryRecordManager.query(queryFilter);
    }

    @DeleteMapping(value={"delFormHistoryRecord"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355ID\u67e5\u8be2\u8868\u5355HTML\u5185\u5bb9\u5220\u9664\u8bb0\u5f55", httpMethod="DELETE", notes="\u6839\u636e\u8868\u5355ID\u67e5\u8be2\u8868\u5355HTML\u5185\u5bb9\u5220\u9664\u8bb0\u5f55")
    public CommonResult<String> delFormHistoryRecord(@ApiParam(name="id", value="\u4e1a\u52a1\u4e3b\u952e") @RequestParam String id) throws Exception {
        this.formHistoryRecordManager.remove((Serializable)((Object)id));
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"previewDesignVue"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="Vue\u8868\u5355\u9884\u89c8", httpMethod="GET", notes="\u8868\u5355\u9884\u89c8")
    public Object previewDesignVue(@ApiParam(name="formId", value="\u8868\u5355id") @RequestParam String formId) throws Exception {
        return ((FormManager)this.baseService).getPreviewDesignVueData(formId);
    }

    @RequestMapping(value={"previewDesign"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8868\u5355\u9884\u89c8", httpMethod="POST", notes="\u8868\u5355\u9884\u89c8")
    public Object previewDesign(@ApiParam(name="param", value="\u8868\u5355\u9884\u89c8") @RequestBody FormPreviewDataParam param) throws Exception {
        return ((FormManager)this.baseService).getPreviewDesignData(param);
    }

    @RequestMapping(value={"listVersions"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u8868\u5355\u7684\u6240\u6709\u7248\u672c", httpMethod="POST", notes="\u67e5\u8be2\u8868\u5355\u7684\u6240\u6709\u7248\u672c")
    public PageList<Form> listVersions(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return ((FormManager)this.baseService).query(queryFilter);
    }

    @RequestMapping(value={"getFormById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355ID\u83b7\u53d6\u8868\u5355\u660e\u7ec6", httpMethod="GET", notes="\u6839\u636e\u8868\u5355ID\u83b7\u53d6\u8868\u5355\u660e\u7ec6")
    public Form getFormById(@ApiParam(name="id", value="\u8868\u5355ID") @RequestParam String id) throws Exception {
        Form bpmForm = (Form)((FormManager)this.baseService).get((Serializable)((Object)id));
        return bpmForm;
    }

    @RequestMapping(value={"preview"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8868\u5355\u4fe1\u606f\u660e\u7ec6", httpMethod="POST", notes="\u8868\u5355\u4fe1\u606f\u660e\u7ec6")
    public Form preview(@ApiParam(name="id", value="\u6d41\u7a0b\u4efb\u52a1\u8868\u5355 ID") @RequestBody String id, @ApiParam(name="formKey", value="\u6d41\u7a0b\u4efb\u52a1\u8868\u5355 KEY") @RequestBody String formKey, @ApiParam(name="formType", value="\u6d41\u7a0b\u4efb\u52a1\u8868\u5355\u7c7b\u578b") @RequestBody String formType, @ApiParam(name="formHtml", value=" \u8868\u5355\u8bbe\u8ba1\uff08HTML\u4ee3\u7801\uff09") @RequestBody String formHtml) throws Exception {
        if (StringUtil.isEmpty((String)formType)) {
            formType = FormType.PC.value();
        }
        if (StringUtil.isEmpty((String)id) && StringUtil.isNotEmpty((String)formKey)) {
            Form mainByFormKey = ((FormManager)this.baseService).getMainByFormKey(formKey);
            id = mainByFormKey.getId();
        }
        Form bpmForm = new Form();
        if (StringUtil.isNotEmpty((String)id)) {
            bpmForm = (Form)((FormManager)this.baseService).get((Serializable)((Object)id));
            formType = bpmForm.getFormType();
        }
        if (StringUtil.isNotEmpty((String)formHtml)) {
            bpmForm.setFormHtml(formHtml);
        }
        return bpmForm;
    }

    @RequestMapping(value={"getRight"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u6743\u9650", httpMethod="POST", notes="\u83b7\u53d6\u8868\u5355\u6743\u9650")
    public JsonNode getRight(@ApiParam(name="id", value="\u6d41\u7a0b\u4efb\u52a1\u8868\u5355 ID") @RequestBody String id, @ApiParam(name="defId", value="\u8868\u5355\u5143\u6570\u636eId") @RequestBody String defId, @ApiParam(name="formType", value="\u6d41\u7a0b\u4efb\u52a1\u8868\u5355\u7c7b\u578b") @RequestBody String formType) throws Exception {
        return ((FormManager)this.baseService).getRightData(id, defId, formType);
    }

    @RequestMapping(value={"getBoData"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355\u5143\u6570\u636eID\u83b7\u53d6bo\u6570\u636e", httpMethod="POST", notes="\u6839\u636e\u8868\u5355\u5143\u6570\u636eID\u83b7\u53d6bo\u6570\u636e")
    public ArrayNode getBoData(@ApiParam(name="defId", value="\u8868\u5355\u5143\u6570\u636eId") @RequestBody String defId) throws Exception {
        List<BoData> boDatas = this.formMetaManager.getBoDataByFormDefId(defId);
        ArrayNode arrayNode = JsonUtil.getMapper().createArrayNode();
        if (BeanUtils.isNotEmpty(boDatas)) {
            arrayNode = JsonUtil.listToArrayNode(boDatas);
        }
        return arrayNode;
    }

    @RequestMapping(value={"getBoJsonByFormKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355key\u83b7\u53d6boJosn\u6570\u636e", httpMethod="GET", notes="\u6839\u636e\u8868\u5355key\u83b7\u53d6boJosn\u6570\u636e")
    public ArrayNode getBoJsonByFormKey(@ApiParam(name="formkey", value="\u8868\u5355key", required=true) @RequestParam String formkey) throws Exception {
        FormMeta formDef = this.formMetaManager.getByKey(formkey);
        ArrayNode arrayNode = JsonUtil.getMapper().createArrayNode();
        if (BeanUtils.isNotEmpty((Object)((Object)formDef))) {
            List<String> boDefCodes = this.formMetaManager.getBOCodeByFormId(formDef.getId());
            for (String defCode : boDefCodes) {
                ObjectNode boJson = this.bODefManager.getBOJsonByBoDefCode(defCode);
                arrayNode.add((JsonNode)boJson);
            }
        }
        return arrayNode;
    }

    @RequestMapping(value={"getBOCodes"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355id\u83b7\u53d6\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801", httpMethod="GET", notes="\u6839\u636e\u8868\u5355id\u83b7\u53d6\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801")
    public List<String> getBOCodes(@ApiParam(name="formId", value="\u8868\u5355\u5143\u6570\u636eId") @RequestParam String formId) throws Exception {
        return this.formMetaManager.getBOCodeByFormId(formId);
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u8868\u5355\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u8868\u5355\u8bb0\u5f55")
    public CommonResult remove(@ApiParam(name="ids", value="\u6d41\u7a0b\u4efb\u52a1\u8868\u5355ID!\u591a\u4e2aID\u7528,\u5206\u5272") @RequestParam(required=true) String ids) throws Exception {
        String bpmNames;
        String[] aryIds = null;
        if (!StringUtil.isEmpty((String)ids)) {
            aryIds = ids.split(",");
        }
        if (StringUtil.isEmpty((String)(bpmNames = this.checkBpmForm(aryIds)))) {
            ((FormManager)this.baseService).remove(aryIds);
            return new CommonResult(true, "\u5220\u9664\u6d41\u7a0b\u4efb\u52a1\u8868\u5355\u6210\u529f", null);
        }
        String msg = "\u5220\u9664\u5931\u8d25\uff1a" + bpmNames;
        return new CommonResult(false, msg, null);
    }

    @RequestMapping(value={"removeVersions"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u975e\u4e3b\u7248\u672c\u7684\u8868\u5355\u7248\u672c", httpMethod="DELETE", notes="\u5220\u9664\u975e\u4e3b\u7248\u672c\u7684\u8868\u5355\u7248\u672c")
    public CommonResult removeVersions(@ApiParam(name="ids", value="\u6d41\u7a0b\u4efb\u52a1\u8868\u5355ID!\u591a\u4e2aID\u7528,\u5206\u5272") @RequestParam(required=true) String ids) throws Exception {
        try {
            String[] aryIds = null;
            if (!StringUtil.isEmpty((String)ids)) {
                aryIds = ids.split(",");
            }
            ((FormManager)this.baseService).removeVersions(aryIds);
            return new CommonResult(true, "\u5220\u9664\u6d41\u7a0b\u4efb\u52a1\u8868\u5355\u6210\u529f", null);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5220\u9664\u5931\u8d25", null);
        }
    }

    public String checkBpmForm(String[] aryIds) {
        String msgs = "";
        for (String formId : aryIds) {
            Form bpmForm = (Form)((FormManager)this.baseService).get((Serializable)((Object)formId));
            List<String> boDefs = this.formMetaManager.getBODefIdByFormId(bpmForm.getDefId());
            for (String boDefId : boDefs) {
                CommonResult result;
                BoDef boDef = (BoDef)this.bODefManager.get((Serializable)((Object)boDefId));
                if (boDef == null || !((Boolean)(result = this.workflowFeignService.isBoBindFlowCheck(boDef.getAlias(), bpmForm.getFormKey())).getValue()).booleanValue()) continue;
                msgs = msgs + "\u300e\u8868\u5355\u3010" + bpmForm.getName() + "\u3011" + result.getMessage() + "\u300f";
            }
        }
        return msgs;
    }

    @RequestMapping(value={"chooseDesignTemplate"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u52a0\u8f7d\u7f16\u8f91\u5668\u8bbe\u8ba1\u6a21\u5f0f\u7684\u6a21\u677f\u5217\u8868", httpMethod="POST", notes="\u52a0\u8f7d\u7f16\u8f91\u5668\u8bbe\u8ba1\u6a21\u5f0f\u7684\u6a21\u677f\u5217\u8868")
    public Map chooseDesignTemplate(@ApiParam(name="subject", value="\u6807\u9898") @RequestBody String subject, @ApiParam(name="categoryId", value="") @RequestBody String categoryId, @ApiParam(name="formDesc", value="\u8868\u5355\u63cf\u8ff0") @RequestBody String formDesc, @ApiParam(name="isSimple", value="true\u5c06\u53ea\u5141\u8bb8\u9009\u62e9\u4e00\u884c") @RequestBody Boolean isSimple) throws Exception {
        return ((FormManager)this.baseService).getChooseDesignTemplate(subject, categoryId, formDesc, isSimple);
    }

    @RequestMapping(value={"genByTemplate"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6a21\u677f\u4ea7\u751fhtml\u3002", httpMethod="POST", notes="\u6839\u636e\u6a21\u677f\u4ea7\u751fhtml\u3002")
    public void genByTemplate(@ApiParam(name="formId", value="\u4e3b\u952e") @RequestBody String formId, @ApiParam(name="tableNames", value="\u4e3b\u6a21\u677f") @RequestBody String tableNames, @ApiParam(name="templateAlias", value="\u590d\u5408\u5b57\u6bb5\u6a21\u677f") @RequestBody String templateAlias, @ApiParam(name="formDefId", value="\u8868\u5355\u5143\u6570\u636eID") @RequestBody String formDefId, @ApiParam(name="formType", value="\u8868\u5355\u7c7b\u578b") @RequestBody String formType, HttpServletResponse response) throws Exception {
        ((FormManager)this.baseService).getGenByTemplate(formId, tableNames, templateAlias, formDefId, formType, response);
    }

    @RequestMapping(value={"newVersion"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355\u5b9a\u4e49id\u521b\u5efa\u65b0\u7684\u8868\u5355\u7248\u672c", httpMethod="POST", notes="\u6839\u636e\u8868\u5355\u5b9a\u4e49id\u521b\u5efa\u65b0\u7684\u8868\u5355\u7248\u672c")
    public CommonResult newVersion(@ApiParam(name="formId", value="\u8868\u5355ID") @RequestBody String formId) throws Exception {
        ((FormManager)this.baseService).newVersion(formId);
        return new CommonResult(true, "\u65b0\u5efa\u8868\u5355\u7248\u672c\u6210\u529f!", null);
    }

    @RequestMapping(value={"setDefaultVersion"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bbe\u7f6e\u9ed8\u8ba4\u7248\u672c", httpMethod="POST", notes="\u8bbe\u7f6e\u9ed8\u8ba4\u7248\u672c")
    public CommonResult setDefaultVersion(@ApiParam(name="id", value="\u8868\u5355ID") @RequestParam String id, @ApiParam(name="formKey", value="\u8868\u5355key") @RequestParam String formKey) throws Exception {
        ((FormManager)this.baseService).setDefaultVersion(id, formKey);
        ((FormManager)this.baseService).updatePermissionByKey(formKey);
        return new CommonResult(true, "\u8bbe\u7f6e\u9ed8\u8ba4\u7248\u672c\u6210\u529f", null);
    }

    @RequestMapping(value={"publish"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d1\u5e03\u8868\u5355", httpMethod="POST", notes="\u53d1\u5e03\u8868\u5355")
    public CommonResult publish(@ApiParam(name="formId", value="\u8868\u5355ID") @RequestParam String formId) throws Exception {
        ((FormManager)this.baseService).publish(formId);
        return new CommonResult(true, "\u53d1\u5e03\u7248\u672c\u6210\u529f", null);
    }

    @RequestMapping(value={"genByField"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u751f\u6210\u5b57\u6bb5\u7684html", httpMethod="POST", notes="\u751f\u6210\u5b57\u6bb5\u7684html")
    public void genByField(@ApiParam(name="defId", value="\u8868\u5355\u5143\u6570\u636eID") @RequestBody String defId, @ApiParam(name="attrId", value="BO\u5c5e\u6027ID") @RequestBody String attrId, @ApiParam(name="formType", value="\u8868\u5355\u7c7b\u578b") @RequestBody String formType, HttpServletResponse response) throws Exception {
        String html = ((FormManager)this.baseService).genByField(defId, attrId, formType);
        html = JsoupUtil.prettyHtml(html);
        PrintWriter out = response.getWriter();
        out.println(html);
    }

    @RequestMapping(value={"exportForm"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u8868\u5355xml", httpMethod="GET", notes="\u5bfc\u51fa\u8868\u5355xml")
    public void exportForm(HttpServletRequest request, HttpServletResponse response, @ApiParam(name="formIds", value="\u8868\u5355id", required=true) @RequestParam String formIds) throws Exception {
        response.setContentType("APPLICATION/OCTET-STREAM");
        if (BeanUtils.isNotEmpty((Object)formIds)) {
            String[] ids = formIds.split(",");
            List<String> idList = Arrays.asList(ids);
            Map<String, String> map = ((FormManager)this.baseService).exportForms(idList, true);
            String fileName = "ht_form_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmmss");
            HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, map, (String)fileName);
        }
    }

    @RequestMapping(value={"importSave"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8868\u5355\u9644\u4ef6\u4e0a\u4f20\u64cd\u4f5c\uff0c\u6839\u636e\u4f20\u5165\u7684\u6587\u4ef6id\u4ece\u7f13\u5b58\u4e2d\u53d6\u51faxml\u6587\u4ef6\u5bfc\u5165\uff0c\u5e76\u6e05\u9664\u7f13\u5b58", httpMethod="POST", notes="\u9644\u4ef6\u4e0a\u4f20\u64cd\u4f5c")
    public Object importSave(@ApiParam(name="confirmImport", value="\u786e\u8ba4\u5bfc\u5165", required=false) @RequestParam Optional<Boolean> confirmImport, @ApiParam(name="typeId", value="\u8868\u5355\u6807\u8bc6", required=false) @RequestParam Optional<String> typeId, @ApiParam(name="cacheFileId", value="\u7f13\u5b58\u7684\u6d41\u7a0b\u6587\u4ef6id", required=false) @RequestParam Optional<String> cacheFileId) throws Exception {
        CommonResult<String> message = new CommonResult<String>("\u5bfc\u5165\u6210\u529f");
        if (confirmImport.orElse(false).booleanValue()) {
            String byKey = ((FormManager)this.baseService).getImportFileFromCache(cacheFileId.get());
            if (StringUtil.isEmpty((String)byKey)) {
                return new CommonResult("\u5bfc\u5165\u7684\u6587\u4ef6\u5df2\u7ecf\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\u3002");
            }
            ObjectNode objectNode = (ObjectNode)JsonUtil.toJsonNode((String)byKey);
            message = ((FormManager)this.baseService).importForms(objectNode, typeId.orElse(""));
            if (message.getState().booleanValue()) {
                String msg;
                LinkedHashSet entDefsAdded = ThreadMsgUtil.getMapMsg2((String)"entDefsAdded");
                LinkedHashSet entDefsSkipped = ThreadMsgUtil.getMapMsg2((String)"entDefsSkipped");
                LinkedHashSet entsAdded = ThreadMsgUtil.getMapMsg2((String)"entsAdded");
                LinkedHashSet entsSkipped = ThreadMsgUtil.getMapMsg2((String)"entsSkipped");
                LinkedHashSet formDefsUpdated = ThreadMsgUtil.getMapMsg2((String)"formDefsUpdated");
                LinkedHashSet formDefsAdded = ThreadMsgUtil.getMapMsg2((String)"formDefsAdded");
                LinkedHashSet formsUpdatedReleased = ThreadMsgUtil.getMapMsg2((String)"formsUpdatedReleased");
                LinkedHashSet formsUpdated = ThreadMsgUtil.getMapMsg2((String)"formsUpdated");
                LinkedHashSet formsAddedPublished = ThreadMsgUtil.getMapMsg2((String)"formsAddedPublished");
                StringBuilder sb = new StringBuilder();
                if (BeanUtils.isNotEmpty((Object)entDefsSkipped)) {
                    sb.append("<div style='font-weight:bold;'>\u4ee5\u4e0b\u5b9e\u4f53\u5b9a\u4e49\uff0c\u5df2\u5b58\u5728\u6545\u8df3\u8fc7\uff1a</div>");
                    msg = String.format("%s", String.join((CharSequence)"", entDefsSkipped));
                    sb.append(msg);
                }
                if (BeanUtils.isNotEmpty((Object)entsSkipped)) {
                    sb.append("<div style='font-weight:bold;'>\u4ee5\u4e0b\u5b9e\u4f53\uff0c\u5df2\u5b58\u5728\u6545\u8df3\u8fc7\uff0c\u6570\u636e\u5e93\u5b57\u6bb5\u7ea7\u522b\u5dee\u5f02\u8bf7\u624b\u52a8\u9010\u4e2a\u66f4\u65b0\uff1a</div>");
                    msg = String.format("%s", String.join((CharSequence)"", entsSkipped));
                    sb.append(msg);
                }
                if (BeanUtils.isNotEmpty((Object)formDefsUpdated)) {
                    sb.append("<div style='font-weight:bold;'>\u4ee5\u4e0b\u8868\u5355\u5b9a\u4e49\uff0c\u5df2\u7ecf\u5b58\u5728\uff0c\u66f4\u65b0\u6210\u529f\uff1a</div>");
                    msg = String.format("%s", String.join((CharSequence)"", formDefsUpdated));
                    sb.append(msg);
                }
                if (BeanUtils.isNotEmpty((Object)formsUpdatedReleased)) {
                    sb.append("<div style='font-weight:bold;'>\u4ee5\u4e0b\u8868\u5355\uff0c\u5df2\u7ecf\u5b58\u5728\uff0c\u66f4\u65b0\u5e76\u53d1\u5e03\u65b0\u7248\u672c\u6210\u529f\uff1a</div>");
                    msg = String.format("%s", String.join((CharSequence)"", formsUpdatedReleased));
                    sb.append(msg);
                }
                if (BeanUtils.isNotEmpty((Object)formsUpdated)) {
                    sb.append("<div style='font-weight:bold;'>\u4ee5\u4e0b\u8868\u5355\uff0c\u5df2\u7ecf\u5b58\u5728\uff0c\u66f4\u65b0\u7248\u672c\u6210\u529f\uff1a</div>");
                    msg = String.format("%s", String.join((CharSequence)"", formsUpdated));
                    sb.append(msg);
                }
                if (BeanUtils.isNotEmpty((Object)formsAddedPublished)) {
                    sb.append("<div style='font-weight:bold;'>\u4ee5\u4e0b\u8868\u5355\uff0c\u5bfc\u5165\u5e76\u53d1\u5e03\u6210\u529f\uff1a</div>");
                    msg = String.format("%s", String.join((CharSequence)"", formsAddedPublished));
                    sb.append(msg);
                }
                if (StringUtil.isNotEmpty((String)(msg = sb.toString()))) {
                    message.setValue((Object)msg);
                }
            }
        }
        ((FormManager)this.baseService).delImportFileFromCache(cacheFileId.orElse(""));
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"importCheck"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8868\u5355\u5bfc\u5165\u524d\u6821\u9a8c", httpMethod="POST", notes="\u8868\u5355\u5bfc\u5165\u524d\u6821\u9a8c")
    public CommonResult<String> importCheck(MultipartHttpServletRequest request, HttpServletResponse response, @ApiParam(name="typeId", value="\u8868\u5355\u6807\u8bc6", required=false) @RequestParam Optional<String> typeId) throws Exception {
        Map fileMaps = request.getFileMap();
        Iterator it = fileMaps.values().iterator();
        ArrayList files = new ArrayList();
        while (it.hasNext()) {
            files.add(it.next());
        }
        MultipartFile fileLoad = (MultipartFile)files.get(0);
        String unZipFilePath = "";
        CommonResult message = null;
        try {
            String fileDir = StringUtil.substringBeforeLast((String)fileLoad.getOriginalFilename().toString(), (String)".");
            String rootRealPath = (FileUtil.getIoTmpdir() + "attachFiles/unZip/").replace("/", File.separator);
            File folder = new File(rootRealPath);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            ZipUtil.unZipFile((MultipartFile)fileLoad, (String)rootRealPath);
            unZipFilePath = rootRealPath + File.separator + fileDir;
            String formXmlStr = FileUtil.readFile((String)(unZipFilePath + File.separator + "form.xml"));
            String boXmlStr = FileUtil.readFile((String)(unZipFilePath + File.separator + "bo.xml"));
            if (StringUtils.isEmpty((String)formXmlStr)) {
                throw new Exception("\u5bfc\u5165\u7684\u672a\u6309\u6307\u5b9a\u7684\u683c\u5f0f");
            }
            ObjectNode obj = JsonUtil.getMapper().createObjectNode();
            obj.put("formXmlStr", formXmlStr);
            obj.put("boXmlStr", boXmlStr);
            FormImportXml formImportXml = (FormImportXml)JAXBUtil.unmarshall((String)formXmlStr, FormImportXml.class);
            List<FormXml> formXmlList = formImportXml.getFormXmlList();
            ArrayList<String> names = new ArrayList<String>();
            for (FormXml formXml : formXmlList) {
                Form form = formXml.getBpmForm();
                Form oldForm = ((FormManager)this.baseService).getMainByFormKey(form.getFormKey());
                if (oldForm == null) continue;
                names.add(oldForm.getName() + "\uff08" + oldForm.getFormKey() + "\uff09");
            }
            if (BeanUtils.isEmpty(names)) {
                ((FormManager)this.baseService).importForms(obj, typeId.orElse(""));
                message = new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
            } else {
                String cacheFileId = UniqueIdUtil.getSuid();
                ((FormManager)this.baseService).putImportFileInCache(cacheFileId, JsonUtil.toJson((Object)obj));
                message = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff0c\u8868\u5355\u3010" + String.join((CharSequence)"\uff0c", names) + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u662f\u5426\u7ee7\u7eed\u4e3a\u5176\u65b0\u589e\u7248\u672c\uff1f", (Object)cacheFileId);
            }
        }
        catch (Exception e) {
            message = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25:" + e.getMessage() + ",\u4e0d\u652f\u6301\u5bfc\u5165");
        }
        finally {
            File boDir = new File(unZipFilePath);
            if (boDir.exists()) {
                FileUtil.deleteDir((File)boDir);
            }
        }
        return message;
    }

    @RequestMapping(value={"formDesign"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u5df2\u8bbe\u7f6e\u7684\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u8868\u5355\u5df2\u8bbe\u7f6e\u7684\u4fe1\u606f")
    public Object formDesign(@ApiParam(name="formId", value="\u8868\u5355ID") @RequestParam String formId) throws Exception {
        return ((FormManager)this.baseService).getFormDesign(formId);
    }

    @RequestMapping(value={"getSubEntsByFormKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7ec4\u4ef6\u522b\u540d\u83b7\u53d6\u6240\u6709\u5b50\u5b9e\u4f53\u3002", httpMethod="GET", notes="\u6839\u636e\u7ec4\u4ef6\u522b\u540d\u83b7\u53d6\u6240\u6709\u5b50\u5b9e\u4f53\u3002")
    public List<BoEnt> getSubEntsByFormKey(@ApiParam(name="formKey", value="\u7ec4\u4ef6key") @RequestParam String formKey) throws Exception {
        List<BoEnt> list = null;
        if (StringUtil.isNotEmpty((String)formKey)) {
            list = this.formMetaManager.getChildrenByFormKey(formKey);
            list.forEach(boEnt -> boEnt.setShowChildEntList(boEnt.getChildEntList()));
        }
        return list;
    }

    @RequestMapping(value={"getBindRelation"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u7ed1\u5b9a\u5173\u7cfb\u3002", httpMethod="GET", notes="\u6839\u636e\u7ec4\u4ef6\u522b\u540d\u83b7\u53d6\u6240\u6709\u5b50\u5b9e\u4f53\u3002")
    public Map<String, Object> getBindRelation(@ApiParam(name="defId", value="\u8868\u5355defId") @RequestParam String defId, @ApiParam(name="formKey", value="\u8868\u5355formKey") @RequestParam String formKey) throws Exception {
        return ((FormManager)this.baseService).getBindRelation(defId, formKey);
    }

    @RequestMapping(value={"getFormData"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u83b7\u53d6\u8868\u5355\u4fe1\u606f", httpMethod="GET", notes="\u53d6\u5f97\u6240\u6709\u7684\u8868\u5bf9\u8c61")
    public Map<String, Object> getFormData(@ApiParam(name="pcAlias", value="pc\u522b\u540d") @RequestParam(required=false) String pcAlias, @ApiParam(name="mobileAlias", value="mobile\u522b\u540d") @RequestParam(required=false) String mobileAlias) throws Exception {
        return ((FormManager)this.baseService).getFormData(pcAlias, mobileAlias);
    }

    @RequestMapping(value={"generateExpand"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u751f\u6210\u8868\u5355\u6a21\u677f\u6570\u636e", httpMethod="POST", notes="\u751f\u6210\u8868\u5355\u6a21\u677f\u6570\u636e")
    public CommonResult<String> generateExpand(@ApiParam(name="generateExpandParam", value="\u8868\u5355ID") @RequestBody GenerateExpandParam params) throws Exception {
        return ((FormManager)this.baseService).generateExpand(params);
    }

    @RequestMapping(value={"generateBoTreeData"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u751f\u6210\u8868\u5355bo\u6811\u7ed3\u6784\u6570\u636e", httpMethod="GET", notes="\u751f\u6210\u8868\u5355bo\u6811\u7ed3\u6784\u6570\u636e")
    public CommonResult<String> generateBoTreeData(@ApiParam(name="boDefIds", value="bo\u5b9a\u4e49id\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u5206\u9694") @RequestParam Optional<String> boDefIds, @ApiParam(name="formKey", value="\u8868\u5355key") @RequestParam Optional<String> formKey) throws Exception {
        String boIds = "";
        if (StringUtil.isNotEmpty((String)boDefIds.orElse(""))) {
            boIds = boDefIds.get();
        }
        if (StringUtil.isEmpty((String)boIds) && StringUtil.isNotEmpty((String)formKey.orElse(""))) {
            Form bpmForm = ((FormManager)this.baseService).getMainByFormKey(formKey.get());
            Assert.notNull((Object)((Object)bpmForm), (String)String.format("\u6839\u636eformKey:%s\u672a\u67e5\u8be2\u5230\u8868\u5355", formKey.get()));
            List<String> boDefs = this.formMetaManager.getBODefIdByFormId(bpmForm.getDefId());
            boIds = StringUtil.join(boDefs);
        }
        return ((FormManager)this.baseService).generateBoTreeData(boIds);
    }

    @RequestMapping(value={"getRelationList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8868\u5355\u5feb\u901f\u590d\u7528\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e \u4e3b\u7248\u672c", httpMethod="POST", notes="\u8868\u5355\u5feb\u901f\u590d\u7528\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<CopyFormVo> getRelationList(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter, @ApiParam(name="boDefIds", value="\u5173\u8054bo\u5b9a\u4e49\uff08\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u5206\u9694\uff09") @RequestParam String boDefIds, @ApiParam(name="id", value="\u8868\u5355id") @RequestParam Optional<String> id, @ApiParam(name="formType", value="\u8868\u5355\u7c7b\u578b") @RequestParam Optional<String> formType, @ApiParam(name="status", value="\u662f\u5426\u53d1\u5e03") @RequestParam Optional<String> status) throws Exception {
        if (StringUtil.isNotEmpty((String)formType.orElse(null))) {
            queryFilter.addFilter("form_type_", (Object)formType.get(), QueryOP.EQUAL, FieldRelation.AND, "isMain");
        }
        queryFilter.addFilter("is_print_", (Object)"Y", QueryOP.NOT_EQUAL, FieldRelation.AND, "isMain");
        queryFilter.addFilter("is_main_", (Object)"Y", QueryOP.EQUAL, FieldRelation.AND, "isMain");
        PageList pageList = new PageList();
        if (StringUtil.isNotEmpty((String)boDefIds)) {
            List<String> defIdList = Arrays.asList(boDefIds.split(","));
            List fDefIdList = this.bODefManager.getFormIdByBoDefIds(defIdList);
            if (StringUtil.isNotEmpty((String)id.orElse(""))) {
                queryFilter.addFilter("id_", (Object)id.get(), QueryOP.NOT_EQUAL, FieldRelation.AND, "isMain");
            }
            if (BeanUtils.isNotEmpty((Object)fDefIdList)) {
                queryFilter.addFilter("def_id_", (Object)fDefIdList, QueryOP.IN, FieldRelation.AND, "isMain");
                PageList formList = ((FormManager)this.baseService).query(queryFilter);
                if (BeanUtils.isNotEmpty((Object)formList.getRows()) && formList.getRows().size() > 0) {
                    for (Form form : formList.getRows()) {
                        CopyFormVo copyForm = (CopyFormVo)((Object)JsonUtil.toBean((String)JsonUtil.toJson((Object)((Object)form)), CopyFormVo.class));
                        List boDefs = this.bODefManager.getByFormId(form.getDefId());
                        ArrayList<String> boDefList = new ArrayList<String>();
                        for (BoDef boDef : boDefs) {
                            boDefList.add(boDef.getId());
                        }
                        copyForm.setBoDefList(boDefList);
                        if (BeanUtils.isEmpty((Object)pageList.getRows())) {
                            pageList.setRows(new ArrayList());
                        }
                        pageList.getRows().add(copyForm);
                    }
                    pageList.setPage(formList.getPage());
                    pageList.setPageSize(formList.getPageSize());
                    pageList.setTotal(formList.getTotal());
                }
            }
        }
        return pageList;
    }

    @RequestMapping(value={"getFormDefByKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u8868\u5355key\u83b7\u53d6\u8868\u5355\u5b9a\u4e49", httpMethod="GET", notes="\u901a\u8fc7\u8868\u5355key\u83b7\u53d6\u8868\u5355\u5b9a\u4e49")
    @ResponseBody
    public Form getFormDefinitionByKey(@ApiParam(name="formKey", value="\u8868\u5355key", required=true) @RequestParam String formKey) throws Exception {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"form_key_", (Object)formKey);
        queryWrapper.eq((Object)"is_main_", (Object)"Y");
        return (Form)((Object)((FormManager)this.baseService).getOne((Wrapper)queryWrapper, false));
    }
}

