/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.supplierAccess.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.gyl.base.manager.BizSupplierMaterialCategoryManager;
import com.artfess.gyl.supplierAccess.dao.BizSupplierAccessConfigurationDao;
import com.artfess.gyl.supplierAccess.dto.BizSupplierAccessConfigurationDto;
import com.artfess.gyl.supplierAccess.manager.BizSupplierAccessBasicManager;
import com.artfess.gyl.supplierAccess.manager.BizSupplierAccessConfigurationManager;
import com.artfess.gyl.supplierAccess.manager.BizSupplierAccessConfigurationMaterialCategoryManager;
import com.artfess.gyl.supplierAccess.manager.BizSupplierAccessProcessManager;
import com.artfess.gyl.supplierAccess.manager.BizSupplierAccessQualificationManager;
import com.artfess.gyl.supplierAccess.model.BizSupplierAccessBasic;
import com.artfess.gyl.supplierAccess.model.BizSupplierAccessConfiguration;
import com.artfess.gyl.supplierAccess.model.BizSupplierAccessConfigurationMaterialCategory;
import com.artfess.gyl.supplierAccess.model.BizSupplierAccessProcess;
import com.artfess.gyl.supplierAccess.model.BizSupplierAccessQualification;
import com.artfess.gyl.supplierAccess.vo.BizSupplierAccessConfigurationVo;
import com.artfess.gyl.thirdParty.manager.BizCategoryManager;
import com.artfess.gyl.thirdParty.manager.BizEnterpriseManager;
import com.artfess.gyl.thirdParty.model.BizCategory;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizSupplierAccessConfigurationManagerImpl
extends BaseManagerImpl<BizSupplierAccessConfigurationDao, BizSupplierAccessConfiguration>
implements BizSupplierAccessConfigurationManager {
    @Resource
    private BizSupplierAccessBasicManager supplierAccessBasicManager;
    @Resource
    private BizSupplierAccessProcessManager supplierAccessProcessManager;
    @Resource
    private BizSupplierAccessQualificationManager supplierAccessQualificationManager;
    @Resource
    private BizSupplierAccessConfigurationMaterialCategoryManager supplierAccessConfigurationMaterialCategoryManager;
    @Resource
    private BizSupplierMaterialCategoryManager supplierMaterialCategoryManager;
    @Resource
    private BizCategoryManager categoryManager;
    @Resource
    private BizEnterpriseManager enterpriseManager;
    @Resource
    private SysIdentityManager sysIdentityManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean saveModel(BizSupplierAccessConfigurationDto supplierAccessConfigurationDto) {
        Boolean result = false;
        BizSupplierAccessConfiguration supplierAccessConfiguration = BizSupplierAccessConfigurationDto.parse(supplierAccessConfigurationDto);
        this.validateModel(supplierAccessConfiguration);
        supplierAccessConfiguration.setIsDele("0");
        String currentOrgId = ContextUtil.getCurrentOrgId();
        String currentOrgCode = ContextUtil.getCurrentOrgCode();
        supplierAccessConfiguration.setEnterpriseId(currentOrgId);
        supplierAccessConfiguration.setEnterpriseCode(currentOrgCode);
        String code = this.sysIdentityManager.nextId("gyszrpzbm");
        supplierAccessConfiguration.setCode(code);
        result = this.save((Object)supplierAccessConfiguration);
        if (!result.booleanValue()) {
            return false;
        }
        String id = supplierAccessConfiguration.getId();
        supplierAccessConfigurationDto.setEnterpriseId(currentOrgId);
        supplierAccessConfigurationDto.setEnterpriseCode(currentOrgCode);
        supplierAccessConfigurationDto.setId(id);
        supplierAccessConfigurationDto.setCode(code);
        this.saveModelSub(supplierAccessConfigurationDto);
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveModelSub(BizSupplierAccessConfigurationDto supplierAccessConfigurationDto) {
        String supplierAccessId = supplierAccessConfigurationDto.getId();
        BizSupplierAccessBasic basic = supplierAccessConfigurationDto.getBasic();
        basic.setIsDele("0");
        basic.setSupplierAccessId(supplierAccessId);
        this.supplierAccessBasicManager.save((Object)basic);
        ArrayList qualificationList = new ArrayList();
        Map<String, List<BizSupplierAccessQualification>> qualificationMap = supplierAccessConfigurationDto.getQualificationMap();
        qualificationList.addAll(BeanUtils.isEmpty(qualificationMap.get("required")) ? new ArrayList() : (Collection)qualificationMap.get("required"));
        qualificationList.addAll(BeanUtils.isEmpty(qualificationMap.get("unnecessary")) ? new ArrayList() : (Collection)qualificationMap.get("unnecessary"));
        for (BizSupplierAccessQualification supplierAccessQualification : qualificationList) {
            supplierAccessQualification.setSupplierAccessId(supplierAccessId);
            supplierAccessQualification.setIsDele("0");
            supplierAccessQualification.setEnterpriseId(supplierAccessConfigurationDto.getEnterpriseId());
            supplierAccessQualification.setEnterpriseCode(supplierAccessConfigurationDto.getEnterpriseCode());
        }
        this.supplierAccessQualificationManager.saveBatch(qualificationList);
        BizSupplierAccessProcess process = supplierAccessConfigurationDto.getProcess();
        process.setSupplierAccessId(supplierAccessId);
        process.setIsDele("0");
        this.supplierAccessProcessManager.save((Object)process);
        List<String> gategoryIds = supplierAccessConfigurationDto.getGategoryIds();
        int count = this.supplierAccessConfigurationMaterialCategoryManager.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(BizSupplierAccessConfigurationMaterialCategory::getCategoryId, gategoryIds)).eq(BizSupplierAccessConfigurationMaterialCategory::getIsDele, (Object)"0"));
        if (count > 0) {
            throw new ApplicationException("\u4e00\u4e2a\u7269\u8d44\u53ea\u80fd\u751f\u6210\u4e00\u4e2a\u51c6\u5165\u6a21\u7248!");
        }
        ArrayList<BizSupplierAccessConfigurationMaterialCategory> categoryList = new ArrayList<BizSupplierAccessConfigurationMaterialCategory>();
        for (String gategoryId : gategoryIds) {
            BizSupplierAccessConfigurationMaterialCategory category = new BizSupplierAccessConfigurationMaterialCategory();
            category.setSupplierAccessId(supplierAccessId);
            category.setCategoryId(gategoryId);
            categoryList.add(category);
        }
        this.supplierAccessConfigurationMaterialCategoryManager.saveBatch(categoryList);
    }

    @Override
    public BizSupplierAccessConfigurationVo getInfo(String id) {
        BizSupplierAccessConfiguration supplierAccessConfiguration = (BizSupplierAccessConfiguration)this.get((Serializable)((Object)id));
        BizSupplierAccessConfigurationVo vo = new BizSupplierAccessConfigurationVo();
        vo.copy(supplierAccessConfiguration);
        BizSupplierAccessBasic basic = (BizSupplierAccessBasic)((Object)this.supplierAccessBasicManager.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizSupplierAccessBasic::getSupplierAccessId, (Object)id)).eq(BizSupplierAccessBasic::getIsDele, (Object)"0")));
        vo.setBasic(basic);
        List qualificationList = this.supplierAccessQualificationManager.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizSupplierAccessQualification::getSupplierAccessId, (Object)id)).eq(BizSupplierAccessQualification::getIsDele, (Object)"0"));
        Map<String, List<BizSupplierAccessQualification>> qualificationMap = qualificationList.stream().collect(Collectors.groupingBy(BizSupplierAccessQualification::getRequired));
        vo.setQualificationMap(qualificationMap);
        BizSupplierAccessProcess process = (BizSupplierAccessProcess)((Object)this.supplierAccessProcessManager.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizSupplierAccessProcess::getSupplierAccessId, (Object)id)).eq(BizSupplierAccessProcess::getIsDele, (Object)"0")));
        vo.setProcess(process);
        List categoryList = this.supplierAccessConfigurationMaterialCategoryManager.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizSupplierAccessConfigurationMaterialCategory::getSupplierAccessId, (Object)id)).eq(BizSupplierAccessConfigurationMaterialCategory::getIsDele, (Object)"0"));
        List<String> categoryIds = categoryList.stream().map(c -> c.getCategoryId()).collect(Collectors.toList());
        ArrayList<String> categoryNames = new ArrayList<String>();
        for (String categoryId : categoryIds) {
            BizCategory category = (BizCategory)this.categoryManager.get((Serializable)((Object)categoryId));
            if (!BeanUtils.isNotEmpty((Object)((Object)category))) continue;
            categoryNames.add(category.getCatName());
        }
        vo.setGategoryIds(categoryIds);
        vo.setGategoryNameList(categoryNames);
        return vo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean updateModel(BizSupplierAccessConfigurationDto supplierAccessConfigurationDto) {
        Boolean result = false;
        BizSupplierAccessConfiguration supplierAccessConfiguration = BizSupplierAccessConfigurationDto.parse(supplierAccessConfigurationDto);
        String supplierAccessId = supplierAccessConfiguration.getId();
        String currentOrgId = ContextUtil.getCurrentOrgId();
        String currentOrgCode = ContextUtil.getCurrentOrgCode();
        supplierAccessConfiguration.setEnterpriseId(currentOrgId);
        supplierAccessConfiguration.setEnterpriseCode(currentOrgCode);
        this.validateModel(supplierAccessConfiguration);
        result = this.updateById((Object)supplierAccessConfiguration);
        if (!result.booleanValue()) {
            return false;
        }
        this.batchDeleteSub(new String[]{supplierAccessId});
        this.saveModelSub(supplierAccessConfigurationDto);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean batchDelete(String[] ids) {
        this.batchDeleteSub(ids);
        return this.removeByIds(Arrays.asList(ids));
    }

    @Override
    public PageList<BizSupplierAccessConfigurationVo> queryPage(QueryFilter<BizSupplierAccessConfiguration> queryFilter) {
        IPage<BizSupplierAccessConfiguration> iPage = ((BizSupplierAccessConfigurationDao)this.baseMapper).queryPage((IPage<BizSupplierAccessConfiguration>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizSupplierAccessConfiguration>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        PageList resultPage = new PageList();
        PageList pageList = new PageList(iPage);
        resultPage.setPage(pageList.getPage());
        resultPage.setPageSize(pageList.getPageSize());
        resultPage.setTotal(pageList.getTotal());
        ArrayList<BizSupplierAccessConfigurationVo> resultList = new ArrayList<BizSupplierAccessConfigurationVo>();
        List rows = pageList.getRows();
        for (BizSupplierAccessConfiguration row : rows) {
            BizSupplierAccessConfigurationVo vo = new BizSupplierAccessConfigurationVo();
            vo.copy(row);
            resultList.add(vo);
        }
        resultPage.setRows(resultList);
        return resultPage;
    }

    @Override
    public List<BizSupplierAccessConfiguration> getListByEnterprise(QueryFilter<BizSupplierAccessConfiguration> queryFilter) {
        String currentOrgId = ContextUtil.getCurrentOrgId();
        queryFilter.addFilter("ENTERPRISE_ID_", (Object)currentOrgId, QueryOP.EQUAL);
        queryFilter.addFilter("STATUS_", (Object)"1", QueryOP.EQUAL);
        PageList pageList = this.query(queryFilter);
        return pageList.getRows();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean updateStatus(String id, String status) {
        int count = ((BizSupplierAccessConfigurationDao)this.baseMapper).updateStatus(id, status);
        return count > 0;
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchDeleteSub(String[] ids) {
        this.supplierAccessBasicManager.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(BizSupplierAccessBasic::getSupplierAccessId, (Object[])ids)).eq(BizSupplierAccessBasic::getIsDele, (Object)"0"));
        this.supplierAccessQualificationManager.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(BizSupplierAccessQualification::getSupplierAccessId, (Object[])ids)).eq(BizSupplierAccessQualification::getIsDele, (Object)"0"));
        this.supplierAccessProcessManager.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(BizSupplierAccessProcess::getSupplierAccessId, (Object[])ids)).eq(BizSupplierAccessProcess::getIsDele, (Object)"0"));
        this.supplierAccessConfigurationMaterialCategoryManager.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(BizSupplierAccessConfigurationMaterialCategory::getSupplierAccessId, (Object[])ids)).eq(BizSupplierAccessConfigurationMaterialCategory::getIsDele, (Object)"0"));
    }

    private void validateModel(BizSupplierAccessConfiguration supplierAccessConfiguration) {
        if (BeanUtils.isEmpty((Object)((Object)supplierAccessConfiguration))) {
            throw new ApplicationException("\u4fdd\u5b58\u7684\u5bf9\u8c61\u4e3a\u7a7a\uff01");
        }
        if (BeanUtils.isEmpty((Object)supplierAccessConfiguration.getName())) {
            throw new ApplicationException("\u914d\u7f6e\u540d\u79f0\u4e3a\u7a7a\uff01");
        }
    }
}

