/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataAccess.aop;

import com.artfess.base.util.AuthenticationUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.dataAccess.manager.DataAccessDefinedManager;
import com.artfess.uc.model.User;
import com.artfess.uc.util.ContextUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class DataAccessInterceptor
implements Interceptor {
    private Logger logger = LoggerFactory.getLogger(DataAccessInterceptor.class);
    @Autowired
    @Lazy
    DataAccessDefinedManager dataAccessDefinedManager;

    public Object intercept(Invocation invocation) throws Throwable {
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        MetaObject metaObject = MetaObject.forObject((Object)statementHandler, (ObjectFactory)SystemMetaObject.DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)SystemMetaObject.DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)new DefaultReflectorFactory());
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        BoundSql boundSql = statementHandler.getBoundSql();
        String sql = boundSql.getSql();
        metaObject.setValue("delegate.boundSql.sql", (Object)sql);
        SqlCommandType commondType = mappedStatement.getSqlCommandType();
        if (commondType.compareTo((Enum)SqlCommandType.SELECT) == 0) {
            return invocation.proceed();
        }
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes == null) {
            return invocation.proceed();
        }
        HttpServletRequest request = attributes.getRequest();
        String url = request.getAttribute("url").toString();
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            List<Map<String, Object>> maps = this.dataAccessDefinedManager.getDataAccessDefinedList(url);
            if (BeanUtils.isEmpty(maps)) {
                return invocation.proceed();
            }
            StringBuffer sqlWhere = new StringBuffer();
            for (Map<String, Object> item : maps) {
                String type = item.get("accessRangeType").toString();
                String accessRangeId = item.get("accessRangeId").toString();
                if ("1".indexOf(type) != -1) {
                    User user = ContextUtil.getCurrentUser();
                    if (sqlWhere != null && StringUtil.isNotEmpty((String)sqlWhere.toString())) {
                        sqlWhere.append(" or ");
                    }
                    sqlWhere.append(" CREATE_BY_ = '").append(user.getId()).append("'");
                    continue;
                }
                if ("2".indexOf(type) != -1) {
                    List<User> list = ContextUtil.getCurrentUserUnder();
                    accessRangeId = AuthenticationUtil.getCurrentUserId();
                    if (list != null && list.size() > 0) {
                        for (User user : list) {
                            if (user == null) continue;
                            accessRangeId = accessRangeId + "," + user.getId();
                        }
                    }
                    if (sqlWhere != null && StringUtil.isNotEmpty((String)sqlWhere.toString())) {
                        sqlWhere.append(" or ");
                    }
                    sqlWhere.append(" CREATE_BY_ in '( ").append(String.join((CharSequence)"','", accessRangeId)).append(")' ");
                    continue;
                }
                if ("3".indexOf(type) != -1) {
                    if (sqlWhere != null && StringUtil.isNotEmpty((String)sqlWhere.toString())) {
                        sqlWhere.append(" or ");
                    }
                    sqlWhere.append(" CREATE_ORG_ID_ in '( ").append(String.join((CharSequence)"','", accessRangeId)).append(")' ");
                    continue;
                }
                if ("4".indexOf(type) != -1) {
                    String subOrgIds = AuthenticationUtil.getCurrentUserId();
                    if (sqlWhere != null && StringUtil.isNotEmpty((String)sqlWhere.toString())) {
                        sqlWhere.append(" or ");
                    }
                    sqlWhere.append(" CREATE_ORG_ID_  in '( ").append(String.join((CharSequence)"','", subOrgIds)).append(")' ");
                    continue;
                }
                if ("5".indexOf(type) != -1) {
                    if (sqlWhere != null && StringUtil.isNotEmpty((String)sqlWhere.toString())) {
                        sqlWhere.append(" or ");
                    }
                    sqlWhere.append(" CREATE_ORG_ID_ in '( ").append(String.join((CharSequence)"','", accessRangeId)).append(")' ");
                    continue;
                }
                if ("6".indexOf(type) == -1) continue;
                if (sqlWhere != null && StringUtil.isNotEmpty((String)sqlWhere.toString())) {
                    sqlWhere.append(" or ");
                }
                sqlWhere.append(" CREATE_BY_ in '( ").append(String.join((CharSequence)"','", accessRangeId)).append(")' ");
            }
            if (sqlWhere != null && StringUtil.isNotEmpty((String)sqlWhere.toString())) {
                sql = sql + " and ( " + sqlWhere + ") ";
            }
            this.logger.debug(" custom sql " + sql);
            metaObject.setValue("delegate.boundSql.sql", (Object)sql);
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        this.logger.debug(" properties " + properties.toString());
    }

    private String getInSql(String field, Set<String> orgIds) {
        StringBuffer sb = new StringBuffer(" (");
        Iterator<String> iterator = orgIds.iterator();
        ArrayList<String> list = new ArrayList<String>();
        int i = 1;
        while (iterator.hasNext()) {
            String next = iterator.next();
            if (i > 500) {
                sb.append(field + " in (" + String.join((CharSequence)",", list) + ")");
                list = new ArrayList();
                i = 1;
            }
            list.add(next);
            ++i;
        }
        if (BeanUtils.isNotEmpty(list)) {
            sb.append(field + " in (" + String.join((CharSequence)",", list) + ")");
        }
        sb.append(")");
        return sb.toString();
    }
}

