/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.plugin.execution.procnotify.plugin;

import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.cmd.TaskFinishCmd;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.model.delegate.BpmDelegateExecution;
import com.artfess.bpm.api.model.process.inst.BpmProcessInstance;
import com.artfess.bpm.api.model.process.task.BpmTask;
import com.artfess.bpm.api.plugin.core.def.BpmExecutionPluginDef;
import com.artfess.bpm.api.plugin.core.session.BpmExecutionPluginSession;
import com.artfess.bpm.api.service.BpmCopyToService;
import com.artfess.bpm.plugin.core.runtime.AbstractBpmExecutionPlugin;
import com.artfess.bpm.plugin.core.util.UserAssignRuleQueryHelper;
import com.artfess.bpm.plugin.execution.procnotify.def.ProcNotifyPluginDef;
import com.artfess.bpm.plugin.task.tasknotify.def.model.NotifyItem;
import com.artfess.bpm.plugin.task.tasknotify.def.model.NotifyVo;
import com.artfess.bpm.plugin.task.tasknotify.helper.NotifyHelper;
import com.artfess.bpm.util.PortalDataUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;

public class ProcNotifyPlugin
extends AbstractBpmExecutionPlugin {
    private NotifyHelper notifyHelper = (NotifyHelper)AppUtil.getBean(NotifyHelper.class);
    @Resource
    private BpmCopyToService bpmCopyToService;

    @Override
    public Void execute(BpmExecutionPluginSession pluginSession, BpmExecutionPluginDef pluginDef) throws Exception {
        BpmDelegateExecution delegateExecution = pluginSession.getBpmDelegateExecution();
        Map<String, Object> variables = delegateExecution.getVariables();
        NotifyVo notifyVo = ((ProcNotifyPluginDef)pluginDef).getNotifyVoMap().get((Object)pluginSession.getEventType());
        if (notifyVo != null) {
            ActionCmd actionCmd = ContextThreadUtil.getActionCmd();
            BpmProcessInstance instance = (BpmProcessInstance)actionCmd.getTransitVars("processInstance");
            if (actionCmd instanceof TaskFinishCmd) {
                String baseUrl = PortalDataUtil.getPropertyByAlias("baseUrl");
                variables.put("baseUrl", baseUrl);
                variables.put("instId", actionCmd.getInstId());
                BpmTask task = (BpmTask)actionCmd.getTransitVars("bpmTask_");
                variables.put("taskId", task.getId());
                variables.put("taskSubject", task.getSubject());
                variables.put("nodeName", task.getName());
                variables.put("instSubject", task.getSubject());
                IUser user = ContextUtil.getCurrentUser();
                if (user != null) {
                    variables.put("sender", user.getFullname());
                    variables.put("delegate", user.getFullname());
                    variables.put("agent", user.getFullname());
                }
                String cause = ((TaskFinishCmd)actionCmd).getApprovalOpinion();
                variables.put("cause", cause);
            }
            for (NotifyItem notifyItem : notifyVo.getNotifyItemList()) {
                List<IUser> toUsers = UserAssignRuleQueryHelper.queryUsersWithExtract(notifyItem.getUserAssignRules(), variables);
                if (BeanUtils.isEmpty(toUsers)) continue;
                this.bpmCopyToService.copyTo(toUsers, instance, delegateExecution.getNodeId());
                this.notifyHelper.notify(toUsers, notifyItem.getMsgTypes(), "processEnd", variables);
            }
        }
        return null;
    }
}

