/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.base.manager.impl;

import com.artfess.base.entity.BizDelModel;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.gyl.base.dao.BizEnterpriseBusinessLicenseDao;
import com.artfess.gyl.base.manager.BizEnterpriseBusinessLicenseManager;
import com.artfess.gyl.base.model.BizEnterpriseBusinessLicense;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizEnterpriseBusinessLicenseManagerImpl
extends BaseManagerImpl<BizEnterpriseBusinessLicenseDao, BizEnterpriseBusinessLicense>
implements BizEnterpriseBusinessLicenseManager {
    @Resource
    private FileManager fileManager;

    @Transactional(rollbackFor={Exception.class})
    public boolean save(BizEnterpriseBusinessLicense entity) {
        entity.setEnterpriseId(ContextUtil.getCurrentOrgId());
        entity.setEnterpriseCode(ContextUtil.getCurrentOrgCode());
        entity.setEnterpriseName(ContextUtil.getCurrentOrgName());
        if (!super.save((Object)entity)) {
            return false;
        }
        List<DefaultFile> files = entity.getFiles();
        if (files != null) {
            List fileIds = files.stream().map(DefaultFile::getId).collect(Collectors.toList());
            this.fileManager.updateFileBizIdByIds(fileIds, entity.getId());
        }
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean updateById(BizEnterpriseBusinessLicense entity) {
        if (entity.getTimeLimit() != null && entity.getTimeLimit() == 1) {
            entity.setSrartBusinessTerm(null);
            entity.setEndBusinessTerm(null);
        }
        entity.setEnterpriseId(ContextUtil.getCurrentOrgId());
        entity.setEnterpriseCode(ContextUtil.getCurrentOrgCode());
        entity.setEnterpriseName(ContextUtil.getCurrentOrgName());
        if (!super.updateById((Object)entity)) {
            return false;
        }
        List<DefaultFile> files = entity.getFiles();
        String id = entity.getId();
        if (files != null) {
            List fileIds = files.stream().map(DefaultFile::getId).collect(Collectors.toList());
            this.fileManager.removeFileByBizId(id, fileIds);
            this.fileManager.updateFileBizIdByIds(fileIds, id);
        } else {
            this.fileManager.removeFileByBizId(id, null);
        }
        return true;
    }

    @Override
    public PageList<BizEnterpriseBusinessLicense> queryBySupplierVersion(QueryFilter<BizEnterpriseBusinessLicense> queryFilter) {
        queryFilter.addFilter("i.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("se.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<BizEnterpriseBusinessLicense> iPage = ((BizEnterpriseBusinessLicenseDao)this.baseMapper).queryBySupplierVersion((IPage<BizEnterpriseBusinessLicense>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizEnterpriseBusinessLicense>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(iPage);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BizEnterpriseBusinessLicense getModelByOrgId(String orgId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BizEnterpriseBusinessLicense::getEnterpriseId, (Object)orgId);
        wrapper.orderByDesc(BizDelModel::getVersion);
        wrapper.last("limit 1");
        BizEnterpriseBusinessLicense entity = (BizEnterpriseBusinessLicense)((Object)super.getOne((Wrapper)wrapper));
        if (entity == null) {
            return null;
        }
        List files = this.fileManager.queryFileByBizId(entity.getId());
        entity.setFiles(files);
        return entity;
    }

    @Transactional(readOnly=true)
    public BizEnterpriseBusinessLicense getById(Serializable id) {
        BizEnterpriseBusinessLicense entity = (BizEnterpriseBusinessLicense)((Object)super.getById(id));
        if (entity == null) {
            return null;
        }
        List files = this.fileManager.queryFileByBizId(entity.getId());
        entity.setFiles(files);
        return entity;
    }
}

