/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.supplierApply4.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.gyl.supplierApply.manager.BizSupplierEnterpriseManager;
import com.artfess.gyl.supplierApply.model.BizSupplierEnterprise;
import com.artfess.gyl.supplierApply4.dao.BizSupplierEnterpriseChangeLogDao;
import com.artfess.gyl.supplierApply4.dto.ReviewDTO;
import com.artfess.gyl.supplierApply4.dto.SupplierChangeDTO;
import com.artfess.gyl.supplierApply4.dto.SupplierRegister4DTO;
import com.artfess.gyl.supplierApply4.manager.BizSupplierEnterpriseAccessApprovalRecord3Manager;
import com.artfess.gyl.supplierApply4.manager.BizSupplierEnterpriseChangeLogManager;
import com.artfess.gyl.supplierApply4.manager.BizSupplierEnterpriseTemporaryChangeManager;
import com.artfess.gyl.supplierApply4.model.BizSupplierEnterpriseAccessApprovalRecord3;
import com.artfess.gyl.supplierApply4.model.BizSupplierEnterpriseChangeLog;
import com.artfess.gyl.supplierApply4.tool.SupplierAsyncProcessor;
import com.artfess.gyl.supplierApply4.vo.ChangeLogVo;
import com.artfess.gyl.supplierApply4.vo.SupplierChangeVo;
import com.artfess.gyl.supplierApply4.vo.SupplierRegister4Vo;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizSupplierEnterpriseChangeLogManagerImpl
extends BaseManagerImpl<BizSupplierEnterpriseChangeLogDao, BizSupplierEnterpriseChangeLog>
implements BizSupplierEnterpriseChangeLogManager {
    private static final Logger log = LoggerFactory.getLogger(BizSupplierEnterpriseChangeLogManagerImpl.class);
    @Resource
    private BizSupplierEnterpriseTemporaryChangeManager changeManager;
    @Resource
    private BizSupplierEnterpriseManager enterpriseManager;
    @Resource
    private BizSupplierEnterpriseAccessApprovalRecord3Manager record3Manager;
    @Resource
    private SupplierAsyncProcessor supplierAsyncProcessor;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveOrUpdateModel(SupplierChangeDTO dto) {
        long startTime = System.currentTimeMillis();
        try {
            this.validateSupplierChangeDTO(dto);
            dto.setStatus("0");
            boolean result = super.saveOrUpdate((Object)dto);
            this.saveTemporaryChangeInfo(dto);
            log.debug("saveOrUpdateModel completed in {}ms", (Object)(System.currentTimeMillis() - startTime));
            return result;
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u4f9b\u5e94\u5546\u53d8\u66f4\u8bb0\u5f55\u5931\u8d25, dto: {}", (Object)dto, (Object)e);
            throw new ApplicationException("\u4fdd\u5b58\u4f9b\u5e94\u5546\u53d8\u66f4\u8bb0\u5f55\u5931\u8d25: " + e.getMessage());
        }
    }

    @Override
    public SupplierChangeVo getModel(String id) {
        BizSupplierEnterpriseChangeLog logEntity = (BizSupplierEnterpriseChangeLog)super.get((Serializable)((Object)id));
        if (logEntity == null) {
            throw new ApplicationException("\u672a\u627e\u5230\u53d8\u66f4\u8bb0\u5f55, id: " + id);
        }
        SupplierChangeVo vo = new SupplierChangeVo(logEntity);
        SupplierRegister4Vo changeInfo = this.changeManager.getBySupplierId(vo.getSupplierId());
        vo.setInformation(changeInfo);
        return vo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean publish(String id) {
        BizSupplierEnterpriseChangeLog changeLog = (BizSupplierEnterpriseChangeLog)super.get((Serializable)((Object)id));
        if (changeLog == null) {
            throw new ApplicationException("\u672a\u627e\u5230\u53d8\u66f4\u901a\u77e5, id: " + id);
        }
        List enterprises = this.enterpriseManager.list((Wrapper)new LambdaQueryWrapper().eq(BizSupplierEnterprise::getSupplierId, (Object)changeLog.getSupplierId()));
        if (enterprises.isEmpty()) {
            throw new ApplicationException("\u672a\u627e\u5230\u9700\u53d1\u5e03\u66f4\u65b0\u7684\u4f01\u4e1a");
        }
        changeLog.setChangeEnterpriseAmount(enterprises.size());
        changeLog.setChangeEnterpriseReviewAmount(0);
        changeLog.setChangeEnterpriseUnreviewAmount(enterprises.size());
        this.updateChangeLogStatus(changeLog);
        ArrayList<BizSupplierEnterpriseAccessApprovalRecord3> records = new ArrayList<BizSupplierEnterpriseAccessApprovalRecord3>();
        for (BizSupplierEnterprise enterpris : enterprises) {
            BizSupplierEnterpriseAccessApprovalRecord3 record3 = new BizSupplierEnterpriseAccessApprovalRecord3();
            record3.setId(null);
            record3.setSupplierEnterpriseId(enterpris.getId());
            record3.setEnterpriseId(enterpris.getEnterpriseId());
            record3.setSupplierEnterpriseChangeLogId(changeLog.getId());
            record3.setApprovalResult("-1");
            records.add(record3);
        }
        this.record3Manager.saveBatch(records);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean review(ReviewDTO dto) {
        try {
            this.validateReviewDTO(dto);
            this.saveApprovalRecord(dto);
            this.supplierAsyncProcessor.processApprovalResultAsync(dto);
            return true;
        }
        catch (Exception e) {
            throw new ApplicationException("\u5ba1\u6838\u4f9b\u5e94\u5546\u53d8\u66f4\u5931\u8d25: " + e.getMessage());
        }
    }

    @Override
    public PageList<ChangeLogVo> queryByUser(QueryFilter<BizSupplierEnterpriseChangeLog> queryFilter) {
        queryFilter.addFilter("log.is_dele_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("rd.is_dele_", (Object)"0", QueryOP.EQUAL);
        IPage<ChangeLogVo> iPage = ((BizSupplierEnterpriseChangeLogDao)this.baseMapper).queryByUser((IPage<BizSupplierEnterpriseChangeLog>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizSupplierEnterpriseChangeLog>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(iPage);
    }

    private void validateSupplierChangeDTO(SupplierChangeDTO dto) {
        if (dto == null) {
            throw new ApplicationException("\u53d8\u66f4\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getInformation() == null) {
            throw new ApplicationException("\u53d8\u66f4\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateReviewDTO(ReviewDTO dto) {
        if (dto == null) {
            throw new ApplicationException("\u5ba1\u6838\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getId() == null) {
            throw new ApplicationException("\u53d8\u66f4\u8bb0\u5f55ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void saveTemporaryChangeInfo(SupplierChangeDTO dto) {
        SupplierRegister4DTO information = dto.getInformation();
        information.setCode("-1");
        information.setSupplierEnterpriseChangeLogId(dto.getId());
        this.changeManager.saveOrUpdateModel(information, dto.getChangeType());
    }

    private void updateChangeLogStatus(BizSupplierEnterpriseChangeLog changeLog) {
        IUser user = ContextUtil.getCurrentUser();
        changeLog.setStatus("1");
        changeLog.setChangeInitiatorName(user.getFullname());
        changeLog.setChangeInitiatorId(user.getUserId());
        changeLog.setChangeInitiatorAccount(user.getAccount());
        changeLog.setChangeInitiatorStartDate(LocalDateTime.now());
        super.update((Model)changeLog);
    }

    private void saveApprovalRecord(ReviewDTO dto) {
        BizSupplierEnterpriseAccessApprovalRecord3 record3 = (BizSupplierEnterpriseAccessApprovalRecord3)((Object)this.record3Manager.getById((Serializable)((Object)dto.getRecordId())));
        if (record3 == null) {
            throw new ApplicationException("\u672a\u627e\u5230\u5ba1\u6838\u8bb0\u5f55");
        }
        IUser user = ContextUtil.getCurrentUser();
        record3.setApprovalOrgId(ContextUtil.getCurrentOrgId());
        record3.setApprovalOrgCode(ContextUtil.getCurrentOrgCode());
        record3.setApprovalOrgName(ContextUtil.getCurrentOrgName());
        record3.setApprovalId(user.getUserId());
        record3.setApprovalAccount(user.getAccount());
        record3.setApprovalName(user.getFullname());
        record3.setApprovalDate(LocalDateTime.now());
        record3.setApprovalResult(dto.getApprovalResult());
        record3.setApprovalOpinion(dto.getApprovalOpinion());
        this.record3Manager.updateById((Object)record3);
    }
}

