/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.supplierEva.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.gyl.supplierEva.dao.BizSupplierPerformanceEvaluationCorrectionReportDao;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationCorrectionReportManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationCorrectionReportRecordManager;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationApprovalRecord;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationCorrectionReport;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationCorrectionReportRecord;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class BizSupplierPerformanceEvaluationCorrectionReportManagerImpl
extends BaseManagerImpl<BizSupplierPerformanceEvaluationCorrectionReportDao, BizSupplierPerformanceEvaluationCorrectionReport>
implements BizSupplierPerformanceEvaluationCorrectionReportManager {
    @Resource
    private BizSupplierPerformanceEvaluationCorrectionReportRecordManager recordManager;

    @Override
    public void saveReportResult(BizSupplierPerformanceEvaluationCorrectionReport report, String approvalOpinion) {
        IUser user = ContextUtil.getCurrentUser();
        this.saveApprovalRecord(report, approvalOpinion, user);
    }

    private void saveApprovalRecord(BizSupplierPerformanceEvaluationCorrectionReport report, String approvalOpinion, IUser user) {
        String correctionStatus = report.getCorrectionStatus();
        BizSupplierPerformanceEvaluationCorrectionReportRecord record = new BizSupplierPerformanceEvaluationCorrectionReportRecord();
        this.setBasicInfo(record, report);
        this.setNodeStatus(record, correctionStatus);
        this.setApproverInfo((Object)record, user);
        this.setApprovalResult(record, correctionStatus, approvalOpinion);
        this.recordManager.save((Object)record);
    }

    private void setBasicInfo(BizSupplierPerformanceEvaluationCorrectionReportRecord record, BizSupplierPerformanceEvaluationCorrectionReport report) {
        record.setPerformanceEvaluationId(report.getPerformanceEvaluationId());
        record.setPerformanceEvaluationCorrectionReportId(report.getId());
        record.setNotificationId(report.getNotificationId());
        record.setJobNum("1");
        record.setStatus(report.getCorrectionStatus());
    }

    private void setNodeStatus(BizSupplierPerformanceEvaluationCorrectionReportRecord record, String correctionStatus) {
        record.setFirstNode("1".equals(correctionStatus) ? "1" : "0");
        record.setTailNode("3".equals(correctionStatus) || "5".equals(correctionStatus) ? "1" : "0");
    }

    private void setApproverInfo(Object record, IUser user) {
        if (record instanceof BizSupplierPerformanceEvaluationCorrectionReportRecord) {
            BizSupplierPerformanceEvaluationCorrectionReportRecord target = (BizSupplierPerformanceEvaluationCorrectionReportRecord)((Object)record);
            target.setApprovalId(user.getUserId());
            target.setApprovalAccount(user.getAccount());
            target.setApprovalName(user.getFullname());
            target.setApprovalOrgId(ContextUtil.getCurrentOrgId());
            target.setApprovalOrgCode(ContextUtil.getCurrentOrgCode());
            target.setApprovalOrgName(ContextUtil.getCurrentOrgName());
        } else if (record instanceof BizSupplierPerformanceEvaluationApprovalRecord) {
            BizSupplierPerformanceEvaluationApprovalRecord target = (BizSupplierPerformanceEvaluationApprovalRecord)((Object)record);
            target.setApprovalId(user.getUserId());
            target.setApprovalAccount(user.getAccount());
            target.setApprovalName(user.getFullname());
            target.setApprovalOrgId(ContextUtil.getCurrentOrgId());
            target.setApprovalOrgName(ContextUtil.getCurrentOrgName());
            target.setApprovalOrgCode(ContextUtil.getCurrentOrgCode());
        }
    }

    private void setApprovalResult(BizSupplierPerformanceEvaluationCorrectionReportRecord record, String correctionStatus, String approvalOpinion) {
        record.setApprovalDate(LocalDateTime.now());
        record.setApprovalResult("4".equals(correctionStatus) ? "0" : "1");
        record.setApprovalOpinion(approvalOpinion);
    }

    private boolean isFinalApprovalStatus(String correctionStatus) {
        return "3".equals(correctionStatus) || "5".equals(correctionStatus);
    }
}

