/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rabbitmq.config;

import java.util.UUID;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RabbitMqTemplate {
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private AmqpTemplate amqpTemplate;

    public void sendMessage(String exchange, String routingKey, Object object) {
        this.rabbitTemplate.convertAndSend(exchange, routingKey, object, message -> {
            message.getMessageProperties().setExpiration("10000");
            return message;
        });
    }

    public void sendNotTTLMessage(String exchange, String routingKey, Object object) {
        CorrelationData correlationId = new CorrelationData(UUID.randomUUID().toString());
        this.rabbitTemplate.convertAndSend(exchange, routingKey, object, correlationId);
    }
}

