/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.persistence.model.query;

import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryOP;
import com.artfess.bpm.persistence.constants.Bool;
import com.artfess.bpm.persistence.constants.ProcDefTestStatus;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

public class BpmDefQueryFields {
    private List<QueryField> queryFields = new ArrayList<QueryField>();

    public List<QueryField> getQueryFields() {
        return this.queryFields;
    }

    public BpmDefQueryFields addName(String value) {
        QueryField queryField = new QueryField("NAME_", (Object)value, QueryOP.LIKE);
        this.queryFields.add(queryField);
        return this;
    }

    public BpmDefQueryFields addName(QueryOP op, String value) {
        QueryField queryField = new QueryField("NAME_", (Object)value, op);
        this.queryFields.add(queryField);
        return this;
    }

    public BpmDefQueryFields addDefKey(String value) {
        QueryField queryField = new QueryField("DEF_KEY_", (Object)value, QueryOP.LIKE);
        this.queryFields.add(queryField);
        return this;
    }

    public BpmDefQueryFields addDefKey(QueryOP op, String value) {
        QueryField queryField = new QueryField("DEF_KEY_", (Object)value, op);
        this.queryFields.add(queryField);
        return this;
    }

    public BpmDefQueryFields addTypeId(String typeId) {
        QueryField queryField = new QueryField("TYPE_ID_", (Object)typeId, QueryOP.EQUAL);
        this.queryFields.add(queryField);
        return this;
    }

    public BpmDefQueryFields addStatus(String status) {
        QueryField queryField = new QueryField("STATUS_", (Object)status, QueryOP.EQUAL);
        this.queryFields.add(queryField);
        return this;
    }

    public BpmDefQueryFields addStatus(List<String> statusList) {
        QueryField queryField = new QueryField("STATUS_", statusList, QueryOP.IN);
        this.queryFields.add(queryField);
        return this;
    }

    public BpmDefQueryFields addTestStatus(ProcDefTestStatus testStatus) {
        QueryField queryField = new QueryField("TEST_STATUS_", (Object)testStatus, QueryOP.EQUAL);
        this.queryFields.add(queryField);
        return this;
    }

    public BpmDefQueryFields addBpmnDefId(String bpmnDefId) {
        QueryField queryField = new QueryField("BPMN_DEF_ID_", (Object)bpmnDefId);
        this.queryFields.add(queryField);
        return this;
    }

    public BpmDefQueryFields addBpmnDeployId(String bpmnDeployId) {
        QueryField queryField = new QueryField("BPMN_DEPLOY_ID_", (Object)bpmnDeployId);
        this.queryFields.add(queryField);
        return this;
    }

    public BpmDefQueryFields addIsMain(Bool trueOrFalse) {
        QueryField queryField = new QueryField("IS_MAIN_", (Object)Character.valueOf(trueOrFalse.value()));
        this.queryFields.add(queryField);
        return this;
    }

    public BpmDefQueryFields addCreateBy(String userId) {
        QueryField queryField = new QueryField("CREATE_BY_", (Object)userId);
        this.queryFields.add(queryField);
        return this;
    }

    public BpmDefQueryFields addCreateTimeRange(LocalDateTime startTime, LocalDateTime endTime) {
        if (startTime != null && endTime != null) {
            ArrayList<LocalDateTime> dateList = new ArrayList<LocalDateTime>();
            dateList.add(startTime);
            dateList.add(endTime);
            QueryField queryField = new QueryField("CREATE_TIME_", dateList, QueryOP.BETWEEN);
            this.queryFields.add(queryField);
        } else if (startTime != null) {
            QueryField queryField = new QueryField("CREATE_TIME_", (Object)startTime, QueryOP.GREAT_EQUAL);
            this.queryFields.add(queryField);
        } else if (endTime != null) {
            QueryField queryField = new QueryField("CREATE_TIME_", (Object)endTime, QueryOP.LESS_EQUAL);
            this.queryFields.add(queryField);
        }
        return this;
    }
}

