/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.activiti.def.service.impl;

import com.artfess.activiti.cache.ActivitiDefCache;
import com.artfess.activiti.def.impl.EclipseDefTransform;
import com.artfess.activiti.def.impl.FlashDefTransform;
import com.artfess.activiti.persistence.ProDefinitionPersistence;
import com.artfess.base.context.BaseContext;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.constant.DesignerType;
import com.artfess.bpm.natapi.def.DefTransform;
import com.artfess.bpm.natapi.def.NatProDefinitionService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.annotation.Resource;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.DeploymentBuilder;
import org.activiti.engine.repository.ProcessDefinition;
import org.springframework.stereotype.Service;

@Service(value="proDefinitionServiceImpl")
public class ProDefinitionServiceImpl
implements NatProDefinitionService {
    @Resource
    RepositoryService repositoryService;
    @Resource
    ProDefinitionPersistence proDefinitionPersistence;
    @Resource(name="webDefTransform")
    DefTransform webDefTransform;
    @Resource
    ActivitiDefCache activitiDefCache;
    @Resource
    BaseContext baseContext;

    public String deploy(String tenantId, String name, String defXml) throws UnsupportedEncodingException {
        ByteArrayInputStream stream = new ByteArrayInputStream(defXml.getBytes("utf-8"));
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment();
        if (StringUtil.isEmpty((String)tenantId)) {
            tenantId = this.baseContext.getCurrentTenantId();
        }
        deploymentBuilder.tenantId(tenantId);
        deploymentBuilder.name(name);
        deploymentBuilder.addInputStream("bpmn20.xml", (InputStream)stream);
        Deployment deploy = deploymentBuilder.deploy();
        return deploy.getId();
    }

    public String getDefXmlByDeployId(String deployId) {
        return this.proDefinitionPersistence.getDefXmlByDeployId(deployId);
    }

    public void writeDefXml(String deployId, String defXml) {
        this.proDefinitionPersistence.writeDefXml(deployId, defXml);
        String actDefId = this.getProcessDefinitionIdByDeployId(deployId);
        this.activitiDefCache.remove(actDefId);
    }

    public String getProcessDefinitionIdByDeployId(String deployId) {
        ProcessDefinition proDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployId).singleResult();
        if (proDefinition == null) {
            return null;
        }
        return proDefinition.getId();
    }

    public void clearCacheByBpmnDefId(String bpmnDefId) {
        this.activitiDefCache.remove(bpmnDefId);
    }

    public DefTransform getDefTransform(DesignerType designerType) {
        DefTransform trans = null;
        switch (designerType) {
            case WEB: {
                trans = this.webDefTransform;
                break;
            }
            case ECLIPSE: {
                trans = new EclipseDefTransform();
                break;
            }
            case FLASH: {
                trans = new FlashDefTransform();
            }
        }
        return trans;
    }
}

