/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.persistence.manager.impl;

import com.artfess.base.datasource.DatabaseContext;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.manager.CommonManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.bpm.chart.IChart;
import com.artfess.bpm.chart.impl.FlowStatusChart;
import com.artfess.bpm.persistence.dao.BpmReportActDao;
import com.artfess.bpm.persistence.manager.BpmReportActManager;
import com.artfess.bpm.persistence.manager.BpmReportListManager;
import com.artfess.bpm.persistence.model.BpmReportAct;
import com.artfess.bpm.persistence.model.BpmReportActVo;
import com.artfess.bpm.persistence.model.BpmReportList;
import com.artfess.bpm.persistence.model.vo.FlowOrgCountVo;
import com.artfess.bpm.persistence.model.vo.FlowUserCountVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bpmReportActManager")
public class BpmReportActManagerImpl
extends BaseManagerImpl<BpmReportActDao, BpmReportAct>
implements BpmReportActManager {
    @Resource
    UCFeignService ucService;
    @Resource
    BpmReportListManager bpmReportListManager;
    @Resource
    BpmReportActManager bpmReportActManager;
    @Resource
    DatabaseContext databaseContext;
    @Resource
    CommonManager commonManager;

    @Override
    @Transactional
    public CommonResult<String> saveAct(BpmReportActVo bpmReportAct) {
        String resultMsg = "";
        String actId = bpmReportAct.getId();
        String reportId = bpmReportAct.getReportId();
        try {
            BpmReportList reportList;
            if (StringUtil.isEmpty((String)actId)) {
                bpmReportAct.setId(UniqueIdUtil.getSuid());
                if (StringUtil.isEmpty((String)reportId)) {
                    if (StringUtil.isEmpty((String)bpmReportAct.getName())) {
                        return new CommonResult(false, "\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    reportList = new BpmReportList();
                    String id = UniqueIdUtil.getSuid();
                    reportList.setId(id);
                    reportList.setName(bpmReportAct.getName());
                    IUser user = ContextUtil.getCurrentUser();
                    String userId = user.getUserId();
                    String userName = user.getUsername();
                    reportList.setCreateBy(userId);
                    reportList.setCreateName(userName);
                    ObjectNode org = this.ucService.getMainGroup(userId);
                    if (BeanUtils.isNotEmpty((Object)org)) {
                        String orgId = org.get("id").asText();
                        String orgName = org.get("name").asText();
                        reportList.setCreateOrgId(orgId);
                        reportList.setOrgName(orgName);
                    }
                    this.bpmReportListManager.create((Model)reportList);
                    bpmReportAct.setReportId(id);
                }
                this.bpmReportActManager.create((Model)bpmReportAct);
                resultMsg = "\u6dfb\u52a0\u62a5\u8868\u6210\u529f";
            } else {
                this.bpmReportActManager.update((Model)bpmReportAct);
                resultMsg = "\u66f4\u65b0\u62a5\u8868\u6210\u529f";
            }
            if (StringUtil.isNotEmpty((String)reportId) && BeanUtils.isNotEmpty((Object)((Object)(reportList = (BpmReportList)this.bpmReportListManager.get((Serializable)((Object)reportId))))) && StringUtil.isNotEmpty((String)bpmReportAct.getName()) && !bpmReportAct.getName().equals(reportList.getName())) {
                reportList.setName(bpmReportAct.getName());
                this.bpmReportListManager.update((Model)reportList);
            }
            return new CommonResult(true, resultMsg, (Object)bpmReportAct.getReportId());
        }
        catch (Exception e) {
            resultMsg = "\u5bf9\u62a5\u8868\u64cd\u4f5c\u5931\u8d25";
            return new CommonResult(false, resultMsg);
        }
    }

    @Override
    public CommonResult<JsonNode> getEchartsData(String reportId) throws Exception {
        ArrayNode array = JsonUtil.getMapper().createArrayNode();
        BpmReportList reportList = (BpmReportList)this.bpmReportListManager.get((Serializable)((Object)reportId));
        if (BeanUtils.isNotEmpty((Object)((Object)reportList))) {
            List<BpmReportAct> acts = ((BpmReportActDao)this.baseMapper).queryList(reportId);
            for (BpmReportAct act : acts) {
                ObjectNode node = this.analysisData(act);
                array.add((JsonNode)node);
            }
        } else {
            return new CommonResult(false, "\u83b7\u53d6\u5931\u8d25\uff01id\u4e3a\u3010" + reportId + "\u3011\u7684\u7edf\u8ba1\u4e0d\u5b58\u5728\uff01");
        }
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)array);
    }

    @Override
    public CommonResult<JsonNode> getSingleEchartsData(String id) throws Exception {
        BpmReportAct act = (BpmReportAct)this.get((Serializable)((Object)id));
        if (!BeanUtils.isNotEmpty((Object)((Object)act))) {
            return new CommonResult(false, "\u83b7\u53d6\u5931\u8d25\uff01id\u4e3a\u3010" + id + "\u3011\u7684\u7edf\u8ba1\u4e0d\u5b58\u5728\uff01");
        }
        ObjectNode node = this.analysisData(act);
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)node);
    }

    private ObjectNode analysisData(BpmReportAct act) throws Exception {
        String preDesc;
        ObjectNode node = JsonUtil.getMapper().createObjectNode();
        node.put("name", act.getReportName());
        ObjectNode prop = (ObjectNode)JsonUtil.toJsonNode((String)act.getPorp());
        String flowType = JsonUtil.getString((JsonNode)prop, (String)"flowType", (String)"1");
        String orgType = JsonUtil.getString((JsonNode)prop, (String)"orgType", (String)"1");
        String dimension = JsonUtil.getString((JsonNode)prop, (String)"dimension", (String)"org");
        String ids = JsonUtil.getString((JsonNode)prop, (String)"id");
        String names = JsonUtil.getString((JsonNode)prop, (String)"name");
        LinkedHashMap<String, String> flowMap = new LinkedHashMap<String, String>();
        if (StringUtil.isNotEmpty((String)ids)) {
            String[] idArray = ids.split(",");
            String[] idNameArray = names.split(",");
            for (int i = 0; i < idArray.length; ++i) {
                flowMap.put(idArray[i], idNameArray[i]);
            }
        }
        String orgIds = JsonUtil.getString((JsonNode)prop, (String)"orgIds");
        String orgNames = JsonUtil.getString((JsonNode)prop, (String)"orgNames");
        LinkedHashMap<String, String> orgMap = new LinkedHashMap<String, String>();
        if (StringUtil.isNotEmpty((String)orgIds)) {
            String[] orgIdArray = orgIds.split(",");
            String[] orgNameArray = orgNames.split(",");
            for (int i = 0; i < orgIdArray.length; ++i) {
                orgMap.put(orgIdArray[i], orgNameArray[i]);
            }
        }
        String calcuCycle = JsonUtil.getString((JsonNode)prop, (String)"calcuCycle");
        String calcuStart = JsonUtil.getString((JsonNode)prop, (String)"calcuStart");
        String startTime = this.getDateTime(calcuCycle, calcuStart, true);
        String calcuEnd = JsonUtil.getString((JsonNode)prop, (String)"calcuEnd");
        String endTime = this.getDateTime(calcuCycle, calcuEnd, false);
        String params = act.getParams();
        IChart chart = (IChart)AppUtil.getBean((String)params);
        ObjectNode rightContentNode = (ObjectNode)JsonUtil.toJsonNode((String)act.getRightContent());
        ObjectNode analysisNode = this.getAnalysisNode(chart, flowType, dimension, ids, names, orgIds, orgNames, startTime, endTime, flowMap, orgMap, orgType);
        String ptypeDesc = chart.getDesc();
        String string = preDesc = "org".equals(dimension) ? "\u90e8\u95e8/\u4eba\u5458" : "\u6d41\u7a0b/\u6d41\u7a0b\u5206\u7c7b";
        String calcuCycleDesc = "year".equals(calcuCycle) ? "\u5e74\u5ea6" : ("quarter".equals(calcuCycle) ? "\u5b63\u5ea6" : ("monthly".equals(calcuCycle) ? "\u6708\u5ea6" : "\u81ea\u5b9a\u4e49\u65f6\u95f4\u6bb5"));
        String calcuDesc = "\uff08" + calcuStart + "\u81f3" + calcuEnd + "\uff09";
        if ("quarter".equals(calcuCycle)) {
            calcuDesc = "\uff08" + calcuStart + "\u5b63\u5ea6" + "\u81f3" + calcuEnd + "\u5b63\u5ea6" + "\uff09";
        }
        analysisNode.put("name", act.getReportName());
        analysisNode.put("histogram", JsonUtil.getBoolean((ObjectNode)rightContentNode, (String)"histogram"));
        analysisNode.put("line", JsonUtil.getBoolean((ObjectNode)rightContentNode, (String)"line"));
        analysisNode.put("pie", JsonUtil.getBoolean((ObjectNode)rightContentNode, (String)"pie"));
        analysisNode.put("dataViews", JsonUtil.getBoolean((ObjectNode)rightContentNode, (String)"dataViews"));
        analysisNode.put("id", act.getId());
        analysisNode.put("subtext", "\u6309" + preDesc + "\u7ef4\u5ea6" + calcuCycleDesc + calcuDesc + ptypeDesc + "\u7edf\u8ba1\u56fe\u8868");
        return analysisNode;
    }

    private ObjectNode getAnalysisNode(IChart chart, String flowType, String dimension, String ids, String names, String orgIds, String orgNames, String startTime, String endTime, Map<String, String> flowMap, Map<String, String> orgMap, String orgType) throws Exception {
        ObjectNode startNode = JsonUtil.getMapper().createObjectNode();
        String unionSql = chart.getQuerySql(flowType, dimension, ids, orgIds, startTime, endTime, orgType, this.getDbType());
        List<String> legend = chart.getLegend();
        List<Map<String, Object>> selectList = this.querySql(unionSql);
        ArrayNode series = chart.getSeries(legend, selectList, "org".equals(dimension) ? orgMap : flowMap);
        startNode.set("legend", JsonUtil.toJsonNode(legend));
        startNode.set("series", (JsonNode)series);
        if (!(chart instanceof FlowStatusChart)) {
            List<String> xAxis = Arrays.asList("org".equals(dimension) ? orgNames.split(",") : names.split(","));
            startNode.set("xAxis", JsonUtil.toJsonNode(xAxis));
        }
        return startNode;
    }

    private String getDateTime(String calcuCycle, String timeStr, boolean isStart) {
        String newTimeStr = timeStr;
        switch (calcuCycle) {
            case "year": {
                newTimeStr = timeStr + "-01-01 00:00:00";
                if (isStart) break;
                newTimeStr = timeStr + "-12-31 23:59:59";
                break;
            }
            case "quarter": {
                String[] timeArray = timeStr.split("-");
                String mothDate = this.getQuarterMothDate(timeArray[1], isStart);
                newTimeStr = timeArray[0] + "-" + mothDate + " 00:00:00";
                if (!isStart) break;
                newTimeStr = timeArray[0] + "-" + mothDate + " 23:59:59";
                break;
            }
            case "monthly": {
                String[] monthlyArray = timeStr.split("-");
                String monthDayStr = this.getMonthlyMothDate(monthlyArray[0], monthlyArray[1], isStart);
                String laster = isStart ? " 00:00:00" : " 23:59:59";
                newTimeStr = monthlyArray[0] + "-" + monthDayStr + laster;
            }
        }
        return newTimeStr;
    }

    private String getQuarterMothDate(String quarter, boolean isStart) {
        int quart = Integer.valueOf(quarter);
        int moth = quart * 3;
        if (isStart) {
            moth -= 2;
        }
        String mothStr = String.valueOf(moth);
        if (moth < 10) {
            mothStr = "0" + moth;
        }
        if (!isStart) {
            switch (quart) {
                case 1: 
                case 4: {
                    mothStr = mothStr + "-31";
                    break;
                }
                case 2: 
                case 3: {
                    mothStr = mothStr + "-30";
                    break;
                }
            }
        } else {
            mothStr = mothStr + "-01";
        }
        return mothStr;
    }

    private String getMonthlyMothDate(String yearly, String monthly, boolean isStart) {
        int year = Integer.valueOf(yearly);
        int month = Integer.valueOf(monthly);
        if (month < 10) {
            monthly = "0" + monthly;
        }
        if (!isStart) {
            switch (month) {
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 10: 
                case 12: {
                    monthly = monthly + "-31";
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    monthly = monthly + "-30";
                    break;
                }
                case 2: {
                    if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
                        monthly = monthly + "-29";
                        break;
                    }
                    monthly = monthly + "-28";
                    break;
                }
            }
        } else {
            monthly = monthly + "-01";
        }
        return monthly;
    }

    private String getDbType() {
        String dbType = this.databaseContext.getDbTypeByAlias("LOCAL");
        return "dm".equals(dbType) ? "oracle" : dbType;
    }

    private List<Map<String, Object>> querySql(String sql) {
        return this.commonManager.query(sql);
    }

    @Override
    public PageList<FlowOrgCountVo> flowOrgCountList(QueryFilter queryFilter) {
        List<Map<String, Object>> selectList = this.getFlowOrgSelectList(queryFilter);
        return this.parseToOrgPageList(selectList);
    }

    @Override
    public List<Map<String, Object>> getFlowOrgSelectList(QueryFilter queryFilter) {
        String dbType = this.getDbType();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT a.PROC_DEF_KEY_ as procDefKey,a.PROC_DEF_NAME_ as procDefName,COUNT(1) AS instances,");
        if ("oracle".equals(dbType)) {
            sql.append("ROUND(SUM((TO_DATE (TO_CHAR ((CASE a.END_TIME_ WHEN a.END_TIME_ THEN a.END_TIME_ ELSE (SELECT SYSDATE FROM dual) END ), 'YYYY-MM-DD HH24-MI-SS' ),'YYYY-MM-DD HH24-MI-SS') - TO_DATE (TO_CHAR (a.CREATE_TIME_,'YYYY-MM-DD HH24-MI-SS'),'YYYY-MM-DD HH24-MI-SS')) * 24),1) AS hourLong,");
        } else if ("postgresql".equals(dbType)) {
            sql.append("ROUND(SUM((TO_DATE (TO_CHAR ((CASE a.END_TIME_ WHEN a.END_TIME_ THEN a.END_TIME_ ELSE now() END ), 'YYYY-MM-DD HH24-MI-SS' ),'YYYY-MM-DD HH24-MI-SS') - TO_DATE (TO_CHAR (a.CREATE_TIME_,'YYYY-MM-DD HH24-MI-SS'),'YYYY-MM-DD HH24-MI-SS')) * 24),1) AS hourLong,");
        } else if ("h2".equals(dbType)) {
            sql.append("SUM(ROUND(TIMESTAMPDIFF(MINUTE,a.CREATE_TIME_,(CASE WHEN a.END_TIME_ IS NOT NULL THEN a.END_TIME_ ELSE now() END))/60,1)) AS hourLong,");
        } else {
            sql.append("SUM(ROUND(TIMESTAMPDIFF(MINUTE,a.CREATE_TIME_,IF (a.END_TIME_ IS NOT NULL,a.END_TIME_,now()))/60,1)) AS hourLong,");
        }
        sql.append("(SELECT COUNT(1) FROM bpm_pro_inst b WHERE b.STATUS_ NOT IN('end','manualend') and b.PROC_DEF_KEY_=a.PROC_DEF_KEY_" + this.getFlowOrgWhereSql(queryFilter, "b") + ") as incomplete");
        sql.append(" FROM bpm_pro_inst a WHERE 1=1 ");
        sql.append(this.getFlowOrgWhereSql(queryFilter, "a"));
        sql.append(" GROUP BY a.PROC_DEF_KEY_,a.PROC_DEF_NAME_");
        return this.querySql(sql.toString());
    }

    private String getFlowOrgWhereSql(QueryFilter queryFilter, String pre) {
        StringBuilder whereSql = new StringBuilder();
        List querys = queryFilter.getQuerys();
        if (BeanUtils.isNotEmpty((Object)queryFilter) && BeanUtils.isNotEmpty((Object)querys)) {
            for (QueryField queryField : querys) {
                String[] orgIds;
                if ("createTime".equals(queryField.getProperty()) && BeanUtils.isNotEmpty((Object)queryField.getValue())) {
                    List times = (List)queryField.getValue();
                    whereSql.append(" AND " + pre + ".CREATE_TIME_ >='" + (String)times.get(0) + "' ");
                    whereSql.append(" AND " + pre + ".CREATE_TIME_ <='" + (String)times.get(1) + "' ");
                    continue;
                }
                if (!"createOrgId".equals(queryField.getProperty()) || !BeanUtils.isNotEmpty((Object)queryField.getValue())) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                for (String orgId : orgIds = queryField.getValue().toString().split(",")) {
                    map.put(orgId, orgId);
                }
                HashSet allOrgIds = new HashSet();
                Map mapSet = this.ucService.getChildrenIds(map);
                for (String key : mapSet.keySet()) {
                    allOrgIds.addAll((Collection)mapSet.get(key));
                }
                String orgSql = StringUtil.convertListToSingleQuotesString(allOrgIds);
                whereSql.append(" AND " + pre + ".CREATE_ORG_ID_ in(" + orgSql + ")");
            }
            return whereSql.toString();
        }
        return "";
    }

    private PageList<FlowOrgCountVo> parseToOrgPageList(List<Map<String, Object>> selectList) {
        PageList pageList = new PageList();
        pageList.setPage(1L);
        pageList.setPageSize(1L);
        pageList.setTotal(0L);
        pageList.setRows(new ArrayList());
        try {
            if (BeanUtils.isNotEmpty(selectList)) {
                List<FlowOrgCountVo> rows = new ArrayList();
                if (selectList.get(0).containsKey("PROCDEFKEY")) {
                    for (Map<String, Object> map : selectList) {
                        FlowOrgCountVo vo = new FlowOrgCountVo();
                        vo.setProcDefKey(map.get("PROCDEFKEY").toString());
                        vo.setProcDefName(map.get("PROCDEFNAME").toString());
                        vo.setHourLong(BeanUtils.isNotEmpty((Object)map.get("HOURLONG")) ? Float.valueOf(map.get("HOURLONG").toString()).floatValue() : 0.0f);
                        vo.setIncomplete(BeanUtils.isNotEmpty((Object)map.get("INCOMPLETE")) ? Integer.valueOf(map.get("INCOMPLETE").toString()) : 0);
                        vo.setInstances(BeanUtils.isNotEmpty((Object)map.get("INSTANCES")) ? Integer.valueOf(map.get("INSTANCES").toString()) : 0);
                        rows.add(vo);
                    }
                } else {
                    JavaType javaType = JsonUtil.getMapper().getTypeFactory().constructParametricType(ArrayList.class, new Class[]{FlowOrgCountVo.class});
                    rows = (List)JsonUtil.getMapper().readValue(JsonUtil.toJson(selectList), javaType);
                }
                if (BeanUtils.isNotEmpty(rows)) {
                    pageList.setRows(rows);
                    pageList.setPageSize((long)rows.size());
                    pageList.setTotal((long)rows.size());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pageList;
    }

    @Override
    public PageList<FlowUserCountVo> flowUserCountList(QueryFilter queryFilter) {
        List<Map<String, Object>> selectList = this.getFlowUserSelectList(queryFilter);
        return this.parseToUserPageList(selectList);
    }

    @Override
    public List<Map<String, Object>> getFlowUserSelectList(QueryFilter queryFilter) {
        String dbType = this.getDbType();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT a.PROC_DEF_KEY_ as procDefKey, a.PROC_DEF_NAME_ as procDefName, a.CREATE_BY_ as userId, a.CREATOR_ as userName,");
        if ("oracle".equals(dbType)) {
            sql.append("ROUND(( SELECT SUM((TO_DATE ( TO_CHAR ( ( CASE END_TIME_ WHEN END_TIME_ THEN END_TIME_ ELSE (SELECT SYSDATE FROM dual) END ), 'YYYY-MM-DD HH24-MI-SS' ), 'YYYY-MM-DD HH24-MI-SS' ) - TO_DATE ( TO_CHAR ( CREATE_TIME_,'YYYY-MM-DD HH24-MI-SS'),'YYYY-MM-DD HH24-MI-SS')) * 24) FROM bpm_pro_inst WHERE PROC_DEF_KEY_=a.PROC_DEF_KEY_)/ COUNT(a.ID_),1) AS avgLong,");
            sql.append("(SELECT count(1) FROM (SELECT PROC_DEF_KEY_,CREATE_BY_,((TO_DATE (TO_CHAR ((CASE END_TIME_ WHEN END_TIME_ THEN END_TIME_ ELSE (SELECT SYSDATE FROM dual) END ), 'YYYY-MM-DD HH24-MI-SS'),'YYYY-MM-DD HH24-MI-SS') - TO_DATE (TO_CHAR (CREATE_TIME_,'YYYY-MM-DD HH24-MI-SS'),'YYYY-MM-DD HH24-MI-SS')) * 24 ) as otime FROM bpm_pro_inst) c where c.otime>24 AND c.PROC_DEF_KEY_=a.PROC_DEF_KEY_ AND c.CREATE_BY_=a.CREATE_BY_) as overtime,");
        } else if ("postgresql".equals(dbType)) {
            sql.append("ROUND(( SELECT SUM((TO_DATE ( TO_CHAR ( ( CASE END_TIME_ WHEN END_TIME_ THEN END_TIME_ ELSE now() END ), 'YYYY-MM-DD HH24-MI-SS' ), 'YYYY-MM-DD HH24-MI-SS' ) - TO_DATE ( TO_CHAR ( CREATE_TIME_,'YYYY-MM-DD HH24-MI-SS'),'YYYY-MM-DD HH24-MI-SS')) * 24) FROM bpm_pro_inst WHERE PROC_DEF_KEY_=a.PROC_DEF_KEY_)/ COUNT(a.ID_),1) AS avgLong,");
            sql.append("(SELECT count(1) FROM (SELECT PROC_DEF_KEY_,CREATE_BY_,((TO_DATE (TO_CHAR ((CASE END_TIME_ WHEN END_TIME_ THEN END_TIME_ ELSE now() END ), 'YYYY-MM-DD HH24-MI-SS'),'YYYY-MM-DD HH24-MI-SS') - TO_DATE (TO_CHAR (CREATE_TIME_,'YYYY-MM-DD HH24-MI-SS'),'YYYY-MM-DD HH24-MI-SS')) * 24 ) as otime FROM bpm_pro_inst) c where c.otime>24 AND c.PROC_DEF_KEY_=a.PROC_DEF_KEY_ AND c.CREATE_BY_=a.CREATE_BY_) as overtime,");
        } else if ("h2".equals(dbType)) {
            sql.append("ROUND((ROUND(SUM(TIMESTAMPDIFF(MINUTE,a.CREATE_TIME_,(CASE WHEN a.END_TIME_ IS NOT NULL THEN a.END_TIME_ ELSE now() END))) / 60,1))/count(a.ID_),1) as avgLong,");
            sql.append("(SELECT count(1) FROM (SELECT PROC_DEF_KEY_,CREATE_BY_,TIMESTAMPDIFF(HOUR,CREATE_TIME_,(CASE WHEN END_TIME_ IS NOT NULL THEN END_TIME_ ELSE now() END)) as otime FROM bpm_pro_inst) c where c.otime>24 AND c.PROC_DEF_KEY_=a.PROC_DEF_KEY_ AND c.CREATE_BY_=a.CREATE_BY_) as overtime,");
        } else {
            sql.append("ROUND((ROUND(SUM(TIMESTAMPDIFF(MINUTE,a.CREATE_TIME_,IF (a.END_TIME_ IS NOT NULL,a.END_TIME_,now()))) / 60,1))/count(a.ID_),1) as avgLong,");
            sql.append("(SELECT count(1) FROM (SELECT PROC_DEF_KEY_,CREATE_BY_,TIMESTAMPDIFF(HOUR,CREATE_TIME_,IF(END_TIME_ IS NOT NULL,END_TIME_,now())) as otime FROM bpm_pro_inst) c where c.otime>24 AND c.PROC_DEF_KEY_=a.PROC_DEF_KEY_ AND c.CREATE_BY_=a.CREATE_BY_) as overtime,");
        }
        sql.append("ROUND((select count(1) from bpm_pro_inst b where b.STATUS_ in ('end','manualend') AND b.PROC_DEF_KEY_=a.PROC_DEF_KEY_ AND b.CREATE_BY_=a.CREATE_BY_ " + this.getFlowUserWhereSql(queryFilter, "b") + ")/count(1)*100) as closingRate ");
        sql.append(" FROM bpm_pro_inst a WHERE 1=1 ");
        sql.append(this.getFlowUserWhereSql(queryFilter, "a"));
        sql.append(" GROUP BY a.PROC_DEF_KEY_,a.PROC_DEF_NAME_,a.CREATE_BY_,a.CREATOR_ ");
        return this.querySql(sql.toString());
    }

    private String getFlowUserWhereSql(QueryFilter queryFilter, String pre) {
        StringBuilder whereSql = new StringBuilder();
        List querys = queryFilter.getQuerys();
        if (BeanUtils.isNotEmpty((Object)queryFilter) && BeanUtils.isNotEmpty((Object)querys)) {
            for (QueryField queryField : querys) {
                if ("createTime".equals(queryField.getProperty()) && BeanUtils.isNotEmpty((Object)queryField.getValue())) {
                    List times = (List)queryField.getValue();
                    whereSql.append(" AND " + pre + ".CREATE_TIME_ >='" + (String)times.get(0) + "' ");
                    whereSql.append(" AND " + pre + ".CREATE_TIME_ <='" + (String)times.get(1) + "' ");
                    continue;
                }
                if ("procDefKey".equals(queryField.getProperty()) && BeanUtils.isNotEmpty((Object)queryField.getValue())) {
                    String[] defKeys = queryField.getValue().toString().split(",");
                    String defKeySql = StringUtil.convertListToSingleQuotesString(new HashSet<String>(Arrays.asList(defKeys)));
                    whereSql.append(" AND " + pre + ".PROC_DEF_KEY_ in(" + defKeySql + ")");
                    continue;
                }
                if (!"createBy".equals(queryField.getProperty()) || !BeanUtils.isNotEmpty((Object)queryField.getValue())) continue;
                String[] userIds = queryField.getValue().toString().split(",");
                String userSql = StringUtil.convertListToSingleQuotesString(new HashSet<String>(Arrays.asList(userIds)));
                whereSql.append(" AND " + pre + ".CREATE_BY_ in(" + userSql + ")");
            }
            return whereSql.toString();
        }
        return "";
    }

    private PageList<FlowUserCountVo> parseToUserPageList(List<Map<String, Object>> selectList) {
        PageList pageList = new PageList();
        pageList.setPage(1L);
        pageList.setPageSize(1L);
        pageList.setTotal(0L);
        pageList.setRows(new ArrayList());
        try {
            if (BeanUtils.isNotEmpty(selectList)) {
                List<FlowUserCountVo> rows = new ArrayList();
                if (selectList.get(0).containsKey("PROCDEFKEY")) {
                    for (Map<String, Object> map : selectList) {
                        FlowUserCountVo vo = new FlowUserCountVo();
                        vo.setProcDefKey(map.get("PROCDEFKEY").toString());
                        vo.setProcDefName(map.get("PROCDEFNAME").toString());
                        vo.setUserId(map.get("USERID").toString());
                        vo.setUserName(map.get("USERNAME").toString());
                        vo.setAvgLong(BeanUtils.isNotEmpty((Object)map.get("AVGLONG")) ? Float.valueOf(map.get("AVGLONG").toString()).floatValue() : 0.0f);
                        vo.setOvertime(BeanUtils.isNotEmpty((Object)map.get("OVERTIME")) ? Integer.valueOf(map.get("OVERTIME").toString()) : 0);
                        vo.setClosingRate(BeanUtils.isNotEmpty((Object)map.get("CLOSINGRATE")) ? Integer.valueOf(map.get("CLOSINGRATE").toString()) : 0);
                        rows.add(vo);
                    }
                } else {
                    JavaType javaType = JsonUtil.getMapper().getTypeFactory().constructParametricType(ArrayList.class, new Class[]{FlowUserCountVo.class});
                    rows = (List)JsonUtil.getMapper().readValue(JsonUtil.toJson(selectList), javaType);
                }
                if (BeanUtils.isNotEmpty(rows)) {
                    pageList.setRows(rows);
                    pageList.setPageSize((long)rows.size());
                    pageList.setTotal((long)rows.size());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pageList;
    }

    @Override
    @Transactional
    public void removeByReportId(String id) {
        ((BpmReportActDao)this.baseMapper).removeByReportId(id);
    }
}

