/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bo.persistence.manager.impl;

import com.artfess.base.datasource.DatabaseContext;
import com.artfess.base.datasource.DatabaseSwitchResult;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.bo.bodef.IBoEntHandler;
import com.artfess.bo.model.BoAttribute;
import com.artfess.bo.model.BoDef;
import com.artfess.bo.model.BoEnt;
import com.artfess.bo.model.BoEntRel;
import com.artfess.bo.persistence.dao.BoEntDao;
import com.artfess.bo.persistence.manager.BoAttributeManager;
import com.artfess.bo.persistence.manager.BoDefManager;
import com.artfess.bo.persistence.manager.BoEntManager;
import com.artfess.bo.persistence.manager.BoEntRelManager;
import com.artfess.table.meta.impl.BaseTableMeta;
import com.artfess.table.model.Column;
import com.artfess.table.model.Table;
import com.artfess.table.operator.ITableOperator;
import com.artfess.table.util.MetaDataUtil;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="boEntManager")
public class BoEntManagerImpl
extends BaseManagerImpl<BoEntDao, BoEnt>
implements BoEntManager {
    @Resource
    ITableOperator tableOperator;
    @Resource
    BoAttributeManager boAttributeManager;
    @Resource
    BoEntRelManager boEntRelManager;
    @Resource
    BoDefManager boDefManager;
    @Resource
    DatabaseContext databaseContext;

    @Override
    @Transactional
    public void createTable(BoEnt boEnt) throws SQLException {
        BoAttribute colPk = new BoAttribute();
        colPk.setName(BoEnt.PK_NAME);
        colPk.setFieldName(BoEnt.PK_NAME);
        colPk.setIsPk(true);
        colPk.setAttrLength(40);
        colPk.setCharLen(40);
        colPk.setColumnType("varchar");
        colPk.setDataType("varchar");
        colPk.setComment("\u4e3b\u952e");
        BoAttribute colFk = new BoAttribute();
        colFk.setName(BoEnt.FK_NAME);
        colFk.setFieldName(BoEnt.FK_NAME);
        colFk.setIsPk(false);
        colFk.setCharLen(40);
        colFk.setAttrLength(40);
        colFk.setDataType("varchar");
        colFk.setColumnType("varchar");
        colFk.setComment("\u5916\u952e");
        List<BoAttribute> colList = boEnt.getBoAttrList();
        boolean hasDataRev = false;
        for (BoAttribute col : colList) {
            if ("form_data_rev_".equals(col.getName())) {
                if (col.getAttrLength() == 0) {
                    col.setAttrLength(37);
                }
                hasDataRev = true;
            }
            col.setFieldName(col.getFieldName());
        }
        if (!hasDataRev) {
            BoAttribute dateRevAttr = new BoAttribute();
            dateRevAttr.setName("form_data_rev_");
            dateRevAttr.setDesc("\u8868\u5355\u6570\u636e\u7248\u672c");
            dateRevAttr.setDataType("int");
            dateRevAttr.setDefaultValue("0");
            dateRevAttr.setFieldName(dateRevAttr.getFieldName());
            dateRevAttr.setAttrLength(37);
            colList.add(dateRevAttr);
        }
        boEnt.addAttrFirst(colFk);
        boEnt.addAttrFirst(colPk);
        this.tableOperator.createTable((Table)boEnt);
    }

    @Override
    @Transactional
    public String saveEnt(BoEnt boEnt) throws Exception {
        String entId;
        BoEnt dbBoEnt = null;
        BoEnt oldBoEnt = null;
        List<Object> oldAttrList = new ArrayList();
        if (StringUtil.isEmpty((String)boEnt.getId())) {
            if (((BoEntDao)this.baseMapper).getByName(boEnt.getName()) != null) {
                throw new BaseException(String.format("\u5df2\u5b58\u5728\u522b\u540d\u4e3a%s\u7684bo\u5b9e\u4f53.", boEnt.getName()));
            }
            entId = UniqueIdUtil.getSuid();
            boEnt.setId(entId);
            boEnt.setStatus(BoEnt.STATUS_ACTIVED);
            this.create((Model)boEnt);
        } else {
            entId = boEnt.getId();
            BoEnt temp = ((BoEntDao)this.baseMapper).getByName(boEnt.getName());
            if (temp != null && !temp.getId().equals(boEnt.getId())) {
                throw new BaseException(String.format("\u5df2\u5b58\u5728\u522b\u540d\u4e3a%s\u7684bo\u5b9e\u4f53.", boEnt.getName()));
            }
            dbBoEnt = this.getById(boEnt.getId());
            oldBoEnt = (BoEnt)this.get((Serializable)((Object)boEnt.getId()));
            oldAttrList = this.boAttributeManager.getByBoEnt(boEnt);
            this.update((Model)boEnt);
            this.boAttributeManager.removeByEntId(boEnt.getId());
        }
        List<BoAttribute> boAttrList = boEnt.getBoAttrList();
        ArrayList<BoAttribute> newAttrList = new ArrayList<BoAttribute>();
        for (BoAttribute boAttribute : boAttrList) {
            boAttribute.setBoEnt(boEnt);
            if (StringUtil.isEmpty((String)boAttribute.getId())) {
                newAttrList.add(boAttribute);
                boAttribute.setId(UniqueIdUtil.getSuid());
                boAttribute.setEntId(boEnt.getId());
                boAttribute.setBoEnt(boEnt);
            }
            boAttribute.setTableName(boEnt.getTableName());
            this.boAttributeManager.create((Model)boAttribute);
        }
        if (!boEnt.isCreatedTable() || boEnt.isExternal()) {
            return entId;
        }
        if (this.getCanEditByName(boEnt.getName()) == 0) {
            if (dbBoEnt != null) {
                this.tableOperator.dropTable(dbBoEnt.getTableName());
            }
            boEnt = this.getById(boEnt.getId());
            try {
                this.createTable(boEnt);
            }
            catch (Exception e) {
                if (BeanUtils.isNotEmpty((Object)((Object)oldBoEnt))) {
                    this.boAttributeManager.removeByEntId(oldBoEnt.getId());
                    for (BoAttribute boAttribute : oldAttrList) {
                        this.boAttributeManager.create((Model)boAttribute);
                    }
                    this.update((Model)oldBoEnt);
                    this.createTable(oldBoEnt);
                    throw new Exception("\u751f\u6210\u8868\u5931\u8d25\uff1a" + ExceptionUtils.getRootCause((Throwable)e).getMessage());
                }
                throw new BaseException("\u751f\u6210\u8868\u5931\u8d25\uff1a" + ExceptionUtils.getRootCause((Throwable)e).getMessage());
            }
        } else {
            for (BoAttribute boAttribute : newAttrList) {
                this.tableOperator.addColumn(boEnt.getTableName(), (Column)boAttribute);
            }
        }
        return entId;
    }

    @Override
    @Transactional
    public void remove(String entityId) {
        List<BoEnt> byDefId = this.getByDefId(entityId);
        for (BoEnt b : byDefId) {
            BoEnt boEnt = (BoEnt)this.get((Serializable)((Object)b.getId()));
            if (BeanUtils.isEmpty((Object)((Object)boEnt))) {
                return;
            }
            String str = "";
            for (BoEntRel rel : this.boEntRelManager.getByEntId(entityId)) {
                BoDef boDef = (BoDef)this.boDefManager.get((Serializable)((Object)rel.getBoDefid()));
                if (StringUtil.isNotEmpty((String)str)) {
                    str = str + ",";
                }
                str = str + boDef.getDescription();
            }
            if (StringUtil.isNotEmpty((String)str)) {
                throw new BaseException("\u5b9e\u4f53\u201c" + boEnt.getDesc() + "\u201d\u5df2\u7ed1\u5b9a\u4e1a\u52a1\u5bf9\u8c61\u5b9a\u4e49\u201c" + str + "\u201d\uff0c\u4e0d\u80fd\u88ab\u5220\u9664\uff01");
            }
            this.boAttributeManager.removeByEntId(entityId);
            super.remove((Serializable)((Object)entityId));
            this.boAttributeManager.removeByEntId(entityId);
            if (!boEnt.isCreatedTable() || boEnt.isExternal()) continue;
            try {
                this.tableOperator.dropTable(boEnt.getTableName());
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public BoEnt getById(String entId) {
        BoEnt boEnt = (BoEnt)this.get((Serializable)((Object)entId));
        List<BoAttribute> list = this.boAttributeManager.getByBoEnt(boEnt);
        boEnt.setBoAttrList(list);
        return boEnt;
    }

    @Override
    public BoEnt getByName(String name) {
        BoEnt boEnt = ((BoEntDao)this.baseMapper).getByName(name);
        if (BeanUtils.isNotEmpty((Object)((Object)boEnt))) {
            List<BoAttribute> list = this.boAttributeManager.getByBoEnt(boEnt);
            boEnt.setBoAttrList(list);
        }
        return boEnt;
    }

    @Override
    public int getCanEditByName(String name) {
        return 1;
    }

    void handleAttr(List<BoAttribute> removeList, List<BoAttribute> addList, List<BoAttribute> updateList) {
        for (BoAttribute attr : removeList) {
            this.boAttributeManager.remove((Serializable)((Object)attr.getId()));
        }
        for (BoAttribute attr : addList) {
            this.boAttributeManager.create((Model)attr);
        }
        for (BoAttribute attr : updateList) {
            this.boAttributeManager.update((Model)attr);
        }
    }

    private List<BoAttribute> getRemoveList(List<BoAttribute> attrList, List<Column> columnList) {
        HashSet<String> attrSet = new HashSet<String>();
        for (Column col : columnList) {
            attrSet.add(col.getFieldName());
        }
        ArrayList<BoAttribute> list = new ArrayList<BoAttribute>();
        for (BoAttribute attr : attrList) {
            if (attrSet.contains(attr.getFieldName())) continue;
            list.add(attr);
        }
        return list;
    }

    private List<BoAttribute> getAddList(List<BoAttribute> attrList, List<Column> columnList, BoEnt boEnt) {
        HashMap<String, BoAttribute> attrMap = new HashMap<String, BoAttribute>();
        for (BoAttribute attr : attrList) {
            attrMap.put(attr.getFieldName(), attr);
        }
        ArrayList<BoAttribute> list = new ArrayList<BoAttribute>();
        for (Column column : columnList) {
            String fieldName = column.getFieldName();
            if (fieldName.equalsIgnoreCase(boEnt.getPk()) || StringUtil.isNotEmpty((String)boEnt.getFk()) && fieldName.equalsIgnoreCase(boEnt.getFk()) || attrMap.containsKey(column.getFieldName())) continue;
            BoAttribute attr = this.getByColumn(column);
            attr.setBoEnt(boEnt);
            attr.setEntId(boEnt.getId());
            list.add(attr);
        }
        return list;
    }

    private List<BoAttribute> getUpdateList(List<BoAttribute> attrList, List<Column> columnList, BoEnt boEnt) {
        HashSet<String> attrSet = new HashSet<String>();
        HashMap<String, String> attrMap = new HashMap<String, String>();
        for (BoAttribute attr : attrList) {
            attrSet.add(attr.getFieldName());
            attrMap.put(attr.getFieldName(), attr.getId());
        }
        ArrayList<BoAttribute> list = new ArrayList<BoAttribute>();
        for (Column column : columnList) {
            if (!attrSet.contains(column.getFieldName())) continue;
            BoAttribute attrTmp = this.getByColumn(column, (String)attrMap.get(column.getFieldName()));
            attrTmp.setBoEnt(boEnt);
            attrTmp.setEntId(boEnt.getId());
            list.add(attrTmp);
        }
        return list;
    }

    private BoAttribute getByColumn(Column column) {
        return this.getByColumn(column, null);
    }

    private BoAttribute getByColumn(Column column, String id) {
        BoAttribute attr = new BoAttribute();
        attr.setId(id == null ? UniqueIdUtil.getSuid() : id);
        attr.setName(column.getFieldName());
        attr.setFieldName(column.getFieldName());
        attr.setIsPk(false);
        attr.setIsRequired(column.getIsNull() ? 0 : 1);
        String columnType = column.getColumnType();
        if (columnType.equals("varchar")) {
            attr.setAttrLength(column.getCharLen());
        } else if (columnType.equals("number")) {
            attr.setAttrLength(column.getIntLen());
            attr.setDecimalLen(column.getDecimalLen());
        }
        attr.setFormat("");
        this.updateDateFormat(column.getFcolumnType(), attr);
        attr.setDataType(columnType);
        attr.setDesc(column.getComment());
        return attr;
    }

    private void updateDateFormat(String fcolumnType, BoAttribute attr) {
        if ("datetime".equals(fcolumnType) || "timestamp".equals(fcolumnType)) {
            attr.setFormat("yyyy-MM-dd HH:mm:ss");
        }
        if ("time".equals(fcolumnType)) {
            attr.setFormat("HH:mm:ss");
        }
        if ("date".equals(fcolumnType)) {
            attr.setFormat("yyyy-MM-dd");
        }
    }

    @Override
    public List<BoEnt> getByDefId(String defId) {
        List<BoEnt> list = ((BoEntDao)this.baseMapper).getByDefId(defId);
        for (BoEnt boEnt : list) {
            List<BoAttribute> attributes = this.boAttributeManager.getByBoEnt(boEnt);
            boEnt.setBoAttrList(attributes);
        }
        return list;
    }

    @Override
    public List<BoEnt> getByTableName(String tableName) {
        return ((BoEntDao)this.baseMapper).getByTableName(tableName);
    }

    @Override
    public List<BoEnt> getBySubEntId(String entId) {
        List<BoEnt> list = ((BoEntDao)this.baseMapper).getBySubEntId(entId);
        if (BeanUtils.isNotEmpty(list)) {
            for (BoEnt boEnt : list) {
                List<BoAttribute> attributes = this.boAttributeManager.getByBoEnt(boEnt);
                boEnt.setBoAttrList(attributes);
            }
        }
        return list;
    }

    @Override
    public void deleteByDefId(String defId) {
        ((BoEntDao)this.baseMapper).deleteByDefId(defId);
    }

    @Override
    @Transactional
    public ObjectNode reloadByEntId(String entId, String alias) throws IOException {
        if (BeanUtils.isNotEmpty((Object)alias)) {
            this.boDefManager.delBodefFromCache(alias);
        }
        BoEnt boEnt = (BoEnt)this.get((Serializable)((Object)entId));
        String dsAlias = boEnt.getDsName();
        String tableName = boEnt.getTableName();
        List<BoAttribute> attrList = this.boAttributeManager.getByEntId(entId);
        Table table = null;
        try (DatabaseSwitchResult dResult = this.databaseContext.setDataSource(dsAlias);){
            BaseTableMeta baseTableMeta = MetaDataUtil.getBaseTableMetaAfterSetDT((String)dResult.getDbType());
            table = baseTableMeta.getTableByName(tableName);
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
        List<BoAttribute> removeList = this.getRemoveList(attrList, table.getColumnList());
        List<BoAttribute> addList = this.getAddList(attrList, table.getColumnList(), boEnt);
        List<BoAttribute> updateList = this.getUpdateList(attrList, table.getColumnList(), boEnt);
        this.handleAttr(removeList, addList, updateList);
        IBoEntHandler handler = (IBoEntHandler)AppUtil.getBean(IBoEntHandler.class);
        if (handler != null) {
            handler.handlerEntChange(boEnt, removeList, addList);
        }
        return null;
    }

    private void removePKFKColumnList(Table table, BoEnt boEnt) {
        List columnList = table.getColumnList();
        ArrayList<Column> newColumnList = new ArrayList<Column>();
        for (Column column : columnList) {
            String fieldName = column.getFieldName();
            if (fieldName.equalsIgnoreCase(boEnt.getPk()) || StringUtil.isNotEmpty((String)boEnt.getFk()) && fieldName.equalsIgnoreCase(boEnt.getFk())) continue;
            newColumnList.add(column);
        }
        table.setColumnList(newColumnList);
    }
}

