/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.IntegrationService;
import net.qiyuesuo.sdk.bean.integration.SyncConditionRequest;
import net.qiyuesuo.sdk.bean.integration.SyncRegulation;
import net.qiyuesuo.sdk.bean.integration.ThirdIntegrationProperties;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.common.http.HttpParamers;
import net.qiyuesuo.sdk.common.json.JSONUtils;
import net.qiyuesuo.sdk.common.utils.MapUtils;
import net.qiyuesuo.sdk.common.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegrationServiceImpl
implements IntegrationService {
    private final SDKClient client;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public IntegrationServiceImpl(SDKClient client) {
        this.client = client;
    }

    @Override
    public ThirdIntegrationProperties save(ThirdIntegrationProperties thirdIntegrationProperties) throws PrivateAppException {
        Map<String, Object> result = this.client.doServiceWithJson("/thirdintegration/save", JSONUtils.toJson(thirdIntegrationProperties));
        Map appTokenMap = (Map)result.get("result");
        ThirdIntegrationProperties response = null;
        try {
            response = MapUtils.toObject(appTokenMap, ThirdIntegrationProperties.class);
        }
        catch (Exception e) {
            throw new PrivateAppException("\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return response;
    }

    @Override
    public void saveSyncRegulation(SyncConditionRequest request) throws PrivateAppException {
        this.logger.info("\u4fdd\u5b58\u540c\u6b65\u89c4\u5219\u83b7\u53d6\u5230\u53c2\u6570:{}", (Object)JSONUtils.toJson(request));
        this.client.doServiceWithJson("/thirdintegration/sync/regulation", JSONUtils.toJson(request));
    }

    @Override
    public List<SyncRegulation> getSyncRegulation(String source) throws PrivateAppException {
        if (StringUtils.isBlank(source)) {
            source = "ECOLOGY";
        }
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("source", source);
        Map<String, Object> result = this.client.doService("/thirdintegration/sync/regulation", paramers);
        System.out.println(result);
        List list = (List)result.get("result");
        ArrayList<SyncRegulation> syncRegulations = new ArrayList<SyncRegulation>();
        try {
            for (LinkedHashMap map : list) {
                SyncRegulation regulation = MapUtils.toObject(map, SyncRegulation.class);
                syncRegulations.add(regulation);
            }
        }
        catch (Exception e) {
            throw new PrivateAppException("\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return syncRegulations;
    }

    @Override
    public void mannualSync() throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        this.client.doService("/thirdintegration/manual", paramers);
    }
}

