package com.artfess.examine.vo;

import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 科目题目类型统计
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-11-04
 */
@Data
@ApiModel(value="SubjectQuestionTypeVo对象", description="科目题目类型统计")
public class QuestionAnalysisVo {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "试题类型分布（类型百分比统计加列表数据）")
    private List<SubjectQuestionTypeVo> questionTypeVos;

    @ApiModelProperty(value = "课目id")
    private String id;

    @ApiModelProperty(value = "试题难度百分比统计")
    private JSONObject difficultPercentage;


}
