package com.artfess.examine.vo;

import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 试卷分析vo
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-11-21
 */
@Data
public class PaperAnalysisVo {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "试题总数")
    private Integer questionCount;

    @ApiModelProperty(value = "试卷总数")
    private Integer paperCount;

    @ApiModelProperty(value = "科目总数")
    private Integer subjectCount;

    @ApiModelProperty(value = "考生人数")
    private Integer userCount;

    @ApiModelProperty(value = "题型分析")
    private List<SubjectQuestionTypeVo> questionTypeList;

    @ApiModelProperty(value = "难易占比")
    private List<JSONObject> difficulty;

}
