package com.artfess.examine.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 试卷配置信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
@Data
@ApiModel(value="ExamPaperSetting对象", description="试卷配置信息")
public class ExamPaperSetting extends BaseModel<ExamPaperSetting> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "试卷id")
    @TableField("paper_id_")
    private String paperId;

    @ApiModelProperty(value = "及格分数")
    @TableField("pass_score_")
    private BigDecimal passScore;

    @ApiModelProperty(value = "考试时长（分钟）")
    @TableField("time_length_")
    private BigDecimal timeLength;

    @ApiModelProperty(value = "考试开始时间")
    @TableField("plan_start_time_")
    private LocalDateTime planStartTime;

    @ApiModelProperty(value = "考试结束时间")
    @TableField("plan_end_time_")
    private LocalDateTime planEndTime;

    @ApiModelProperty(value = "阅卷方式【字典】（1：系统，2：人工）")
    @TableField("train_model_")
    private Integer trainModel;

    @ApiModelProperty(value = "考试场地")
    @TableField("room_id_")
    private String roomId;

    @ApiModelProperty(value = "监考人员")
    @TableField("jk_person_id_")
    private String jkPersonId;

    @ApiModelProperty(value = "阅卷人员")
    @TableField("yj_person_id_")
    private String yjPersonId;

    @ApiModelProperty(value = "试卷状态【字典】（0：未发布，1：考试中，2：已结束）")
    @TableField("status_")
    private String status;

    @ApiModelProperty(value = "页面切换次数达到配置数量自动交卷")
    @TableField("switch_count_")
    private Integer switchCount;

    @ApiModelProperty(value = "参考人员（1：所有人  2：用户）")
    @TableField("test_user_type_")
    private String testUserType;

    @ApiModelProperty(value = "试卷名称")
    @TableField(exist = false)
    private String paperName;


}
