package com.artfess.data.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 训练使用物资
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-11-14
 */
@Data
@ApiModel(value="BizTrainMaterial对象", description="训练使用物资")
public class BizTrainMaterial extends BaseModel<BizTrainMaterial> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "计划id")
    @TableField("plan_id_")
    private String planId;

    @ApiModelProperty(value = "消耗指标ID")
    @TableField("index_id_")
    private String indexId;

    @ApiModelProperty(value = "消耗指标名称")
    @TableField("index_name_")
    private String indexName;

    @ApiModelProperty(value = "指标类型【字典】（1：弹药、2：油料、3：摩托小时）")
    @TableField("type_")
    private String type;

    @ApiModelProperty(value = "计划使用数量")
    @TableField("plan_number_")
    private BigDecimal planNumber;

//    @ApiModelProperty(value = "实际使用数量")
//    @TableField("reality_number_")
//    private BigDecimal realityNumber;

    @ApiModelProperty(value = "计量单位【字典】")
    @TableField("unit_")
    private String unit;

    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "排序（按照类型排序）")
    @TableField("sn_")
    private Integer sn;

    @ApiModelProperty(value = "数据时间戳")
    @TableField(updateStrategy=FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=true)
    private LocalDateTime lastTime;

}
