package com.artfess.data.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.data.manager.BizTrainQuestionDataManager;
import com.artfess.data.model.BizTrainQuestionData;
import com.artfess.poi.util.ExcelUtils;
import com.artfess.poi.util.FileDownloadUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 训练问题数据 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-09-02
 */
@Slf4j
@RestController
@Api(tags = "训练数据-训练问题数据")
@RequestMapping("/biz/trainQuestion/data/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizTrainQuestionDataController extends BaseController<BizTrainQuestionDataManager, BizTrainQuestionData> {

    @ApiOperation(value = "导入")
    @PostMapping("/importExcel")
    public CommonResult<String> importExcel(@RequestParam("file") MultipartFile file, String planId) {
        try {
            ExcelUtils<BizTrainQuestionData> excelUtil = new ExcelUtils<>(BizTrainQuestionData.class);
            List<BizTrainQuestionData> list = excelUtil.importExcel(null, file.getInputStream());
            baseService.saveList(list);
            return new CommonResult<>();
        } catch (Exception e) {
            throw new IllegalArgumentException("导入失败," + e.getMessage());
        }
    }

    @ApiOperation(value = "导出")
    @PostMapping("/export")
    public void export(HttpServletResponse response, HttpServletRequest request,
                       @ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BizTrainQuestionData> queryFilter) throws Exception {
        PageList<BizTrainQuestionData> page = baseService.query(queryFilter);
        ExcelUtils<BizTrainQuestionData> util = new ExcelUtils<BizTrainQuestionData>(BizTrainQuestionData.class);
        util.exportExcel(response, request, page.getRows(), "训练问题数据");
    }

    /**
     * 下载导入模板
     *
     * @param response
     * @return
     */
    @ApiOperation(value = "下载导入模板")
    @GetMapping("/downModel")
    public void downTemplate(HttpServletResponse response) {
        try {
            ClassPathResource classPathResource = new ClassPathResource("model/训练管理数据/训练问题数据.xlsx");
            FileDownloadUtil.fileDownload(response, classPathResource.getInputStream(), "训练问题数据模板.xlsx");
        } catch (Exception e) {
            response.setCharacterEncoding("utf-8");
            throw new RequiredException("你所下载的资源不存在");
        }
    }
}
