package com.artfess.examine.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.examine.model.ExamSubjectInfo;
import com.artfess.examine.model.ExamSubjectPos;
import com.artfess.examine.model.ExamSubjectType;
import com.artfess.examine.vo.SubjectReqVo;
import com.artfess.examine.vo.UserInfoVo;

import java.util.List;

/**
 * 训练考试科目 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
public interface ExamSubjectInfoManager extends BaseManager<ExamSubjectInfo> {

    List<ExamSubjectType> getTree(ExamSubjectInfo entity);

    void subjectBindPosition(ExamSubjectInfo entity);

    boolean updateInfo(ExamSubjectInfo t);

    List<ExamSubjectPos> findByBindPos(String id);

    boolean createInfo(ExamSubjectInfo t);

    List<ExamSubjectPos> findBySubjectIds(SubjectReqVo t);

    List<ExamSubjectInfo> findByMajorIds(SubjectReqVo t);

    ExamSubjectInfo findById(String id);

    PageList<ExamSubjectInfo> findByPage(QueryFilter<ExamSubjectInfo> queryFilter);

    List<ExamSubjectInfo> getSubjectList(SubjectReqVo t);

    List<UserInfoVo> getSubjectUserList(SubjectReqVo t);

    PageList<ExamSubjectInfo> notSubjectPage(QueryFilter<ExamSubjectInfo> queryFilter);

    boolean importExcel(List<ExamSubjectInfo> list);

    PageList<UserInfoVo> coachSubjectList(QueryFilter<ExamSubjectInfo> queryFilter);
}
