package com.artfess.examine.job;

import com.artfess.examine.manager.ExamOrgEvaluationManager;
import com.artfess.job.model.BaseJob;
import lombok.extern.slf4j.Slf4j;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * 年度综合成绩评定
 */
@Slf4j
public class AsyncOrgJob extends BaseJob {

	@Resource
	private ExamOrgEvaluationManager orgEvaluationManager;


	@Override
	@Transactional(rollbackFor = Exception.class)
	public void executeJob(JobExecutionContext context)  {
		try {
			orgEvaluationManager.createOrgEvaluation();
		}catch (Exception e) {
			log.error("年度综合成绩评定失败：{}", e.getMessage());
		}

		JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
	}

}
