package com.artfess.data.vo;

import com.artfess.data.model.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
@ApiModel(value = "PersonalProfileVo对象", description = "个人档案")
public class PersonalProfileVo {

    /**
     * 个人基本信息
     */
    @ApiModelProperty(value = "个人基本信息")
    private BizUserBasic bizUserBasic;

    @ApiModelProperty(value = "XXX资质及成果表（按年度统计表）")
    private BizUserAchieveStatic bizUserAchieveStatic;

    @ApiModelProperty(value = "xxx成绩与奖惩表（按年度统计表）")
    private BizUserGradeStatic bizUserGradeStatic;

    @ApiModelProperty(value = "xxx经历表（按年统计表）")
    private List<BizUserThroughStatic> bizUserThroughStaticList;

    @ApiModelProperty(value = "xxx工作简历表")
    private List<BizUserWorkDetail> bizUserWorkDetailList;

    @ApiModelProperty(value = "年度考生综合评定表")
    private List<ExamUserEvaluationVo> examUserEvaluationVoList;

}
