package com.artfess.data.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * xxx经历表（按年统计表）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 超级管理员
 * @since 2024-12-27
 */
@ApiModel(value="BizUserThroughStatic对象", description="xxx经历表（按年统计表）")
public class BizUserThroughStatic extends BaseModel<BizUserThroughStatic> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "id_")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "人员档案id（外键）")
    @TableField("user_archive_id_")
    private String userArchiveId;

    @ApiModelProperty(value = "人员姓名")
    @TableField("user_name_")
    private String userName;

    @ApiModelProperty(value = "身份证号")
    @TableField("identi_card_")
    private String identiCard;

    @ApiModelProperty(value = "经历分类（1xxx经历  2xxx经历）")
    @TableField("type_")
    private String type;

    @ApiModelProperty(value = "参加xxx")
    @TableField("field1_")
    private String field1;

    @ApiModelProperty(value = "参加xxx活动")
    @TableField("field2_")
    private String field2;

    @ApiModelProperty(value = "参加院校教育培训")
    @TableField("field3_")
    private String field3;

    @ApiModelProperty(value = "参加xxx竞赛")
    @TableField("field4_")
    private String field4;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUserArchiveId() {
        return userArchiveId;
    }

    public void setUserArchiveId(String userArchiveId) {
        this.userArchiveId = userArchiveId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getIdentiCard() {
        return identiCard;
    }

    public void setIdentiCard(String identiCard) {
        this.identiCard = identiCard;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getField1() {
        return field1;
    }

    public void setField1(String field1) {
        this.field1 = field1;
    }

    public String getField2() {
        return field2;
    }

    public void setField2(String field2) {
        this.field2 = field2;
    }

    public String getField3() {
        return field3;
    }

    public void setField3(String field3) {
        this.field3 = field3;
    }

    public String getField4() {
        return field4;
    }

    public void setField4(String field4) {
        this.field4 = field4;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizUserThroughStatic{" +
            "id=" + id +
            ", userArchiveId=" + userArchiveId +
            ", userName=" + userName +
            ", identiCard=" + identiCard +
            ", type=" + type +
            ", field1=" + field1 +
            ", field2=" + field2 +
            ", field3=" + field3 +
            ", field4=" + field4 +
        "}";
    }
}
