package com.artfess.examine.dao;

import com.artfess.examine.model.ExamSubjectInfo;
import com.artfess.examine.model.ExamYearAssessmentSub;
import com.artfess.examine.vo.UserInfoVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 年度考核课目 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-11-25
 */
public interface ExamYearAssessmentSubDao extends BaseMapper<ExamYearAssessmentSub> {

    List<UserInfoVo> getUserInfoList(@Param("positionId") String positionId);

    IPage<ExamSubjectInfo> findByPage(IPage<ExamYearAssessmentSub> convert2IPage,
                                      @Param(Constants.WRAPPER) Wrapper<ExamYearAssessmentSub> convert2Wrapper, @Param("vo") Map<String, Object> params);
}
