package com.artfess.data.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.data.dto.EditPersonalProfileDto;
import com.artfess.data.model.BizUserBasic;
import com.artfess.data.vo.PersonalProfileVo;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 个人信息基本情况表 服务类
 *
 * @author 超级管理员
 * @company 阿特菲斯信息技术有限公司
 * @since 2024-12-27
 */
public interface BizUserBasicManager extends BaseManager<BizUserBasic> {

    /**
     * 获取个人档案
     *
     * @return 个人档案
     */
    PersonalProfileVo getPersonalProfile();

    /**
     * 获取个人档案
     *
     * @return 个人档案
     */
    PersonalProfileVo getPersonalProfile(String year, String userId);

    /**
     * 创建个人档案
     *
     * @param editPersonalProfileDto 个人档案
     */
    void editPersonalProfile(EditPersonalProfileDto editPersonalProfileDto);

    /**
     * 上传个人图片，返回URL
     *
     * @param file 文件
     * @return URL
     */
    String uploadImage(MultipartFile file);

    void download(String fileName, HttpServletResponse response);

    /**
     * 导出勾选用户的个人档案
     *
     * @param userIds  用户ID集合
     * @param response 响应头
     */
    void export(List<String> userIds, Integer year, HttpServletResponse response);
}
