package com.artfess.data.manager;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.data.model.BizExamPlan;
import com.artfess.data.vo.TrainReqVo;

import java.util.List;

/**
 * 年度训练计划数据 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-09-02
 */
public interface BizExamPlanManager extends BaseManager<BizExamPlan> {

    boolean saveInfo(BizExamPlan t);

    boolean updateInfo(BizExamPlan t);

    void updateStatus(String id);

    void addUser(BizExamPlan t);

    void updatePlanStatus();

    void saveList(List<BizExamPlan> list, String planType);

    List<JSONObject> planStatistical();

    List<JSONObject> trainPlanStylolitic(TrainReqVo reqVo);

    List<JSONObject> orgYearTrainPlan(TrainReqVo reqVo);

    BizExamPlan findById(String id);

    PageList<BizExamPlan> myTrainPlan(QueryFilter<BizExamPlan> queryFilter);

    PageList<BizExamPlan> monthPlanStatistical(QueryFilter<BizExamPlan> queryFilter);

    PageList<BizExamPlan> findByPage(QueryFilter<BizExamPlan> queryFilter);

    /**
     * 分页查询重写，获取剩余学习时长
     *
     * @param queryFilter 分页条件
     * @return 结果
     */
    PageList<BizExamPlan> queryInfo(QueryFilter<BizExamPlan> queryFilter);
}
